/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ome.conditions.ValidationException;
import ome.security.auth.AttributeSet;
import ome.security.auth.GroupAttributeMapper;
import ome.security.auth.LdapConfig;
import ome.security.auth.NewUserGroupBean;
import ome.security.auth.NewUserGroupOwnerBean;
import ome.security.auth.RoleProvider;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;
import org.springframework.util.PropertyPlaceholderHelper;

public class QueryNewUserGroupBean
implements NewUserGroupBean,
NewUserGroupOwnerBean {
    private static final Logger log = LoggerFactory.getLogger(QueryNewUserGroupBean.class);
    private final String grpQuery;

    public QueryNewUserGroupBean(String grpQuery) {
        this.grpQuery = grpQuery;
    }

    private String parseQuery(final AttributeSet attrSet, final String query) {
        PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("@{", "}", null, false);
        return helper.replacePlaceholders(query, new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String arg0) {
                if (attrSet.size(arg0) > 1) {
                    throw new ValidationException("Multivalued property used in @{} format:" + query + "=" + attrSet.getAll(arg0).toString());
                }
                return attrSet.getFirst(arg0);
            }
        });
    }

    private List<Long> _groups(boolean owner, String username, LdapConfig config, LdapOperations ldap, RoleProvider provider, AttributeSet attrSet) {
        String query = this.parseQuery(attrSet, this.grpQuery);
        String ownerQuery = null;
        if (owner) {
            ownerQuery = config.getNewUserGroupOwner();
            if (StringUtils.isBlank((String)ownerQuery)) {
                log.debug("Owner query disabled");
                return Collections.emptyList();
            }
            ownerQuery = this.parseQuery(attrSet, ownerQuery);
        }
        AndFilter and = new AndFilter();
        and.and(config.getGroupFilter());
        and.and((Filter)new HardcodedFilter(query));
        if (owner) {
            and.and((Filter)new HardcodedFilter(ownerQuery));
        }
        log.debug("Running query: {}", (Object)and.encode());
        List groupNames = ldap.search("", and.encode(), (AttributesMapper)new GroupAttributeMapper(config));
        ArrayList<Long> groups = new ArrayList<Long>(groupNames.size());
        for (String groupName : groupNames) {
            groups.add(provider.createGroup(groupName, null, false, true));
        }
        return groups;
    }

    @Override
    public List<Long> groups(String username, LdapConfig config, LdapOperations ldap, RoleProvider provider, AttributeSet attrSet) {
        return this._groups(false, username, config, ldap, provider, attrSet);
    }

    @Override
    public List<Long> ownerOfGroups(String username, LdapConfig config, LdapOperations ldap, RoleProvider provider, AttributeSet attrSet) {
        return this._groups(true, username, config, ldap, provider, attrSet);
    }
}

