/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import ome.conditions.ApiUsageException;
import ome.parameters.Parameters;
import ome.services.query.Query;
import ome.services.query.QueryException;
import ome.services.query.QuerySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFactory {
    private static Logger log = LoggerFactory.getLogger(QueryFactory.class);
    protected QuerySource[] sources;

    private QueryFactory() {
    }

    public QueryFactory(QuerySource ... querySources) {
        if (querySources == null || querySources.length == 0) {
            throw new ApiUsageException("QuerySource[] argument to QueryFactory constructor may not be null or empty.");
        }
        int size = querySources.length;
        this.sources = new QuerySource[size];
        System.arraycopy(querySources, 0, this.sources, 0, size);
    }

    public <T> Query<T> lookup(String queryID, Parameters params) {
        QuerySource source;
        Query q = null;
        QuerySource[] querySourceArray = this.sources;
        int n = querySourceArray.length;
        for (int i = 0; i < n && (q = (source = querySourceArray[i]).lookup(queryID, params)) == null; ++i) {
        }
        if (q == null) {
            throw new QueryException("No query found for queryID=" + queryID);
        }
        return q;
    }
}

