/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import java.util.Collection;
import ome.conditions.ApiUsageException;
import ome.parameters.QueryParameter;

public class QueryParameterDef {
    public final String name;
    public final Class type;
    public final boolean optional;

    public QueryParameterDef(String name, Class type, boolean optional) {
        if (name == null) {
            throw new ApiUsageException("Name cannot be null.");
        }
        if (type == null) {
            throw new ApiUsageException("Type cannot be null.");
        }
        this.name = name;
        this.type = type;
        this.optional = optional;
    }

    public void errorIfInvalid(QueryParameter parameter) {
        if (parameter == null) {
            if (!this.optional) {
                throw new ApiUsageException("Non-optional parameter cannot be null.");
            }
        } else {
            if (parameter.name == null || !parameter.name.equals(this.name)) {
                throw new ApiUsageException(String.format("Parameter name does not match: %s != %s ", this.name, parameter.name));
            }
            if (parameter.type == null) {
                if (!this.optional) {
                    throw new ApiUsageException("Non-optional parameter type cannot be null.");
                }
            } else if (parameter.value == null) {
                if (!this.optional) {
                    throw new ApiUsageException("Non-optional parameter " + this.name + " may not be null.");
                }
            } else {
                if (!this.type.isAssignableFrom(parameter.type)) {
                    throw new ApiUsageException(String.format(" Type of parameter %s doesn't match: %s != %s", this.name, this.type, parameter.type));
                }
                if (!this.optional && Collection.class.isAssignableFrom(this.type) && ((Collection)parameter.value).size() < 1) {
                    throw new ApiUsageException("Non-optional collections may not be empty.");
                }
            }
        }
    }
}

