/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import ome.util.SqlAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public class ReadOnlyStatus {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyStatus.class);
    private final boolean isReadOnlyDb;
    private final boolean isReadOnlyRepo;

    public ReadOnlyStatus(boolean isReadOnlyDb, boolean isReadOnlyRepo) {
        this.isReadOnlyDb = isReadOnlyDb;
        this.isReadOnlyRepo = isReadOnlyRepo;
    }

    public ReadOnlyStatus(boolean isReadOnly, boolean isReadOnlyDb, boolean isReadOnlyRepo, SqlAction sqlAction, String omeroDataDir, String omeroManagedDir) throws SQLException {
        this.isReadOnlyDb = isReadOnly || isReadOnlyDb || !this.canWriteDb(sqlAction);
        this.isReadOnlyRepo = isReadOnly || isReadOnlyRepo || !this.canWriteDir(omeroDataDir) || !this.canWriteDir(omeroManagedDir);
        log.info("read-only status: db={}, repo={}", (Object)this.isReadOnlyDb, (Object)this.isReadOnlyRepo);
    }

    private boolean canWriteDb(SqlAction sqlAction) {
        try {
            sqlAction.deleteCurrentAdminPrivileges();
            return true;
        }
        catch (InvalidDataAccessResourceUsageException idarue) {
            log.debug("cannot write to database", (Throwable)idarue);
            log.warn("not configured for read-only database but assuming read-only anyway");
            return false;
        }
    }

    private boolean canWriteDir(String directoryName) {
        try {
            File directory = new File(directoryName);
            directory.mkdirs();
            File.createTempFile(this.getClass().getSimpleName(), null, directory).delete();
            return true;
        }
        catch (IOException ioe) {
            log.debug("cannot write to binary repository", (Throwable)ioe);
            log.warn("not configured for read-only binary repository but assuming read-only anyway");
            return false;
        }
    }

    public boolean isReadOnlyDb() {
        return this.isReadOnlyDb;
    }

    public boolean isReadOnlyRepo() {
        return this.isReadOnlyRepo;
    }

    public static interface IsAware {
        public boolean isReadOnly(ReadOnlyStatus var1);
    }
}

