/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import ome.tools.hibernate.SqlArray;
import org.hibernate.HibernateException;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public abstract class ListAsSQLArrayUserType<T>
implements UserType,
ParameterizedType {
    private static final int SQL_TYPE = 2003;
    private static final int[] SQL_TYPES = new int[]{2003};
    private String profile;
    protected ArrayFactory factory;

    public void setParameterValues(Properties parameters) {
        this.profile = parameters.getProperty("profile");
        try {
            Class<?> FACTORY = Class.forName("ome.tools.hibernate." + this.profile.toUpperCase());
            Field field = FACTORY.getField("ARRAY_FACTORY");
            this.factory = (ArrayFactory)field.get(null);
        }
        catch (ClassNotFoundException e) {
            this.factory = SqlArray.FACTORY;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to acquire factory for profile " + this.profile, e);
        }
    }

    protected abstract Array getDataAsArray(Connection var1, Object var2) throws SQLException;

    protected abstract List<T> getDataFromArray(Object var1);

    public Class returnedClass() {
        return List.class;
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public boolean isMutable() {
        return true;
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, Object owner) throws HibernateException, SQLException {
        Array sqlArray = resultSet.getArray(names[0]);
        if (resultSet.wasNull()) {
            return null;
        }
        return this.getDataFromArray(sqlArray.getArray());
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index) throws HibernateException, SQLException {
        if (null == value) {
            preparedStatement.setNull(index, 2003);
        } else {
            preparedStatement.setArray(index, this.getDataAsArray(preparedStatement.getConnection(), value));
        }
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (null == x || null == y) {
            return false;
        }
        Class javaClass = this.returnedClass();
        if (!javaClass.equals(x.getClass()) || !javaClass.equals(y.getClass())) {
            return false;
        }
        return x.equals(y);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public static class ENUM<E extends Enum<E>>
    extends ListAsSQLArrayUserType<E> {
        private E[] theEnumValues;

        protected ENUM(E[] theEnumValues) {
            this.theEnumValues = theEnumValues;
        }

        @Override
        protected Array getDataAsArray(Connection conn, Object value) throws SQLException {
            List enums = (List)value;
            ArrayList<Integer> integers = new ArrayList<Integer>(enums.size());
            for (Enum theEnum : enums) {
                integers.add(theEnum.ordinal());
            }
            return this.factory.INTEGER(conn, integers);
        }

        @Override
        protected List<E> getDataFromArray(Object array) {
            int[] ints = (int[])array;
            ArrayList<E> result = new ArrayList<E>(ints.length);
            block0: for (int val : ints) {
                for (int i = 0; i < this.theEnumValues.length; ++i) {
                    if (((Enum)this.theEnumValues[i]).ordinal() != val) continue;
                    result.add(this.theEnumValues[i]);
                    continue block0;
                }
            }
            if (result.size() != ints.length) {
                throw new RuntimeException("Error attempting to convert " + array + " into an array of enums (" + this.theEnumValues + ").");
            }
            return result;
        }
    }

    public static class DATE
    extends ListAsSQLArrayUserType<Date> {
        @Override
        protected Array getDataAsArray(Connection conn, Object value) throws SQLException {
            return this.factory.DATE(conn, (List)value);
        }

        @Override
        protected List<Date> getDataFromArray(Object array) {
            Date[] dates = (Date[])array;
            ArrayList<Date> result = new ArrayList<Date>(dates.length);
            for (Date d : dates) {
                result.add(d);
            }
            return result;
        }
    }

    public static class STRING2
    extends ListAsSQLArrayUserType<String[]> {
        @Override
        protected Array getDataAsArray(Connection conn, Object value) throws SQLException {
            return this.factory.STRING2(conn, (List)value);
        }

        @Override
        protected List<String[]> getDataFromArray(Object array) {
            String[] strings;
            if (String[][].class.isAssignableFrom(array.getClass())) {
                String[][] strings2 = (String[][])array;
                ArrayList<String[]> result = new ArrayList<String[]>(strings2.length);
                for (String[] s : strings2) {
                    result.add(s);
                }
                return result;
            }
            if (String[].class.isAssignableFrom(array.getClass()) && (strings = (String[])array).length == 0) {
                return new ArrayList<String[]>(0);
            }
            throw new RuntimeException("ticket:2290 - bad array type: " + array);
        }
    }

    public static class STRING
    extends ListAsSQLArrayUserType<String> {
        @Override
        protected Array getDataAsArray(Connection conn, Object value) throws SQLException {
            return this.factory.STRING(conn, (List)value);
        }

        @Override
        protected List<String> getDataFromArray(Object array) {
            String[] strings = (String[])array;
            ArrayList<String> result = new ArrayList<String>(strings.length);
            for (String s : strings) {
                result.add(s);
            }
            return result;
        }
    }

    public static class DOUBLE
    extends ListAsSQLArrayUserType<Double> {
        @Override
        protected Array getDataAsArray(Connection conn, Object value) throws SQLException {
            return this.factory.DOUBLE(conn, (List)value);
        }

        @Override
        protected List<Double> getDataFromArray(Object array) {
            double[] doubles = (double[])array;
            ArrayList<Double> result = new ArrayList<Double>(doubles.length);
            for (double d : doubles) {
                result.add(d);
            }
            return result;
        }
    }

    public static class FLOAT
    extends ListAsSQLArrayUserType<Float> {
        @Override
        protected Array getDataAsArray(Connection conn, Object value) throws SQLException {
            return this.factory.FLOAT(conn, (List)value);
        }

        @Override
        protected List<Float> getDataFromArray(Object array) {
            float[] floats = (float[])array;
            ArrayList<Float> result = new ArrayList<Float>(floats.length);
            for (float f : floats) {
                result.add(Float.valueOf(f));
            }
            return result;
        }
    }

    public static class INTEGER
    extends ListAsSQLArrayUserType<Integer> {
        @Override
        protected Array getDataAsArray(Connection conn, Object value) throws SQLException {
            return this.factory.INTEGER(conn, (List)value);
        }

        @Override
        protected List<Integer> getDataFromArray(Object array) {
            int[] ints = (int[])array;
            ArrayList<Integer> result = new ArrayList<Integer>(ints.length);
            for (int i : ints) {
                result.add(i);
            }
            return result;
        }
    }

    public static class BOOLEAN
    extends ListAsSQLArrayUserType<Boolean> {
        @Override
        protected Array getDataAsArray(Connection conn, Object value) throws SQLException {
            return this.factory.BOOLEAN(conn, (List)value);
        }

        @Override
        protected List<Boolean> getDataFromArray(Object array) {
            boolean[] booleans = (boolean[])array;
            ArrayList<Boolean> result = new ArrayList<Boolean>(booleans.length);
            for (boolean b : booleans) {
                result.add(b);
            }
            return result;
        }
    }

    public static interface ArrayFactory {
        public Array BOOLEAN(Connection var1, List<Boolean> var2) throws SQLException;

        public Array DATE(Connection var1, List<Date> var2) throws SQLException;

        public Array DOUBLE(Connection var1, List<Double> var2) throws SQLException;

        public Array FLOAT(Connection var1, List<Float> var2) throws SQLException;

        public Array INTEGER(Connection var1, List<Integer> var2) throws SQLException;

        public Array STRING(Connection var1, List<String> var2) throws SQLException;

        public Array STRING2(Connection var1, List<String[]> var2) throws SQLException;
    }
}

