/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import java.io.Serializable;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealIntegrator;

public abstract class UnivariateRealIntegratorImpl
implements UnivariateRealIntegrator,
Serializable {
    static final long serialVersionUID = -3365294665201465048L;
    protected double relativeAccuracy;
    protected int maximalIterationCount;
    protected int minimalIterationCount;
    protected double defaultRelativeAccuracy;
    protected int defaultMaximalIterationCount;
    protected int defaultMinimalIterationCount;
    protected boolean resultComputed = false;
    protected double result;
    protected int iterationCount;
    protected UnivariateRealFunction f;

    protected UnivariateRealIntegratorImpl(UnivariateRealFunction f, int defaultMaximalIterationCount) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("Function can not be null.");
        }
        this.f = f;
        this.defaultMaximalIterationCount = defaultMaximalIterationCount;
        this.maximalIterationCount = defaultMaximalIterationCount;
        this.relativeAccuracy = this.defaultRelativeAccuracy = 1.0E-6;
        this.minimalIterationCount = this.defaultMinimalIterationCount = 3;
        this.verifyIterationCount();
    }

    public double getResult() throws IllegalStateException {
        if (this.resultComputed) {
            return this.result;
        }
        throw new IllegalStateException("No result available.");
    }

    public int getIterationCount() throws IllegalStateException {
        if (this.resultComputed) {
            return this.iterationCount;
        }
        throw new IllegalStateException("No result available.");
    }

    protected final void setResult(double result, int iterationCount) {
        this.result = result;
        this.iterationCount = iterationCount;
        this.resultComputed = true;
    }

    protected final void clearResult() {
        this.resultComputed = false;
    }

    public void setMaximalIterationCount(int count) {
        this.maximalIterationCount = count;
    }

    public int getMaximalIterationCount() {
        return this.maximalIterationCount;
    }

    public void resetMaximalIterationCount() {
        this.maximalIterationCount = this.defaultMaximalIterationCount;
    }

    public void setMinimalIterationCount(int count) {
        this.minimalIterationCount = count;
    }

    public int getMinimalIterationCount() {
        return this.minimalIterationCount;
    }

    public void resetMinimalIterationCount() {
        this.minimalIterationCount = this.defaultMinimalIterationCount;
    }

    public void setRelativeAccuracy(double accuracy) {
        this.relativeAccuracy = accuracy;
    }

    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    public void resetRelativeAccuracy() {
        this.relativeAccuracy = this.defaultRelativeAccuracy;
    }

    protected boolean isSequence(double start, double mid, double end) {
        return start < mid && mid < end;
    }

    protected void verifyInterval(double lower, double upper) throws IllegalArgumentException {
        if (lower >= upper) {
            throw new IllegalArgumentException("Endpoints do not specify an interval: [" + lower + ", " + upper + "]");
        }
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        if (!this.isSequence(0.0, this.minimalIterationCount, this.maximalIterationCount + 1)) {
            throw new IllegalArgumentException("Invalid iteration limits: min=" + this.minimalIterationCount + " max=" + this.maximalIterationCount);
        }
    }
}

