/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import loci.formats.IFormatReader;
import ome.api.IQuery;
import ome.conditions.SecurityViolation;
import ome.io.nio.ReaderSecurityCheck;
import ome.parameters.Parameters;
import ome.services.blitz.repo.path.FsFile;
import ome.services.blitz.repo.path.ServerFilePathTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedReaderSecurityCheck
implements ReaderSecurityCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedReaderSecurityCheck.class);
    private static final int BATCH_SIZE = 256;
    private final IQuery iQuery;
    private final Set<String> repoUuids;
    private final Map<String, ServerFilePathTransformer> repoServerPaths = new ConcurrentHashMap<String, ServerFilePathTransformer>();

    public ManagedReaderSecurityCheck(IQuery iQuery, Set<String> managedRepoUuids) {
        this.iQuery = iQuery;
        this.repoUuids = managedRepoUuids;
    }

    private long getFilesetId(String repository, String serverPath) {
        String serverPathTail;
        String serverPathHead;
        int lastSeparator = serverPath.lastIndexOf(FsFile.separatorChar);
        if (lastSeparator == -1) {
            serverPathHead = String.valueOf(FsFile.separatorChar);
            serverPathTail = serverPath;
        } else {
            serverPathHead = serverPath.substring(0, lastSeparator + 1);
            serverPathTail = serverPath.substring(serverPathHead.length());
        }
        String hql = "SELECT e.fileset.id FROM FilesetEntry AS e LEFT JOIN e.originalFile AS o WHERE o.repo = :repo AND o.path = :path AND o.name = :name";
        Parameters parameters = new Parameters().addString("repo", repository).addString("path", serverPathHead).addString("name", serverPathTail);
        List results = this.iQuery.projection("SELECT e.fileset.id FROM FilesetEntry AS e LEFT JOIN e.originalFile AS o WHERE o.repo = :repo AND o.path = :path AND o.name = :name", parameters);
        if (results.size() != 1) {
            String error = "file " + serverPath + " does not have a unique readable fileset";
            LOGGER.warn(error);
            throw new SecurityViolation(error);
        }
        return (Long)((Object[])results.get(0))[0];
    }

    /*
     * WARNING - void declaration
     */
    public void assertUsedFilesReadable(IFormatReader reader) throws SecurityViolation {
        void var8_13;
        Object[] result2;
        Sets.SetView missingRepos = Sets.difference(this.repoUuids, this.repoServerPaths.keySet());
        if (!missingRepos.isEmpty()) {
            String hql = "SELECT hash, path || name FROM OriginalFile WHERE hash IN (:repos) AND repo IS NULL and mimetype = 'Repository'";
            Parameters parameters = new Parameters().addSet("repos", (Set)missingRepos);
            for (Object[] result2 : this.iQuery.projection("SELECT hash, path || name FROM OriginalFile WHERE hash IN (:repos) AND repo IS NULL and mimetype = 'Repository'", parameters)) {
                String repo = (String)result2[0];
                String string = (String)result2[1];
                ServerFilePathTransformer serverPaths = new ServerFilePathTransformer();
                serverPaths.setBaseDirFile(new File(string));
                this.repoServerPaths.put(repo, serverPaths);
                LOGGER.info("noted managed repository {}", (Object)repo);
            }
        }
        LOGGER.debug("checking used files for " + reader.getCurrentFile());
        String[] usedFiles = reader.getUsedFiles();
        HashMultimap repoPaths = HashMultimap.create();
        ArrayList<Object> badPaths = new ArrayList<Object>();
        result2 = usedFiles;
        int repo = result2.length;
        boolean bl = false;
        while (var8_13 < repo) {
            Object usedFile = result2[var8_13];
            boolean isWithinRepo = false;
            for (Map.Entry<String, ServerFilePathTransformer> repoServerPath : this.repoServerPaths.entrySet()) {
                FsFile serverPath;
                String repo2 = repoServerPath.getKey();
                ServerFilePathTransformer serverPaths = repoServerPath.getValue();
                try {
                    serverPath = serverPaths.getFsFileFromServerFile(new File((String)usedFile).getAbsoluteFile());
                }
                catch (IllegalArgumentException iae) {
                    continue;
                }
                repoPaths.put((Object)repo2, (Object)serverPath.toString());
                isWithinRepo = true;
                break;
            }
            if (!isWithinRepo) {
                badPaths.add(usedFile);
            }
            ++var8_13;
        }
        if (!badPaths.isEmpty()) {
            StringBuilder errorBuilder = new StringBuilder();
            errorBuilder.append("reader for " + reader.getCurrentFile() + " accesses data outside managed repository:");
            for (String string : badPaths) {
                errorBuilder.append("\n\t");
                errorBuilder.append(string);
            }
            String error = errorBuilder.toString();
            LOGGER.warn(error);
            throw new SecurityViolation(error);
        }
        Map.Entry repoPathExample = (Map.Entry)repoPaths.entries().iterator().next();
        long filesetId = this.getFilesetId((String)repoPathExample.getKey(), (String)repoPathExample.getValue());
        String hql = "SELECT COUNT(DISTINCT o) FROM FilesetEntry AS e LEFT JOIN e.originalFile AS o WHERE e.fileset.id = :fileset AND o.repo = :repo AND o.path || o.name IN (:paths)";
        for (Map.Entry pathsOneRepo : repoPaths.asMap().entrySet()) {
            String repo3 = (String)pathsOneRepo.getKey();
            for (List paths : Iterables.partition((Iterable)((Iterable)pathsOneRepo.getValue()), (int)256)) {
                Parameters parameters = new Parameters().addLong("fileset", Long.valueOf(filesetId)).addString("repo", repo3).addList("paths", new ArrayList(paths));
                Object[] result3 = (Object[])this.iQuery.projection("SELECT COUNT(DISTINCT o) FROM FilesetEntry AS e LEFT JOIN e.originalFile AS o WHERE e.fileset.id = :fileset AND o.repo = :repo AND o.path || o.name IN (:paths)", parameters).get(0);
                if ((long)paths.size() == (Long)result3[0]) continue;
                String error = "reader for " + reader.getCurrentFile() + " uses file from repository " + repo3 + " that is not readable from database";
                LOGGER.warn(error);
                throw new SecurityViolation(error);
            }
        }
    }
}

