/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.RTime;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.IndexingJob;
import omero.model.Job;
import omero.model.JobOriginalFileLink;
import omero.model.JobOriginalFileLinkI;
import omero.model.JobStatus;
import omero.model.OriginalFile;
import omero.rtypes;
import omero.util.IceMapper;

public class IndexingJobI
extends IndexingJob
implements ModelBased {
    public static final String USERNAME = "ome.model.jobs.IndexingJob_username";
    public static final String GROUPNAME = "ome.model.jobs.IndexingJob_groupname";
    public static final String TYPE = "ome.model.jobs.IndexingJob_type";
    public static final String MESSAGE = "ome.model.jobs.IndexingJob_message";
    public static final String STATUS = "ome.model.jobs.IndexingJob_status";
    public static final String SUBMITTED = "ome.model.jobs.IndexingJob_submitted";
    public static final String SCHEDULEDFOR = "ome.model.jobs.IndexingJob_scheduledFor";
    public static final String STARTED = "ome.model.jobs.IndexingJob_started";
    public static final String FINISHED = "ome.model.jobs.IndexingJob_finished";
    public static final String ORIGINALFILELINKS = "ome.model.jobs.IndexingJob_originalFileLinks";
    public static final String DETAILS = "ome.model.jobs.IndexingJob_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.originalFileLinksSeq = new ArrayList();
            this.originalFileLinksLoaded = true;
        } else {
            this.originalFileLinksSeq = null;
            this.originalFileLinksLoaded = false;
        }
    }

    public IndexingJobI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public IndexingJobI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public IndexingJobI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadUsername();
        this.unloadGroupname();
        this.unloadType();
        this.unloadMessage();
        this.unloadStatus();
        this.unloadSubmitted();
        this.unloadScheduledFor();
        this.unloadStarted();
        this.unloadFinished();
        this.unloadOriginalFileLinks();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        IndexingJobI copy = new IndexingJobI();
        copy.id = this.id;
        copy.version = this.version;
        copy.username = this.username;
        copy.groupname = this.groupname;
        copy.type = this.type;
        copy.message = this.message;
        copy.status = this.status == null ? null : (JobStatus)this.status.proxy();
        copy.submitted = this.submitted;
        copy.scheduledFor = this.scheduledFor;
        copy.started = this.started;
        copy.finished = this.finished;
        if (!this.originalFileLinksLoaded) {
            copy.originalFileLinksLoaded = false;
            copy.originalFileLinksSeq = null;
        } else {
            copy.originalFileLinksLoaded = true;
            copy.originalFileLinksSeq = new ArrayList();
            for (JobOriginalFileLink item : this.originalFileLinksSeq) {
                copy.originalFileLinksSeq.add(item == null ? null : (JobOriginalFileLink)item.proxy());
            }
        }
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new IndexingJobI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadUsername() {
        this.username = null;
    }

    @Override
    public RString getUsername(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.username;
    }

    @Override
    public void setUsername(RString username, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.username = username;
    }

    private void copyUsername(ome.model.jobs.IndexingJob source, IceMapper mapper) {
        this.username = source.getUsername() == null ? null : rtypes.rstring(source.getUsername());
    }

    private void fillUsername(ome.model.jobs.IndexingJob target, IceMapper mapper) {
        try {
            target.setUsername((String)mapper.fromRType(this.getUsername()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadGroupname() {
        this.groupname = null;
    }

    @Override
    public RString getGroupname(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.groupname;
    }

    @Override
    public void setGroupname(RString groupname, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.groupname = groupname;
    }

    private void copyGroupname(ome.model.jobs.IndexingJob source, IceMapper mapper) {
        this.groupname = source.getGroupname() == null ? null : rtypes.rstring(source.getGroupname());
    }

    private void fillGroupname(ome.model.jobs.IndexingJob target, IceMapper mapper) {
        try {
            target.setGroupname((String)mapper.fromRType(this.getGroupname()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadType() {
        this.type = null;
    }

    @Override
    public RString getType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.type;
    }

    @Override
    public void setType(RString type, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.type = type;
    }

    private void copyType(ome.model.jobs.IndexingJob source, IceMapper mapper) {
        this.type = source.getType() == null ? null : rtypes.rstring(source.getType());
    }

    private void fillType(ome.model.jobs.IndexingJob target, IceMapper mapper) {
        try {
            target.setType((String)mapper.fromRType(this.getType()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadMessage() {
        this.message = null;
    }

    @Override
    public RString getMessage(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.message;
    }

    @Override
    public void setMessage(RString message, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.message = message;
    }

    private void copyMessage(ome.model.jobs.IndexingJob source, IceMapper mapper) {
        this.message = source.getMessage() == null ? null : rtypes.rstring(source.getMessage());
    }

    private void fillMessage(ome.model.jobs.IndexingJob target, IceMapper mapper) {
        try {
            target.setMessage((String)mapper.fromRType(this.getMessage()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadStatus() {
        this.status = null;
    }

    @Override
    public JobStatus getStatus(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.status;
    }

    @Override
    public void setStatus(JobStatus status, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.status = status;
    }

    private void copyStatus(ome.model.jobs.IndexingJob source, IceMapper mapper) {
        this.status = (JobStatus)mapper.findTarget(source.getStatus());
    }

    private void fillStatus(ome.model.jobs.IndexingJob target, IceMapper mapper) {
        target.putAt("ome.model.jobs.Job_status", (Object)mapper.reverse((ModelBased)this.getStatus()));
    }

    public void unloadSubmitted() {
        this.submitted = null;
    }

    @Override
    public RTime getSubmitted(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.submitted;
    }

    @Override
    public void setSubmitted(RTime submitted, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.submitted = submitted;
    }

    private void copySubmitted(ome.model.jobs.IndexingJob source, IceMapper mapper) {
        this.submitted = source.getSubmitted() == null ? null : rtypes.rtime(source.getSubmitted().getTime());
    }

    private void fillSubmitted(ome.model.jobs.IndexingJob target, IceMapper mapper) {
        try {
            target.setSubmitted((Timestamp)mapper.fromRType(this.getSubmitted()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadScheduledFor() {
        this.scheduledFor = null;
    }

    @Override
    public RTime getScheduledFor(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.scheduledFor;
    }

    @Override
    public void setScheduledFor(RTime scheduledFor, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.scheduledFor = scheduledFor;
    }

    private void copyScheduledFor(ome.model.jobs.IndexingJob source, IceMapper mapper) {
        this.scheduledFor = source.getScheduledFor() == null ? null : rtypes.rtime(source.getScheduledFor().getTime());
    }

    private void fillScheduledFor(ome.model.jobs.IndexingJob target, IceMapper mapper) {
        try {
            target.setScheduledFor((Timestamp)mapper.fromRType(this.getScheduledFor()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadStarted() {
        this.started = null;
    }

    @Override
    public RTime getStarted(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.started;
    }

    @Override
    public void setStarted(RTime started, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.started = started;
    }

    private void copyStarted(ome.model.jobs.IndexingJob source, IceMapper mapper) {
        this.started = source.getStarted() == null ? null : rtypes.rtime(source.getStarted().getTime());
    }

    private void fillStarted(ome.model.jobs.IndexingJob target, IceMapper mapper) {
        try {
            target.setStarted((Timestamp)mapper.fromRType(this.getStarted()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadFinished() {
        this.finished = null;
    }

    @Override
    public RTime getFinished(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.finished;
    }

    @Override
    public void setFinished(RTime finished, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.finished = finished;
    }

    private void copyFinished(ome.model.jobs.IndexingJob source, IceMapper mapper) {
        this.finished = source.getFinished() == null ? null : rtypes.rtime(source.getFinished().getTime());
    }

    private void fillFinished(ome.model.jobs.IndexingJob target, IceMapper mapper) {
        try {
            target.setFinished((Timestamp)mapper.fromRType(this.getFinished()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void unloadOriginalFileLinks(Current current) {
        this.originalFileLinksLoaded = false;
        this.originalFileLinksSeq = null;
    }

    protected List getOriginalFileLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.originalFileLinksSeq;
    }

    protected void setOriginalFileLinks(List originalFileLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.originalFileLinksSeq = originalFileLinks == null ? new ArrayList() : new ArrayList(originalFileLinks);
        this.originalFileLinksLoaded = originalFileLinks != null;
    }

    private void copyOriginalFileLinks(ome.model.jobs.IndexingJob source, IceMapper mapper) {
        this.setOriginalFileLinks((List)mapper.findCollection((Collection)source.retrieve("ome.model.jobs.Job_originalFileLinks")), null);
        this.originalFileLinksCountPerOwner = source.getOriginalFileLinksCountPerOwner();
    }

    private void fillOriginalFileLinks(ome.model.jobs.IndexingJob target, IceMapper mapper) {
        if (this.originalFileLinksLoaded) {
            target.putAt("ome.model.jobs.Job_originalFileLinks", (Object)mapper.reverse(this.originalFileLinksSeq, Set.class));
        } else {
            target.putAt("ome.model.jobs.Job_originalFileLinks", null);
        }
    }

    public boolean isOriginalFileLinksLoaded() {
        return this.originalFileLinksLoaded;
    }

    @Override
    public int sizeOfOriginalFileLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            return -1;
        }
        return this.originalFileLinksSeq.size();
    }

    public List copyOriginalFileLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        ArrayList result = new ArrayList(this.originalFileLinksSeq);
        return result;
    }

    public Iterator iterateOriginalFileLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        return this.originalFileLinksSeq.iterator();
    }

    @Override
    public void addJobOriginalFileLink(JobOriginalFileLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        this.originalFileLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllJobOriginalFileLinkSet(List<JobOriginalFileLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        this.originalFileLinksSeq.addAll(targets);
        for (JobOriginalFileLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeJobOriginalFileLink(JobOriginalFileLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        this.originalFileLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllJobOriginalFileLinkSet(List<JobOriginalFileLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        for (JobOriginalFileLink elt : targets) {
            elt.setParent(null);
            this.originalFileLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearOriginalFileLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        for (JobOriginalFileLink elt : this.originalFileLinksSeq) {
            elt.setParent(null);
        }
        this.originalFileLinksSeq.clear();
    }

    @Override
    public void reloadOriginalFileLinks(Job toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.originalFileLinksLoaded) {
            throw new ClientError("Cannot reload active collection: originalFileLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<JobOriginalFileLink> copy = toCopy.copyOriginalFileLinks();
        for (JobOriginalFileLink elt : copy) {
            elt.setParent(this);
        }
        this.originalFileLinksSeq = new ArrayList<JobOriginalFileLink>(copy);
        toCopy.unloadOriginalFileLinks();
        this.originalFileLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getOriginalFileLinksCountPerOwner(Current current) {
        return this.originalFileLinksCountPerOwner;
    }

    @Override
    public JobOriginalFileLink linkOriginalFile(OriginalFile addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        JobOriginalFileLinkI link = new JobOriginalFileLinkI();
        link.link(this, addition);
        this.addJobOriginalFileLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addJobOriginalFileLinkToBoth(JobOriginalFileLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        this.originalFileLinksSeq.add(link);
    }

    @Override
    public List<JobOriginalFileLink> findJobOriginalFileLink(OriginalFile removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        ArrayList<JobOriginalFileLink> result = new ArrayList<JobOriginalFileLink>();
        for (JobOriginalFileLink link : this.originalFileLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkOriginalFile(OriginalFile removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        List<JobOriginalFileLink> toRemove = this.findJobOriginalFileLink(removal);
        Iterator<JobOriginalFileLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeJobOriginalFileLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeJobOriginalFileLinkFromBoth(JobOriginalFileLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("originalFileLinksSeq");
        }
        this.originalFileLinksSeq.remove(link);
    }

    @Override
    public List<OriginalFile> linkedOriginalFileList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.originalFileLinksLoaded) {
            this.throwNullCollectionException("OriginalFileLinks");
        }
        ArrayList<OriginalFile> linked = new ArrayList<OriginalFile>();
        for (JobOriginalFileLink link : this.originalFileLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.jobs.IndexingJob) {
            ome.model.jobs.IndexingJob source = (ome.model.jobs.IndexingJob)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyUsername(source, mapper);
                this.copyGroupname(source, mapper);
                this.copyType(source, mapper);
                this.copyMessage(source, mapper);
                this.copyStatus(source, mapper);
                this.copySubmitted(source, mapper);
                this.copyScheduledFor(source, mapper);
                this.copyStarted(source, mapper);
                this.copyFinished(source, mapper);
                this.copyOriginalFileLinks(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("IndexingJob cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.jobs.IndexingJob target = new ome.model.jobs.IndexingJob();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillUsername(target, mapper);
            this.fillGroupname(target, mapper);
            this.fillType(target, mapper);
            this.fillMessage(target, mapper);
            this.fillStatus(target, mapper);
            this.fillSubmitted(target, mapper);
            this.fillScheduledFor(target, mapper);
            this.fillStarted(target, mapper);
            this.fillFinished(target, mapper);
            this.fillOriginalFileLinks(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<IndexingJobI> cast(List list) {
        return list;
    }
}

