/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ome.annotations.RolesAllowed;
import ome.api.IQuery;
import ome.api.ServiceInterface;
import ome.api.local.LocalQuery;
import ome.conditions.ApiUsageException;
import ome.conditions.OverUsageException;
import ome.conditions.ValidationException;
import ome.logic.AbstractLevel1Service;
import ome.model.IObject;
import ome.parameters.Filter;
import ome.parameters.Parameters;
import ome.services.SearchBean;
import ome.services.query.Query;
import ome.services.search.FullText;
import ome.services.search.SearchValues;
import ome.services.util.TimeoutSetter;
import ome.tools.hibernate.QueryBuilder;
import ome.util.PermDetails;
import org.apache.commons.collections.CollectionUtils;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class QueryImpl
extends AbstractLevel1Service
implements LocalQuery {
    protected Class<? extends Analyzer> analyzer;
    protected TimeoutSetter timeoutSetter;
    static final Pattern AGGS = Pattern.compile("(count|sum|max|min)");
    static final Pattern FIELD = Pattern.compile("\\w?[\\w.\\s\\+\\-\\*]*");

    public void setAnalyzer(Class<? extends Analyzer> analyzer) {
        this.getBeanHelper().throwIfAlreadySet(this.analyzer, analyzer);
        this.analyzer = analyzer;
    }

    public void setTimeoutSetter(TimeoutSetter timeoutSetter) {
        this.getBeanHelper().throwIfAlreadySet(this.timeoutSetter, timeoutSetter);
        this.timeoutSetter = timeoutSetter;
    }

    public Class<? extends ServiceInterface> getServiceInterface() {
        return IQuery.class;
    }

    private HibernateTemplate getHibernateTemplate() {
        return new HibernateTemplate(this.getSessionFactory(), false);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public boolean contains(Object obj) {
        return this.getHibernateTemplate().contains(obj);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void evict(Object obj) {
        this.getHibernateTemplate().evict(obj);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void clear() {
        this.getHibernateTemplate().clear();
    }

    @Override
    @RolesAllowed(value={"user"})
    public void initialize(Object obj) {
        Hibernate.initialize((Object)obj);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(propagation=Propagation.SUPPORTS)
    public boolean checkType(String type) {
        ClassMetadata meta = this.getHibernateTemplate().getSessionFactory().getClassMetadata(type);
        return meta != null;
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(propagation=Propagation.SUPPORTS)
    public boolean checkProperty(String type, String property) {
        ClassMetadata meta = this.getHibernateTemplate().getSessionFactory().getClassMetadata(type);
        String[] names = meta.getPropertyNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(property)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProbablyTimeout(DataAccessResourceFailureException exception) {
        if (exception.getCause() instanceof SQLException) {
            SQLException cause = (SQLException)exception.getCause();
            String message = cause.getMessage();
            return message != null && message.endsWith(" user request");
        }
        return false;
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T> T execute(HibernateCallback callback) {
        try {
            return (T)this.getHibernateTemplate().execute(callback);
        }
        catch (DataAccessResourceFailureException e) {
            if (QueryImpl.isProbablyTimeout(e)) {
                throw new OverUsageException("query failed, probable timeout");
            }
            throw e;
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T> T execute(Query<T> query) {
        try {
            return (T)this.getHibernateTemplate().execute(query);
        }
        catch (DataAccessResourceFailureException e) {
            if (QueryImpl.isProbablyTimeout(e)) {
                throw new OverUsageException("query failed, probable timeout");
            }
            throw e;
        }
    }

    @RolesAllowed(value={"user"})
    public IObject get(final Class klass, final long id) throws ValidationException {
        return (IObject)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                IObject o = null;
                try {
                    o = (IObject)session.load(klass, (Serializable)Long.valueOf(id));
                }
                catch (ObjectNotFoundException onfe) {
                    throw new ApiUsageException(String.format("The requested object (%s,%s) is not available.\nPlease use IQuery.find to determine existence.\n", klass.getName(), id));
                }
                Hibernate.initialize((Object)o);
                return o;
            }
        });
    }

    @RolesAllowed(value={"user"})
    public IObject find(final Class klass, final long id) {
        return (IObject)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                IObject o = (IObject)session.get(klass, (Serializable)Long.valueOf(id));
                Hibernate.initialize((Object)o);
                return o;
            }
        });
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> List<T> findAll(final Class<T> klass, final Filter filter) {
        if (filter == null) {
            return this.getHibernateTemplate().loadAll(klass);
        }
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria c = session.createCriteria(klass);
                QueryImpl.this.timeoutSetter.setTimeout(arg_0 -> ((Criteria)c).setTimeout(arg_0));
                c.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
                QueryImpl.this.parseFilter(c, filter);
                return c.list();
            }
        });
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> T findByExample(final T example) throws ApiUsageException {
        return (T)((IObject)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                try {
                    Criteria c = session.createCriteria(example.getClass());
                    QueryImpl.this.timeoutSetter.setTimeout(arg_0 -> ((Criteria)c).setTimeout(arg_0));
                    c.add((Criterion)Example.create((Object)example));
                    return c.uniqueResult();
                }
                catch (IncorrectResultSizeDataAccessException irsdae) {
                    QueryImpl.this.throwNonUnique("findByExample");
                }
                catch (NonUniqueResultException nure) {
                    QueryImpl.this.throwNonUnique("findByExample");
                }
                return null;
            }
        }));
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> List<T> findAllByExample(final T example, final Filter filter) {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria c = session.createCriteria(example.getClass());
                QueryImpl.this.timeoutSetter.setTimeout(arg_0 -> ((Criteria)c).setTimeout(arg_0));
                c.add((Criterion)Example.create((Object)example));
                QueryImpl.this.parseFilter(c, filter);
                return c.list();
            }
        });
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> T findByString(final Class<T> klass, final String fieldName, final String value) throws ApiUsageException {
        return (T)((IObject)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                try {
                    Criteria c = session.createCriteria(klass);
                    QueryImpl.this.timeoutSetter.setTimeout(arg_0 -> ((Criteria)c).setTimeout(arg_0));
                    c.add((Criterion)Restrictions.eq((String)fieldName, (Object)value));
                    return c.uniqueResult();
                }
                catch (IncorrectResultSizeDataAccessException irsdae) {
                    QueryImpl.this.throwNonUnique("findByString");
                }
                catch (NonUniqueResultException nure) {
                    QueryImpl.this.throwNonUnique("findByString");
                }
                return null;
            }
        }));
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> List<T> findAllByString(final Class<T> klass, final String fieldName, final String value, final boolean caseSensitive, final Filter filter) throws ApiUsageException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria c = session.createCriteria(klass);
                QueryImpl.this.timeoutSetter.setTimeout(arg_0 -> ((Criteria)c).setTimeout(arg_0));
                QueryImpl.this.parseFilter(c, filter);
                if (caseSensitive) {
                    c.add((Criterion)Restrictions.like((String)fieldName, (String)value, (MatchMode)MatchMode.ANYWHERE));
                } else {
                    c.add(Restrictions.ilike((String)fieldName, (String)value, (MatchMode)MatchMode.ANYWHERE));
                }
                return c.list();
            }
        });
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> T findByQuery(String queryName, Parameters params) throws ValidationException {
        if (params == null) {
            params = new Parameters();
        }
        params.unique();
        Query q = this.getQueryFactory().lookup(queryName, params);
        this.timeoutSetter.setTimeout(q::setTimeout);
        if (params.isCache()) {
            q.enableQueryCache();
        }
        IObject result = null;
        try {
            result = (IObject)this.execute(q);
        }
        catch (ClassCastException cce) {
            throw new ApiUsageException("Query named:\n\t" + queryName + "\nhas returned an Object of type " + cce.getMessage() + "\nQueries must return IObjects when using findByQuery. \nPlease try findAllByQuery for queries which return Lists. ");
        }
        catch (IncorrectResultSizeDataAccessException irsdae) {
            this.throwNonUnique(queryName);
        }
        catch (NonUniqueResultException nure) {
            this.throwNonUnique(queryName);
        }
        return (T)result;
    }

    private void throwNonUnique(String queryName) {
        throw new ApiUsageException("Query named:\n\n\t" + queryName + "\n\nhas returned more than one Object\nfindBy methods must return a single value.\nPlease try findAllBy methods for queries which return Lists.");
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> List<T> findAllByQuery(String queryName, Parameters params) {
        Query q = this.getQueryFactory().lookup(queryName, params);
        this.timeoutSetter.setTimeout(q::setTimeout);
        if (params != null && params.isCache()) {
            q.enableQueryCache();
        }
        return (List)this.execute(q);
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> List<T> findAllByFullText(final Class<T> type, final String query, final Parameters params) {
        if (this.analyzer == null) {
            throw new ApiUsageException("IQuery not configured for full text search.\nPlease use ome.api.Search instead.");
        }
        List results = (List)this.execute((HibernateCallback)new HibernateCallback<List<IObject>>(){

            public List<IObject> doInHibernate(Session session) throws HibernateException, SQLException {
                SearchValues values = new SearchValues();
                values.onlyTypes = Arrays.asList(type);
                values.copy(params);
                FullText fullText = new FullText(values, query, QueryImpl.this.analyzer);
                QueryImpl.this.timeoutSetter.setTimeout(fullText::setTimeout);
                return (List)fullText.doWork(session, null);
            }
        });
        if (CollectionUtils.isEmpty((Collection)results)) {
            return Collections.emptyList();
        }
        SearchBean search = new SearchBean();
        search.setTimeoutSetter(this.timeoutSetter);
        search.addParameters(params);
        search.addResult(results);
        return search.results();
    }

    @RolesAllowed(value={"user"})
    public List<Object[]> projection(String query, Parameters p) {
        int i;
        Parameters params = p == null ? new Parameters() : p;
        Query q = this.getQueryFactory().lookup(query, params);
        this.timeoutSetter.setTimeout(q::setTimeout);
        if (params.isCache()) {
            q.enableQueryCache();
        }
        List rv = (List)this.execute(q);
        int size = rv.size();
        Object obj = null;
        for (i = 0; i < size; ++i) {
            obj = rv.get(i);
            if (obj == null || Object[].class.isAssignableFrom(obj.getClass())) continue;
            rv.set(i, new Object[]{obj});
        }
        for (i = 0; i < size; ++i) {
            Object[] x = (Object[])rv.get(i);
            if (x == null || x.length != 1 || !(x[0] instanceof Map)) continue;
            Map y = (Map)x[0];
            for (Map.Entry entry : y.entrySet()) {
                if (entry == null || !entry.getKey().toString().endsWith("_details_permissions")) continue;
                entry.setValue(new PermDetails((IObject)entry.getValue()));
            }
        }
        return rv;
    }

    @RolesAllowed(value={"user"})
    public Long aggByQuery(String agg, String field, String query, Parameters params) {
        if (!AGGS.matcher(agg).matches()) {
            throw new ValidationException(agg + " does not match " + AGGS);
        }
        if (!FIELD.matcher(field).matches()) {
            throw new ValidationException(field + " does not match " + FIELD);
        }
        final QueryBuilder qb = new QueryBuilder();
        qb.select(agg + "(" + field + ")").append(query);
        qb.params(params);
        return (Long)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Query q = qb.query(session);
                QueryImpl.this.timeoutSetter.setTimeout(arg_0 -> ((org.hibernate.Query)q).setTimeout(arg_0));
                return q.uniqueResult();
            }
        });
    }

    @RolesAllowed(value={"user"})
    public Map<String, Long> aggMapByQuery(String agg, String mapKey, String field, String query, Parameters params) {
        if (!AGGS.matcher(agg).matches()) {
            throw new ValidationException(agg + " does not match " + AGGS);
        }
        if (!FIELD.matcher(field).matches()) {
            throw new ValidationException(field + " does not match " + FIELD);
        }
        if (!FIELD.matcher(mapKey).matches()) {
            throw new ValidationException(mapKey + " does not match " + FIELD);
        }
        final QueryBuilder qb = new QueryBuilder();
        qb.select(mapKey, agg + "(" + field + ")").append(query);
        qb.append(" group by " + mapKey);
        qb.params(params);
        List list = (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Query q = qb.query(session);
                QueryImpl.this.timeoutSetter.setTimeout(arg_0 -> ((org.hibernate.Query)q).setTimeout(arg_0));
                return q.list();
            }
        });
        HashMap<String, Long> rv = new HashMap<String, Long>();
        for (Object[] objs : list) {
            Object key = objs[0];
            Object value = objs[1];
            Long l = null;
            if (value instanceof Long) {
                l = (Long)value;
            } else if (value instanceof Integer) {
                l = ((Integer)value).longValue();
            } else {
                throw new ValidationException("Value for key " + key + " is " + value);
            }
            rv.put(key.toString(), l);
        }
        return rv;
    }

    public <T extends IObject> T refresh(T iObject) throws ApiUsageException {
        this.getHibernateTemplate().refresh(iObject);
        return iObject;
    }

    protected void parseFilter(Criteria c, Filter f) {
        if (f != null && f.offset != null) {
            c.setFirstResult(f.offset.intValue());
        } else {
            c.setFirstResult(0);
        }
        if (f != null && f.limit != null) {
            c.setMaxResults(f.limit.intValue());
        } else {
            c.setMaxResults(Integer.MAX_VALUE);
        }
    }
}

