/*
 * Decompiled with CFR 0.152.
 */
package ome.security;

import ome.model.IEnum;
import ome.model.IGlobal;
import ome.model.internal.Details;
import ome.model.meta.DBPatch;
import ome.model.meta.Event;
import ome.model.meta.EventLog;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.GroupExperimenterMap;
import ome.model.meta.Node;
import ome.model.meta.Session;
import ome.model.meta.ShareMember;
import ome.system.Roles;

public class SystemTypes {
    private final Roles roles;

    public SystemTypes() {
        this(new Roles());
    }

    public SystemTypes(Roles roles) {
        this.roles = roles;
    }

    public boolean isSystemType(Class<?> klass) {
        if (klass == null) {
            return false;
        }
        if (Session.class.isAssignableFrom(klass)) {
            return true;
        }
        if (ShareMember.class.isAssignableFrom(klass)) {
            return true;
        }
        if (Node.class.isAssignableFrom(klass)) {
            return true;
        }
        if (Experimenter.class.isAssignableFrom(klass)) {
            return true;
        }
        if (ExperimenterGroup.class.isAssignableFrom(klass)) {
            return true;
        }
        if (GroupExperimenterMap.class.isAssignableFrom(klass)) {
            return true;
        }
        if (Event.class.isAssignableFrom(klass)) {
            return true;
        }
        if (EventLog.class.isAssignableFrom(klass)) {
            return true;
        }
        if (IEnum.class.isAssignableFrom(klass)) {
            return true;
        }
        if (DBPatch.class.isAssignableFrom(klass)) {
            return true;
        }
        return IGlobal.class.isAssignableFrom(klass);
    }

    public boolean isInSystemGroup(Long groupId) {
        Long systemGroupId = this.roles.getSystemGroupId();
        return systemGroupId.equals(groupId);
    }

    public boolean isInSystemGroup(Details d) {
        if (d == null || d.getGroup() == null) {
            return false;
        }
        Long groupId = d.getGroup().getId();
        return this.isInSystemGroup(groupId);
    }

    public boolean isInUserGroup(Long groupId) {
        Long userGroupId = this.roles.getUserGroupId();
        return userGroupId.equals(groupId);
    }

    public boolean isInUserGroup(Details d) {
        if (d == null || d.getGroup() == null) {
            return false;
        }
        Long groupId = d.getGroup().getId();
        return this.isInUserGroup(groupId);
    }
}

