/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import ome.model.enums.AdminPrivilege;
import ome.model.internal.NamedValue;
import ome.model.meta.Experimenter;
import ome.model.meta.Session;
import ome.system.Roles;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightAdminPrivileges {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightAdminPrivileges.class);
    private static final String USER_CONFIG_NAME_PREFIX = AdminPrivilege.class.getSimpleName() + ':';
    private static final ImmutableSet<AdminPrivilege> ADMIN_PRIVILEGES;
    private static final ImmutableMap<String, AdminPrivilege> ADMIN_PRIVILEGES_BY_VALUE;
    private final long rootId;
    private final LoadingCache<SessionEqualById, ImmutableSet<AdminPrivilege>> PRIVILEGE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<SessionEqualById, ImmutableSet<AdminPrivilege>>(){

        public ImmutableSet<AdminPrivilege> load(SessionEqualById wrappedSession) {
            try {
                return LightAdminPrivileges.this.getPrivileges(wrappedSession.session);
            }
            catch (Throwable t) {
                LOGGER.error("failed to check permissions for session #" + wrappedSession.sessionId, t);
                throw t;
            }
        }
    });

    public static ImmutableSet<AdminPrivilege> getAllPrivileges() {
        return ADMIN_PRIVILEGES;
    }

    public AdminPrivilege getPrivilegeForConfigName(String value) {
        if (value.startsWith(USER_CONFIG_NAME_PREFIX)) {
            return this.getPrivilege(value.substring(USER_CONFIG_NAME_PREFIX.length()));
        }
        return null;
    }

    public String getConfigNameForPrivilege(AdminPrivilege privilege) {
        return USER_CONFIG_NAME_PREFIX + privilege.getValue();
    }

    public AdminPrivilege getPrivilege(String value) {
        AdminPrivilege privilege = (AdminPrivilege)ADMIN_PRIVILEGES_BY_VALUE.get((Object)value);
        if (privilege == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("checked for unknown privilege " + value);
            }
            return null;
        }
        return privilege;
    }

    public ImmutableSet<AdminPrivilege> getSessionPrivileges(Session session) {
        return this.getSessionPrivileges(session, true);
    }

    private ImmutableSet<AdminPrivilege> getSessionPrivileges(Session session, boolean isCache) {
        SessionEqualById wrappedSession = new SessionEqualById(session);
        try {
            if (isCache) {
                return (ImmutableSet)this.PRIVILEGE_CACHE.get((Object)wrappedSession);
            }
            ImmutableSet privileges = (ImmutableSet)this.PRIVILEGE_CACHE.getIfPresent((Object)wrappedSession);
            if (privileges != null) {
                return privileges;
            }
            return this.getPrivileges(session);
        }
        catch (ExecutionException ee) {
            LOGGER.warn("failed to check privileges for session " + session.getId(), ee.getCause());
            return ImmutableSet.of();
        }
    }

    public LightAdminPrivileges(Roles roles) {
        this.rootId = roles.getRootId();
    }

    private ImmutableSet<AdminPrivilege> getPrivileges(Session session) {
        HashSet<AdminPrivilege> privileges = new HashSet<AdminPrivilege>((Collection<AdminPrivilege>)LightAdminPrivileges.getAllPrivileges());
        this.removeUserPrivileges(session.getSudoer(), privileges);
        this.removeUserPrivileges(session.getOwner(), privileges);
        return ImmutableSet.copyOf(privileges);
    }

    private void removeUserPrivileges(Experimenter user, Set<AdminPrivilege> privileges) {
        if (user == null || user.getId() == this.rootId) {
            return;
        }
        List config = user.getConfig();
        if (CollectionUtils.isNotEmpty((Collection)config)) {
            for (NamedValue configProperty : config) {
                String configPropertyName;
                if (Boolean.parseBoolean(configProperty.getValue()) || !(configPropertyName = configProperty.getName()).startsWith(USER_CONFIG_NAME_PREFIX)) continue;
                String adminPrivilegeName = configPropertyName.substring(USER_CONFIG_NAME_PREFIX.length());
                privileges.remove(ADMIN_PRIVILEGES_BY_VALUE.get((Object)adminPrivilegeName));
            }
        }
    }

    static {
        ImmutableSet privilegeValues = ImmutableSet.of((Object)"Chgrp", (Object)"Chown", (Object)"DeleteFile", (Object)"DeleteManagedRepo", (Object)"DeleteOwned", (Object)"DeleteScriptRepo", (Object[])new String[]{"ModifyGroup", "ModifyGroupMembership", "ModifyUser", "ReadSession", "Sudo", "WriteFile", "WriteManagedRepo", "WriteOwned", "WriteScriptRepo"});
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String privilegeValue : privilegeValues) {
            builder.put((Object)privilegeValue, (Object)new AdminPrivilege(privilegeValue));
        }
        ADMIN_PRIVILEGES_BY_VALUE = builder.build();
        ADMIN_PRIVILEGES = ImmutableSet.copyOf((Collection)ADMIN_PRIVILEGES_BY_VALUE.values());
    }

    private static final class SessionEqualById {
        private final Session session;
        private final Long sessionId;

        private SessionEqualById(Session session) {
            this.session = session;
            this.sessionId = session.getId();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof SessionEqualById) {
                return this.sessionId.equals(((SessionEqualById)object).sessionId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.sessionId);
        }
    }
}

