/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.conditions.InternalException;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.security.basic.AbstractSecurityFilter;
import ome.system.EventContext;
import ome.system.Roles;
import org.hibernate.Filter;
import org.hibernate.Session;

public class OneGroupSecurityFilter
extends AbstractSecurityFilter {
    public static final String current_group = "current_group";

    public OneGroupSecurityFilter() {
    }

    public OneGroupSecurityFilter(Roles roles) {
        super(roles);
    }

    protected String myFilterCondition() {
        return "(\n\n  ( group_id = :current_group AND \n     ( 1 = :is_nonprivate OR \n       1 = :is_adminorpi OR \n       owner_id = :current_user\n     )\n  ) OR\n  group_id = %s OR \n 1 = :is_share\n)\n";
    }

    @Override
    public String getDefaultCondition() {
        return String.format(this.myFilterCondition(), this.roles.getUserGroupId());
    }

    @Override
    public Map<String, String> getParameterTypes() {
        HashMap<String, String> parameterTypes = new HashMap<String, String>();
        parameterTypes.put("is_share", "int");
        parameterTypes.put("is_adminorpi", "int");
        parameterTypes.put("is_nonprivate", "int");
        parameterTypes.put(current_group, "long");
        parameterTypes.put("current_user", "long");
        return parameterTypes;
    }

    @Override
    public boolean passesFilter(Session session, Details d, EventContext c) {
        Long currentGroupId = c.getCurrentGroupId();
        Long currentUserId = c.getCurrentUserId();
        boolean nonPrivate = this.isNonPrivate(c);
        boolean adminOrPi = this.isAdminOrPi(c);
        boolean share = this.isShare(c);
        List memberOfGroups = c.getMemberOfGroupsList();
        if (d == null || d.getPermissions() == null) {
            throw new InternalException("Details/Permissions null! Security system failure -- refusing to continue. The Permissions should be set to a default value.");
        }
        Long o = d.getOwner().getId();
        Long g = d.getGroup().getId();
        if (share) {
            return true;
        }
        if (Long.valueOf(this.roles.getSystemGroupId()).equals(g) || Long.valueOf(this.roles.getUserGroupId()).equals(g)) {
            return true;
        }
        if (currentGroupId < 0L) {
            this.throwNegOne();
        } else if (!currentGroupId.equals(g)) {
            return false;
        }
        if (nonPrivate) {
            return true;
        }
        if (adminOrPi) {
            return true;
        }
        return currentUserId.equals(o);
    }

    @Override
    public void enable(Session sess, EventContext ec) {
        int nonpriv01;
        Filter filter = sess.enableFilter(this.getName());
        Long groupId = ec.getCurrentGroupId();
        Long shareId = ec.getCurrentShareId();
        int share01 = shareId != null ? 1 : 0;
        int adminOrPi01 = ec.isCurrentUserAdmin() || ec.getLeaderOfGroupsList().contains(ec.getCurrentGroupId()) ? 1 : 0;
        int n = nonpriv01 = ec.getCurrentGroupPermissions().isGranted(Permissions.Role.GROUP, Permissions.Right.READ) || ec.getCurrentGroupPermissions().isGranted(Permissions.Role.WORLD, Permissions.Right.READ) ? 1 : 0;
        if (groupId < 0L) {
            this.throwNegOne();
        }
        filter.setParameter("is_share", (Object)share01);
        filter.setParameter("is_adminorpi", (Object)adminOrPi01);
        filter.setParameter("is_nonprivate", (Object)nonpriv01);
        filter.setParameter("current_user", (Object)ec.getCurrentUserId());
        filter.setParameter(current_group, (Object)groupId);
        this.enableBaseFilters(sess, ec.isCurrentUserAdmin() ? 1 : 0, ec.getCurrentUserId());
    }

    private void throwNegOne() {
        throw new InternalException("OneGroupSecurityFilter is not capable of handling omero.group=-1. This is handled by AllGroupsSecurityFilter");
    }
}

