/*
 * Decompiled with CFR 0.152.
 */
package ome.services.graphs;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import ome.model.units.GenericEnumType;
import ome.services.graphs.GraphPathBean;
import ome.services.scheduler.ThreadPool;
import ome.system.OmeroContext;
import ome.tools.hibernate.ListAsSQLArrayUserType;
import org.hibernate.type.CustomType;
import org.hibernate.type.EnumType;
import org.hibernate.type.ListType;
import org.hibernate.type.MapType;
import org.hibernate.type.Type;
import org.hibernate.usertype.UserType;

public class GraphPathReport {
    private static GraphPathBean model;
    private static Writer out;

    private static String getSimpleName(String fullName) {
        return fullName.substring(1 + fullName.lastIndexOf(46));
    }

    private static String labelFor(String className) {
        return "OMERO model class " + className;
    }

    private static String labelFor(String className, String propertyName) {
        return "OMERO model property " + className + '.' + propertyName;
    }

    private static String linkTo(String className) {
        StringBuffer sb = new StringBuffer();
        sb.append(":ref:");
        sb.append('`');
        sb.append(className);
        sb.append(' ');
        sb.append('<');
        sb.append(GraphPathReport.labelFor(className));
        sb.append('>');
        sb.append('`');
        return sb.toString();
    }

    private static String linkTo(String className, String propertyName) {
        StringBuffer sb = new StringBuffer();
        sb.append(":ref:");
        sb.append('`');
        sb.append(className);
        sb.append('.');
        sb.append(propertyName);
        sb.append(' ');
        sb.append('<');
        sb.append(GraphPathReport.labelFor(className));
        sb.append('>');
        sb.append('`');
        return sb.toString();
    }

    private static String linkToJavadoc(String className) {
        StringBuffer sb = new StringBuffer();
        sb.append(":javadoc_model:");
        sb.append('`');
        sb.append(GraphPathReport.getSimpleName(className));
        sb.append(' ');
        sb.append('<');
        sb.append(className.replace('.', '/'));
        sb.append(".html");
        sb.append('>');
        sb.append('`');
        return sb.toString();
    }

    private static String reportType(String className, String propertyName) {
        Type type = model.getPropertyType(className, propertyName);
        UserType userType = type instanceof CustomType ? ((CustomType)type).getUserType() : null;
        if (type instanceof EnumType) {
            return "enumeration";
        }
        if (userType instanceof GenericEnumType) {
            Class unitQuantityClass = ((GenericEnumType)userType).getQuantityClass();
            return "enumeration of " + GraphPathReport.linkToJavadoc(unitQuantityClass.getName());
        }
        if (type instanceof ListType || userType instanceof ListAsSQLArrayUserType) {
            return "list";
        }
        if (type instanceof MapType) {
            return "map";
        }
        return "``" + type.getName() + "``";
    }

    private static boolean isDeprecated(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("failed to review " + className + " for deprecation", e);
        }
        return clazz.getAnnotation(Deprecated.class) != null;
    }

    private static boolean isDeprecated(String className, String propertyName) {
        Class<?> clazz;
        if (propertyName.startsWith("details.")) {
            return false;
        }
        String propertyNameCap = propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        ImmutableSet getterNames = ImmutableSet.of((Object)("is" + propertyNameCap), (Object)("get" + propertyNameCap));
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("failed to review " + className + " for deprecation", e);
        }
        for (Method method : clazz.getMethods()) {
            if (!getterNames.contains(method.getName()) || method.getAnnotation(Deprecated.class) == null) continue;
            return true;
        }
        return false;
    }

    private static void report() throws IOException {
        out.write(".. Content for this page is generated using\n");
        out.write(".. https://github.com/ome/omero-server/blob/master/");
        out.write("src/main/java/ome/services/graphs/GraphPathReport.java\n\n");
        out.write("Glossary of all OMERO Model Objects\n");
        out.write("===================================\n\n");
        out.write("Overview\n");
        out.write("--------\n\n");
        out.write(".. include:: EveryObjectOverview.inc\n\n");
        out.write("Reference\n");
        out.write("---------\n\n");
        TreeMap<String, String> classNames = new TreeMap<String, String>();
        for (String string : model.getAllClasses()) {
            classNames.put(GraphPathReport.getSimpleName(string), string);
        }
        for (Map.Entry entry : classNames.entrySet()) {
            String simpleName = (String)entry.getKey();
            String className = (String)entry.getValue();
            out.write(".. _" + GraphPathReport.labelFor(simpleName) + ":\n\n");
            out.write(simpleName + "\n");
            char[] underline = new char[simpleName.length()];
            for (int i = 0; i < underline.length; ++i) {
                underline[i] = 34;
            }
            out.write(underline);
            out.write("\n\n");
            TreeSet<String> superclassOf = new TreeSet<String>();
            for (String string : model.getDirectSubclassesOf(className)) {
                superclassOf.add(GraphPathReport.linkTo(GraphPathReport.getSimpleName(string)));
            }
            TreeSet<String> linkerText = new TreeSet<String>();
            for (Map.Entry<String, String> linker : model.getLinkedBy(className)) {
                linkerText.add(GraphPathReport.linkTo(GraphPathReport.getSimpleName(linker.getKey()), linker.getValue()));
            }
            if (!superclassOf.isEmpty() || !linkerText.isEmpty()) {
                if (!superclassOf.isEmpty()) {
                    out.write("Subclasses: " + Joiner.on((String)", ").join(superclassOf) + "\n\n");
                }
                if (!linkerText.isEmpty()) {
                    out.write("Used by: " + Joiner.on((String)", ").join(linkerText) + "\n\n");
                }
            }
            out.write("Properties:\n");
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            HashMap<String, String> valueText = new HashMap<String, String>();
            for (String superclassName : model.getSuperclassesOfReflexive(className)) {
                for (Map.Entry<String, String> classAndPropertyNames : model.getLinkedTo(superclassName)) {
                    String valueClassName = classAndPropertyNames.getKey();
                    String propertyName = classAndPropertyNames.getValue();
                    treeMap.put(propertyName, superclassName);
                    valueText.put(propertyName, GraphPathReport.linkTo(GraphPathReport.getSimpleName(valueClassName)));
                }
                for (String propertyName : model.getSimpleProperties(superclassName, true)) {
                    treeMap.put(propertyName, superclassName);
                    valueText.put(propertyName, GraphPathReport.reportType(superclassName, propertyName));
                }
            }
            int deprecatedPropertyCount = 0;
            for (Map.Entry propertyAndDeclarerNames : treeMap.entrySet()) {
                String interfaceName;
                String propertyName;
                propertyName = (String)propertyAndDeclarerNames.getKey();
                String declarerName = (String)propertyAndDeclarerNames.getValue();
                out.write("  | " + propertyName + ": " + (String)valueText.get(propertyName));
                switch (model.getPropertyKind(declarerName, propertyName)) {
                    case OPTIONAL: {
                        out.write(" (optional)");
                        break;
                    }
                    case REQUIRED: {
                        break;
                    }
                    case COLLECTION: {
                        out.write(" (multiple)");
                    }
                }
                if (GraphPathReport.isDeprecated(className, propertyName)) {
                    ++deprecatedPropertyCount;
                    out.write(" (deprecated)");
                }
                if (!declarerName.equals(className)) {
                    out.write(" from " + GraphPathReport.linkTo(GraphPathReport.getSimpleName(declarerName)));
                } else if (!propertyName.startsWith("details.") && (interfaceName = model.getInterfaceImplemented(className, propertyName)) != null) {
                    out.write(", see " + GraphPathReport.linkToJavadoc(interfaceName));
                }
                out.write("\n");
            }
            out.write("\n");
            if (GraphPathReport.isDeprecated(className)) {
                out.write(".. warning:: This model object is deprecated.\n\n");
                continue;
            }
            if (deprecatedPropertyCount == 1) {
                out.write(".. warning:: This model object has a deprecated property.\n\n");
                continue;
            }
            if (deprecatedPropertyCount <= true) continue;
            out.write(".. warning:: This model object has deprecated properties.\n\n");
        }
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length != 1) {
            System.err.println("must give output filename as single argument");
            System.exit(1);
        }
        out = new FileWriter(argv[0]);
        OmeroContext context = OmeroContext.getManagedServerContext();
        model = (GraphPathBean)context.getBean("graphPathBean", GraphPathBean.class);
        GraphPathReport.report();
        out.close();
        ((ThreadPool)context.getBean("threadPool", ThreadPool.class)).getExecutor().shutdown();
        context.closeAll();
    }
}

