/*
 * Decompiled with CFR 0.152.
 */
package ome.services.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import javax.sql.DataSource;
import ome.model.IObject;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class IndexWatcher {
    private final List<ToIndex> objectsToIndex = new ArrayList<ToIndex>();
    private final List<Function<Long, Boolean>> eventLogFilters = new ArrayList<Function<Long, Boolean>>();
    private final JdbcTemplate dataSource;
    private final String[] countKey;
    private final long fullTextType;

    public IndexWatcher(DataSource dataSource, String countKey) {
        this.dataSource = new JdbcTemplate(dataSource);
        this.countKey = new String[]{countKey};
        this.fullTextType = (Long)this.dataSource.queryForObject("SELECT id FROM eventtype WHERE value = ?", (Object[])new String[]{"FullText"}, Long.class);
    }

    private void createLogEntries() {
        for (ToIndex object : this.objectsToIndex) {
            String status = UUID.randomUUID().toString();
            this.dataSource.update("INSERT INTO event (id, type, experimenter, experimentergroup, session, time, permissions, status) VALUES (ome_nextval('seq_event'), ?, ?, ?, ?, NOW(), -35, ?)", new Object[]{this.fullTextType, object.userId, object.groupId, object.sessionId, status});
            long eventId = (Long)this.dataSource.queryForObject("SELECT id FROM event WHERE status = ?", (Object[])new String[]{status}, Long.class);
            this.dataSource.update("UPDATE event SET status = NULL WHERE id = ?", new Object[]{eventId});
            this.dataSource.update("INSERT INTO eventlog (id, action, entitytype, entityid, event, permissions) VALUES (ome_nextval('seq_eventlog'), 'REINDEX', ?, ?, ?, -35)", new Object[]{object.objectType.getName(), object.objectId, eventId});
        }
    }

    private void createFilters() {
        final long latestId = (Long)this.dataSource.queryForObject("SELECT id FROM eventlog WHERE action = 'REINDEX' ORDER BY id DESC LIMIT 1", Long.class);
        this.eventLogFilters.add(new Function<Long, Boolean>(){

            @Override
            public Boolean apply(Long currentId) {
                return currentId >= latestId;
            }
        });
        for (final ToIndex object : this.objectsToIndex) {
            this.eventLogFilters.add(new Function<Long, Boolean>(){

                @Override
                public Boolean apply(Long currentId) {
                    object.semaphore.release();
                    return true;
                }
            });
        }
        this.objectsToIndex.clear();
    }

    private void applyFilters() {
        Function<Long, Boolean> entry;
        long currentId;
        try {
            String value = (String)this.dataSource.queryForObject("SELECT value FROM configuration WHERE name = ?", (Object[])this.countKey, String.class);
            currentId = Long.valueOf(value);
        }
        catch (NullPointerException | NumberFormatException | EmptyResultDataAccessException e) {
            return;
        }
        Iterator<Function<Long, Boolean>> entryIter = this.eventLogFilters.iterator();
        while (entryIter.hasNext() && (entry = entryIter.next()).apply(currentId).booleanValue()) {
            entryIter.remove();
        }
    }

    public synchronized void poll() {
        if (!this.objectsToIndex.isEmpty()) {
            this.createLogEntries();
            this.createFilters();
        }
        if (!this.eventLogFilters.isEmpty()) {
            this.applyFilters();
        }
    }

    public synchronized Semaphore indexObject(IObject object, long userId, long groupId, long sessionId) {
        ToIndex objectToIndex = new ToIndex(object, userId, groupId, sessionId);
        this.objectsToIndex.add(objectToIndex);
        return objectToIndex.semaphore;
    }

    private class ToIndex {
        final Class<? extends IObject> objectType;
        final long objectId;
        final long userId;
        final long groupId;
        final long sessionId;
        final Semaphore semaphore = new Semaphore(0);

        ToIndex(IObject object, long userId, long groupId, long sessionId) {
            this.objectType = object.getClass();
            this.objectId = object.getId();
            this.userId = userId;
            this.groupId = groupId;
            this.sessionId = sessionId;
        }
    }
}

