/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.ini4j.AbstractParser;
import org.ini4j.Config;
import org.ini4j.IniSource;
import org.ini4j.InvalidIniFormatException;
import org.ini4j.OptionHandler;
import org.ini4j.spi.ServiceFinder;

public class OptionParser
extends AbstractParser {
    private static final String COMMENTS = "!#";
    private static final String OPERATORS = ":=";

    public OptionParser() {
        super(OPERATORS, COMMENTS);
    }

    public static OptionParser newInstance() {
        return ServiceFinder.findService(OptionParser.class);
    }

    public static OptionParser newInstance(Config config) {
        OptionParser instance = OptionParser.newInstance();
        instance.setConfig(config);
        return instance;
    }

    public void parse(InputStream input, OptionHandler handler) throws IOException, InvalidIniFormatException {
        this.parse(this.newIniSource(input), handler);
    }

    public void parse(Reader input, OptionHandler handler) throws IOException, InvalidIniFormatException {
        this.parse(this.newIniSource(input), handler);
    }

    public void parse(URL input, OptionHandler handler) throws IOException, InvalidIniFormatException {
        this.parse(this.newIniSource(input), handler);
    }

    private void parse(IniSource source, OptionHandler handler) throws IOException, InvalidIniFormatException {
        String line = source.readLine();
        while (line != null) {
            this.parseOptionLine(line, handler, source.getLineNumber());
            line = source.readLine();
        }
    }
}

