/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import java.util.EnumMap;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.StringTypeDescriptor;

public abstract class PrivilegedStringTypeDescriptor
extends StringTypeDescriptor {
    private static EnumMap<Filter, Function<Long, Boolean>> FILTERS = new EnumMap(Filter.class);

    public static void setFilter(Filter filterType, Function<Long, Boolean> filter) {
        FILTERS.put(filterType, filter);
    }

    protected abstract Function<Long, Boolean> getFilter();

    protected String getFilterFailure() {
        return null;
    }

    public <X> String wrap(X stringLike, WrapperOptions options) {
        long userId;
        int separatorAt;
        Function<Long, Boolean> filter = this.getFilter();
        if (filter == null) {
            return this.getFilterFailure();
        }
        String string = super.wrap(stringLike, options);
        if (string == null) {
            return null;
        }
        try {
            separatorAt = string.indexOf(59);
            userId = Long.parseLong(string.substring(0, separatorAt));
        }
        catch (Throwable t) {
            throw new HibernateException("column transformer failed for secure string", t);
        }
        return filter.apply(userId) != false ? string.substring(separatorAt + 1) : this.getFilterFailure();
    }

    public static class FilteredRelatedUserHidden
    extends FilteredRelatedUser {
        static final PrivilegedStringTypeDescriptor INSTANCE = new FilteredRelatedUserHidden();

        @Override
        protected String getFilterFailure() {
            return "<hidden>";
        }
    }

    public static class FilteredRelatedUser
    extends PrivilegedStringTypeDescriptor {
        static final PrivilegedStringTypeDescriptor INSTANCE = new FilteredRelatedUser();

        @Override
        protected Function<Long, Boolean> getFilter() {
            return (Function)FILTERS.get((Object)Filter.RELATED_USER);
        }
    }

    public static class FilteredFullAdminUUID
    extends FilteredFullAdmin {
        static final PrivilegedStringTypeDescriptor INSTANCE = new FilteredFullAdminUUID();

        @Override
        protected String getFilterFailure() {
            return "********-****-****-****-*************";
        }
    }

    public static class FilteredFullAdminHidden
    extends FilteredFullAdmin {
        static final PrivilegedStringTypeDescriptor INSTANCE = new FilteredFullAdminHidden();

        @Override
        protected String getFilterFailure() {
            return "<hidden>";
        }
    }

    public static class FilteredFullAdmin
    extends PrivilegedStringTypeDescriptor {
        static final PrivilegedStringTypeDescriptor INSTANCE = new FilteredFullAdmin();

        @Override
        protected Function<Long, Boolean> getFilter() {
            return (Function)FILTERS.get((Object)Filter.FULL_ADMIN);
        }
    }

    public static enum Filter {
        FULL_ADMIN,
        FULL_ADMIN_HIDDEN,
        FULL_ADMIN_UUID,
        RELATED_USER,
        RELATED_USER_HIDDEN;

    }
}

