/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.ConnectionLostException;
import Ice.Holder;
import Ice.LocalException;
import Ice.SecurityException;
import Ice.SocketException;
import IceInternal.Buffer;
import IceInternal.EndpointI;
import IceInternal.Network;
import IceInternal.StreamSocket;
import IceInternal.Transceiver;
import IceInternal.WSTransceiverDelegate;
import IceSSL.ConnectionInfo;
import IceSSL.Instance;
import IceSSL.NativeConnectionInfo;
import IceSSL.WSSNativeConnectionInfo;
import IceUtilInternal.Base64;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

final class TransceiverI
implements Transceiver,
WSTransceiverDelegate {
    private Instance _instance;
    private StreamSocket _stream;
    private SSLEngine _engine;
    private String _host = "";
    private String _adapterName = "";
    private boolean _incoming;
    private ByteBuffer _appInput;
    private ByteBuffer _netInput;
    private ByteBuffer _netOutput;
    private static ByteBuffer _emptyBuffer = ByteBuffer.allocate(0);

    @Override
    public SelectableChannel fd() {
        return this._stream.fd();
    }

    @Override
    public int initialize(Buffer readBuffer, Buffer writeBuffer, Holder<Boolean> moreData) {
        int status = this._stream.connect(readBuffer, writeBuffer);
        if (status != 0) {
            return status;
        }
        status = this.handshakeNonBlocking();
        if (status != 0) {
            return status;
        }
        this._instance.verifyPeer((NativeConnectionInfo)this.getInfo(), this._stream.fd(), this._host);
        if (this._instance.securityTraceLevel() >= 1) {
            this._instance.traceConnection(this._stream.fd(), this._engine, this._incoming);
        }
        return 0;
    }

    @Override
    public int closing(boolean initiator, LocalException ex) {
        return initiator ? 1 : 0;
    }

    @Override
    public void close() {
        if (this._stream.isConnected()) {
            try {
                this._engine.closeOutbound();
                this._netOutput.clear();
                while (!this._engine.isOutboundDone()) {
                    this._engine.wrap(_emptyBuffer, this._netOutput);
                    try {
                        this.flushNonBlocking();
                    }
                    catch (LocalException localException) {}
                }
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
            try {
                this._engine.closeInbound();
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
        }
        this._stream.close();
    }

    @Override
    public EndpointI bind() {
        assert (false);
        return null;
    }

    @Override
    public int write(Buffer buf) {
        if (!this._stream.isConnected()) {
            return this._stream.write(buf);
        }
        int status = this.writeNonBlocking(buf.b);
        assert (status == 0 || status == 4);
        return status;
    }

    @Override
    public int read(Buffer buf, Holder<Boolean> moreData) {
        moreData.value = false;
        if (!this._stream.isConnected()) {
            return this._stream.read(buf);
        }
        this.fill(buf.b);
        try {
            while (buf.b.hasRemaining()) {
                this._netInput.flip();
                SSLEngineResult result = this._engine.unwrap(this._netInput, this._appInput);
                this._netInput.compact();
                SSLEngineResult.Status status = result.getStatus();
                assert (status != SSLEngineResult.Status.BUFFER_OVERFLOW);
                if (status == SSLEngineResult.Status.CLOSED) {
                    throw new ConnectionLostException();
                }
                if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW || this._appInput.position() == 0 && this._netInput.position() == 0) {
                    if (this._stream.read(this._netInput) != 0) continue;
                    return 1;
                }
                this.fill(buf.b);
            }
            if (this._appInput.position() == 0) {
                this._netInput.flip();
                this._engine.unwrap(this._netInput, this._appInput);
                this._netInput.compact();
            }
        }
        catch (SSLException ex) {
            throw new SecurityException("IceSSL: error during read", ex);
        }
        moreData.value = this._netInput.position() > 0 || this._appInput.position() > 0;
        return 0;
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        return this._stream.toString();
    }

    @Override
    public String toDetailedString() {
        return this.toString();
    }

    @Override
    public Ice.ConnectionInfo getInfo() {
        NativeConnectionInfo info = new NativeConnectionInfo();
        info.nativeCerts = this.fillConnectionInfo(info);
        return info;
    }

    @Override
    public Ice.ConnectionInfo getWSInfo(Map<String, String> headers) {
        WSSNativeConnectionInfo info = new WSSNativeConnectionInfo();
        info.nativeCerts = this.fillConnectionInfo(info);
        info.headers = headers;
        return info;
    }

    @Override
    public void setBufferSize(int rcvSize, int sndSize) {
        this._stream.setBufferSize(rcvSize, sndSize);
    }

    @Override
    public void checkSendSize(Buffer buf) {
    }

    TransceiverI(Instance instance, SSLEngine engine, StreamSocket stream, String hostOrAdapterName, boolean incoming) {
        this._instance = instance;
        this._engine = engine;
        this._appInput = ByteBuffer.allocateDirect(engine.getSession().getApplicationBufferSize() * 2);
        this._netInput = ByteBuffer.allocateDirect(engine.getSession().getPacketBufferSize() * 2);
        this._netOutput = ByteBuffer.allocateDirect(engine.getSession().getPacketBufferSize() * 2);
        this._stream = stream;
        this._incoming = incoming;
        if (this._incoming) {
            this._adapterName = hostOrAdapterName;
        } else {
            this._host = hostOrAdapterName;
        }
    }

    private Certificate[] fillConnectionInfo(ConnectionInfo info) {
        Certificate[] nativeCerts = null;
        if (this._stream.fd() != null) {
            Socket socket = this._stream.fd().socket();
            if (socket.getLocalAddress() != null) {
                info.localAddress = socket.getLocalAddress().getHostAddress();
                info.localPort = socket.getLocalPort();
            }
            if (socket.getInetAddress() != null) {
                info.remoteAddress = socket.getInetAddress().getHostAddress();
                info.remotePort = socket.getPort();
            }
            if (!socket.isClosed()) {
                info.rcvSize = Network.getRecvBufferSize(this._stream.fd());
                info.sndSize = Network.getSendBufferSize(this._stream.fd());
            }
            SSLSession session = this._engine.getSession();
            info.cipher = session.getCipherSuite();
            try {
                Certificate[] pcerts = session.getPeerCertificates();
                Certificate[] vcerts = this._instance.engine().getVerifiedCertificateChain(pcerts);
                info.verified = vcerts != null;
                nativeCerts = vcerts != null ? vcerts : pcerts;
                ArrayList<String> certs = new ArrayList<String>();
                for (Certificate c : nativeCerts) {
                    StringBuilder s = new StringBuilder("-----BEGIN CERTIFICATE-----\n");
                    s.append(Base64.encode(c.getEncoded()));
                    s.append("\n-----END CERTIFICATE-----");
                    certs.add(s.toString());
                }
                info.certs = certs.toArray(new String[certs.size()]);
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
        info.adapterName = this._adapterName;
        info.incoming = this._incoming;
        return nativeCerts;
    }

    private int handshakeNonBlocking() {
        try {
            SSLEngineResult.HandshakeStatus status = this._engine.getHandshakeStatus();
            while (!this._engine.isOutboundDone() && !this._engine.isInboundDone()) {
                SSLEngineResult result = null;
                switch (status) {
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        return 0;
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this._engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        status = this._engine.getHandshakeStatus();
                        break;
                    }
                    case NEED_UNWRAP: {
                        if (this._netInput.position() == 0 && this._stream.read(this._netInput) == 0) {
                            return 1;
                        }
                        this._netInput.flip();
                        result = this._engine.unwrap(this._netInput, this._appInput);
                        this._netInput.compact();
                        status = result.getHandshakeStatus();
                        switch (result.getStatus()) {
                            case BUFFER_OVERFLOW: {
                                assert (false);
                                break;
                            }
                            case BUFFER_UNDERFLOW: {
                                assert (status == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                                if (this._stream.read(this._netInput) != 0) break;
                                return 1;
                            }
                            case CLOSED: {
                                throw new ConnectionLostException();
                            }
                        }
                        break;
                    }
                    case NEED_WRAP: {
                        result = this._engine.wrap(_emptyBuffer, this._netOutput);
                        if (result.bytesProduced() > 0 && !this.flushNonBlocking()) {
                            return 4;
                        }
                        status = result.getHandshakeStatus();
                    }
                }
                if (result == null) continue;
                switch (result.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        assert (false);
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        assert (status == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                        break;
                    }
                    case CLOSED: {
                        throw new ConnectionLostException();
                    }
                }
            }
        }
        catch (SSLException ex) {
            throw new SecurityException("IceSSL: handshake error", ex);
        }
        return 0;
    }

    private int writeNonBlocking(ByteBuffer buf) {
        try {
            while (buf.hasRemaining() || this._netOutput.position() > 0) {
                if (buf.hasRemaining()) {
                    SSLEngineResult result = this._engine.wrap(buf, this._netOutput);
                    switch (result.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            assert (false);
                            break;
                        }
                        case CLOSED: {
                            throw new ConnectionLostException();
                        }
                    }
                }
                if (this._netOutput.position() <= 0 || this.flushNonBlocking()) continue;
                return 4;
            }
        }
        catch (SSLException ex) {
            throw new SecurityException("IceSSL: error while encoding message", ex);
        }
        assert (this._netOutput.position() == 0);
        return 0;
    }

    private boolean flushNonBlocking() {
        this._netOutput.flip();
        try {
            this._stream.write(this._netOutput);
        }
        catch (SocketException ex) {
            throw new ConnectionLostException(ex);
        }
        if (this._netOutput.hasRemaining()) {
            this._netOutput.compact();
            return false;
        }
        this._netOutput.clear();
        return true;
    }

    private void fill(ByteBuffer buf) {
        this._appInput.flip();
        if (this._appInput.hasRemaining()) {
            int bytesNeeded;
            int bytesAvailable = this._appInput.remaining();
            if (bytesAvailable > (bytesNeeded = buf.remaining())) {
                bytesAvailable = bytesNeeded;
            }
            if (buf.hasArray()) {
                byte[] arr = buf.array();
                this._appInput.get(arr, buf.arrayOffset() + buf.position(), bytesAvailable);
                buf.position(buf.position() + bytesAvailable);
            } else if (this._appInput.hasArray()) {
                byte[] arr = this._appInput.array();
                buf.put(arr, this._appInput.arrayOffset() + this._appInput.position(), bytesAvailable);
                this._appInput.position(this._appInput.position() + bytesAvailable);
            } else {
                byte[] arr = new byte[bytesAvailable];
                this._appInput.get(arr);
                buf.put(arr);
            }
        }
        this._appInput.compact();
    }
}

