/*
 * Decompiled with CFR 0.152.
 */
package IceUtilInternal;

import Ice.Holder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class StringUtil {
    public static int findFirstOf(String str, String match) {
        return StringUtil.findFirstOf(str, match, 0);
    }

    public static int findFirstOf(String str, String match, int start) {
        int len = str.length();
        for (int i = start; i < len; ++i) {
            char ch = str.charAt(i);
            if (match.indexOf(ch) == -1) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstNotOf(String str, String match) {
        return StringUtil.findFirstNotOf(str, match, 0);
    }

    public static int findFirstNotOf(String str, String match, int start) {
        int len = str.length();
        for (int i = start; i < len; ++i) {
            char ch = str.charAt(i);
            if (match.indexOf(ch) != -1) continue;
            return i;
        }
        return -1;
    }

    private static void encodeChar(byte b, StringBuilder sb, String special) {
        switch (b) {
            case 92: {
                sb.append("\\\\");
                break;
            }
            case 39: {
                sb.append("\\'");
                break;
            }
            case 34: {
                sb.append("\\\"");
                break;
            }
            case 8: {
                sb.append("\\b");
                break;
            }
            case 12: {
                sb.append("\\f");
                break;
            }
            case 10: {
                sb.append("\\n");
                break;
            }
            case 13: {
                sb.append("\\r");
                break;
            }
            case 9: {
                sb.append("\\t");
                break;
            }
            default: {
                if (b < 32 || b > 126) {
                    sb.append('\\');
                    String octal = Integer.toOctalString(b < 0 ? b + 256 : b);
                    for (int j = octal.length(); j < 3; ++j) {
                        sb.append('0');
                    }
                    sb.append(octal);
                    break;
                }
                if (special != null && special.indexOf((char)b) != -1) {
                    sb.append('\\');
                    sb.append((char)b);
                    break;
                }
                sb.append((char)b);
            }
        }
    }

    public static String escapeString(String s, String special) {
        if (special != null) {
            for (int i = 0; i < special.length(); ++i) {
                if (special.charAt(i) >= ' ' && special.charAt(i) <= '~') continue;
                throw new IllegalArgumentException("special characters must be in ASCII range 32-126");
            }
        }
        byte[] bytes = null;
        try {
            bytes = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            assert (false);
            return null;
        }
        StringBuilder result = new StringBuilder(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            StringUtil.encodeChar(bytes[i], result, special);
        }
        return result.toString();
    }

    private static char checkChar(String s, int pos) {
        char c = s.charAt(pos);
        if (c < ' ' || c > '~') {
            String msg = pos > 0 ? "character after `" + s.substring(0, pos) + "'" : "first character";
            msg = msg + " is not a printable ASCII character (ordinal " + c + ")";
            throw new IllegalArgumentException(msg);
        }
        return c;
    }

    private static char decodeChar(String s, int start, int end, Holder<Integer> nextStart) {
        int c;
        assert (start >= 0);
        assert (start < end);
        assert (end <= s.length());
        if (s.charAt(start) != '\\') {
            c = StringUtil.checkChar(s, start++);
        } else {
            if (start + 1 == end) {
                throw new IllegalArgumentException("trailing backslash");
            }
            switch (s.charAt(++start)) {
                case '\"': 
                case '\'': 
                case '\\': {
                    c = s.charAt(start++);
                    break;
                }
                case 'b': {
                    ++start;
                    c = 8;
                    break;
                }
                case 'f': {
                    ++start;
                    c = 12;
                    break;
                }
                case 'n': {
                    ++start;
                    c = 10;
                    break;
                }
                case 'r': {
                    ++start;
                    c = 13;
                    break;
                }
                case 't': {
                    ++start;
                    c = 9;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int val = 0;
                    for (int j = 0; j < 3 && start < end; ++j) {
                        int charVal;
                        if ((charVal = s.charAt(start++) - 48) < 0 || charVal > 7) {
                            --start;
                            break;
                        }
                        val = val * 8 + charVal;
                    }
                    if (val > 255) {
                        String msg = "octal value \\" + Integer.toOctalString(val) + " (" + val + ") is out of range";
                        throw new IllegalArgumentException(msg);
                    }
                    c = (char)val;
                    break;
                }
                default: {
                    c = StringUtil.checkChar(s, start++);
                }
            }
        }
        nextStart.value = start;
        return (char)c;
    }

    private static void decodeString(String s, int start, int end, StringBuilder sb) {
        Holder<Integer> nextStart = new Holder<Integer>();
        while (start < end) {
            sb.append(StringUtil.decodeChar(s, start, end, nextStart));
            start = (Integer)nextStart.value;
        }
    }

    public static String unescapeString(String s, int start, int end) {
        assert (start >= 0 && start <= end && end <= s.length());
        StringBuilder sb = new StringBuilder(end - start);
        StringUtil.decodeString(s, start, end, sb);
        String decodedString = sb.toString();
        byte[] arr = new byte[decodedString.length()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)decodedString.charAt(i);
        }
        try {
            return new String(arr, 0, arr.length, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("unsupported encoding", ex);
        }
    }

    public static String joinString(List<String> values, String delimiter) {
        StringBuffer s = new StringBuffer();
        boolean first = true;
        for (String v : values) {
            if (!first) {
                s.append(delimiter);
            }
            s.append(v);
            first = false;
        }
        return s.toString();
    }

    public static String[] splitString(String str, String delim) {
        ArrayList<String> l = new ArrayList<String>();
        char[] arr = new char[str.length()];
        int pos = 0;
        int n = 0;
        char quoteChar = '\u0000';
        while (pos < str.length()) {
            if (quoteChar == '\u0000' && (str.charAt(pos) == '\"' || str.charAt(pos) == '\'')) {
                quoteChar = str.charAt(pos++);
                continue;
            }
            if (quoteChar == '\u0000' && str.charAt(pos) == '\\' && pos + 1 < str.length() && (str.charAt(pos + 1) == '\"' || str.charAt(pos + 1) == '\'')) {
                ++pos;
            } else if (quoteChar != '\u0000' && str.charAt(pos) == '\\' && pos + 1 < str.length() && str.charAt(pos + 1) == quoteChar) {
                ++pos;
            } else {
                if (quoteChar != '\u0000' && str.charAt(pos) == quoteChar) {
                    ++pos;
                    quoteChar = '\u0000';
                    continue;
                }
                if (delim.indexOf(str.charAt(pos)) != -1 && quoteChar == '\u0000') {
                    ++pos;
                    if (n <= 0) continue;
                    l.add(new String(arr, 0, n));
                    n = 0;
                    continue;
                }
            }
            if (pos >= str.length()) continue;
            arr[n++] = str.charAt(pos++);
        }
        if (n > 0) {
            l.add(new String(arr, 0, n));
        }
        if (quoteChar != '\u0000') {
            return null;
        }
        return l.toArray(new String[0]);
    }

    public static int checkQuote(String s) {
        return StringUtil.checkQuote(s, 0);
    }

    public static int checkQuote(String s, int start) {
        char quoteChar = s.charAt(start);
        if (quoteChar == '\"' || quoteChar == '\'') {
            int pos;
            ++start;
            int len = s.length();
            while (start < len && (pos = s.indexOf(quoteChar, start)) != -1) {
                if (s.charAt(pos - 1) != '\\') {
                    return pos;
                }
                start = pos + 1;
            }
            return -1;
        }
        return 0;
    }

    public static boolean match(String s, String pat, boolean emptyMatch) {
        assert (s.length() > 0);
        assert (pat.length() > 0);
        int beginIndex = pat.indexOf(42);
        if (beginIndex < 0) {
            return s.equals(pat);
        }
        if (beginIndex > s.length() || !s.substring(0, beginIndex).equals(pat.substring(0, beginIndex))) {
            return false;
        }
        int endLength = pat.length() - beginIndex - 1;
        if (endLength == 0) {
            return true;
        }
        if (endLength > s.length()) {
            return false;
        }
        int endIndex = s.length() - endLength;
        if (endIndex < beginIndex || !emptyMatch && endIndex == beginIndex) {
            return false;
        }
        return s.substring(endIndex, s.length() - endIndex).equals(pat.substring(beginIndex + 1, pat.length() - beginIndex - 1));
    }
}

