/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.quantum;

import ome.model.core.Pixels;
import ome.model.display.QuantumDef;
import ome.model.enums.Family;
import omeis.providers.re.data.PlaneFactory;
import omeis.providers.re.metadata.StatsFactory;
import omeis.providers.re.quantum.ExponentialMap;
import omeis.providers.re.quantum.LogarithmicMap;
import omeis.providers.re.quantum.PolynomialMap;
import omeis.providers.re.quantum.QuantizationException;
import omeis.providers.re.quantum.QuantumMap;

public abstract class QuantumStrategy {
    public static final int MAX = 255;
    public static final int MIN = 0;
    public static final int DECILE = 10;
    static final double MAX_SIZE_LUT = 65536.0;
    static final long MAX_SIZE = 1000L;
    private double pixelsTypeMin = 0.0;
    private double pixelsTypeMax = 0.0;
    private double globalMin = 0.0;
    private double globalMax = 1.0;
    private double originalGlobalMin;
    private double originalGlobalMax;
    private double windowStart = 0.0;
    private double windowEnd = 1.0;
    private Family family;
    private double curveCoefficient = 1.0;
    private boolean noiseReduction;
    protected final QuantumDef qDef;
    protected final Pixels pixels;
    protected QuantumMap valueMapper;

    private void defineMapper(Family family) {
        String value = family.getValue();
        QuantumStrategy.verifyFamily(value);
        if (value.equals("linear") || value.equals("polynomial")) {
            this.valueMapper = new PolynomialMap();
        } else if (value.equals("logarithmic")) {
            this.valueMapper = new LogarithmicMap();
        } else if (value.equals("exponential")) {
            this.valueMapper = new ExponentialMap();
        }
    }

    private static void verifyFamily(String value) {
        if (!(value.equals("linear") || value.equals("logarithmic") || value.equals("exponential") || value.equals("polynomial"))) {
            throw new IllegalArgumentException("Unsupported family type: '" + value + "'");
        }
    }

    private boolean verifyInterval(double min, double max) {
        boolean b = false;
        if (min <= max) {
            double range = max - min;
            if (PlaneFactory.in(this.pixels.getPixelsType(), new String[]{"int8", "uint8"})) {
                if (range < 256.0) {
                    b = true;
                }
            } else if (PlaneFactory.in(this.pixels.getPixelsType(), new String[]{"int16", "uint16"})) {
                if (range < 65536.0) {
                    b = true;
                }
            } else if (PlaneFactory.in(this.pixels.getPixelsType(), new String[]{"int32", "uint32"})) {
                if (range < 4.294967296E9) {
                    b = true;
                }
            } else if (PlaneFactory.in(this.pixels.getPixelsType(), new String[]{"float", "double"})) {
                b = true;
            }
        }
        return b;
    }

    private void initPixelsRange(boolean withRange) {
        StatsFactory sf = new StatsFactory();
        double[] values = sf.initPixelsRange(this.pixels);
        this.pixelsTypeMin = values[0];
        this.pixelsTypeMax = values[1];
    }

    protected QuantumStrategy(QuantumDef qd, Pixels pixels) {
        if (qd == null) {
            throw new NullPointerException("No quantum definition");
        }
        this.qDef = qd;
        if (pixels == null) {
            throw new NullPointerException("No pixels");
        }
        this.pixels = pixels;
        this.initPixelsRange(false);
    }

    protected Double getMiddleRange(double value) {
        double min = this.getWindowStart();
        double max = this.getWindowEnd();
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        double step = Math.abs(max - min) / (double)(this.qDef.getCdEnd() - this.qDef.getCdStart() + 1);
        if (value == min) {
            return min + step / 2.0;
        }
        int v = (int)((value - min) / step);
        return (min + (double)(v - 1) * step + min + (double)v * step) / 2.0;
    }

    public void setExtent(double globalMin, double globalMax) {
        this.originalGlobalMin = globalMin;
        this.originalGlobalMax = globalMax;
        this.initPixelsRange(false);
        if (Double.isInfinite(globalMax) || globalMax > this.pixelsTypeMax) {
            globalMax = this.pixelsTypeMax;
        }
        if (Double.isInfinite(globalMin) || globalMin < this.pixelsTypeMin) {
            globalMin = this.pixelsTypeMin;
        }
        if (!this.verifyInterval(globalMin, globalMax)) {
            globalMax = this.pixelsTypeMax;
            globalMin = this.pixelsTypeMin;
        }
        this.globalMin = globalMin;
        this.globalMax = globalMax;
        this.windowStart = globalMin;
        this.windowEnd = globalMax;
        this.initPixelsRange(true);
    }

    public void setWindow(double start, double end) {
        this.verifyInterval(start, end);
        if (!this.verifyInterval(start, end)) {
            end = this.pixelsTypeMax;
            start = this.pixelsTypeMin;
        }
        if (start < this.pixelsTypeMin) {
            start = this.pixelsTypeMin;
        }
        if (end > this.pixelsTypeMax) {
            end = this.pixelsTypeMax;
        }
        this.windowStart = start;
        this.windowEnd = end;
        this.onWindowChange();
    }

    public void setMapping(Family family, double k, boolean noiseReduction) {
        if (k <= 0.0) {
            throw new IllegalArgumentException("Unsupported curve coefficient: '" + k + "'");
        }
        this.defineMapper(family);
        this.family = family;
        String value = family.getValue();
        if (value.equals("linear")) {
            k = 1.0;
        }
        this.curveCoefficient = k;
        this.noiseReduction = noiseReduction;
    }

    public void setQuantizationMap(Family family, double k, boolean noiseReduction) {
        this.setMapping(family, k, noiseReduction);
        this.onWindowChange();
    }

    public void setMap(QuantumMap qMap) {
        this.valueMapper = qMap;
    }

    public Family getFamily() {
        return this.family;
    }

    public double getCurveCoefficient() {
        return this.curveCoefficient;
    }

    public boolean getNoiseReduction() {
        return this.noiseReduction;
    }

    public double getGlobalMin() {
        double d = this.globalMin - Math.floor(this.globalMin);
        if (d != 0.0) {
            this.globalMin = Math.floor(this.globalMin);
        }
        return this.globalMin;
    }

    public double getGlobalMax() {
        return this.globalMax;
    }

    public double getOriginalGlobalMin() {
        return this.originalGlobalMin;
    }

    public double getOriginalGlobalMax() {
        return this.originalGlobalMax;
    }

    public double getPixelsTypeMin() {
        return this.pixelsTypeMin;
    }

    public double getPixelsTypeMax() {
        return this.pixelsTypeMax;
    }

    public double getWindowStart() {
        return this.windowStart;
    }

    public double getWindowEnd() {
        return this.windowEnd;
    }

    protected abstract void onWindowChange();

    public abstract int quantize(double var1) throws QuantizationException;
}

