/*
 * Decompiled with CFR 0.152.
 */
package ome.security;

import ome.conditions.ApiUsageException;
import ome.conditions.SecurityViolation;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.model.meta.ExperimenterGroup;
import ome.security.AdminAction;
import ome.security.SecureAction;
import ome.security.SecuritySystem;
import ome.security.basic.BasicSecuritySystem;
import ome.security.sharing.SharingSecuritySystem;
import ome.system.EventContext;
import ome.system.Principal;
import ome.system.Roles;

public class SecuritySystemHolder
implements SecuritySystem {
    protected final BasicSecuritySystem basic;
    protected final SharingSecuritySystem sharing;
    protected ThreadLocal<SecuritySystem> current = new ThreadLocal<SecuritySystem>(){

        @Override
        protected SecuritySystem initialValue() {
            return SecuritySystemHolder.this.basic;
        }
    };

    public SecuritySystemHolder(BasicSecuritySystem basic, SharingSecuritySystem sharing) {
        this.basic = basic;
        this.sharing = sharing;
    }

    public SecuritySystem choose() {
        Long shareId = this.basic.getEventContext().getCurrentShareId();
        if (shareId == null) {
            return this.basic;
        }
        return this.sharing;
    }

    @Override
    public Details checkManagedDetails(IObject object, Details trustedDetails) throws ApiUsageException, SecurityViolation {
        return this.choose().checkManagedDetails(object, trustedDetails);
    }

    @Override
    public void invalidateEventContext() {
        this.choose().invalidateEventContext();
    }

    @Override
    public void disable(String ... ids) {
        this.choose().disable(ids);
    }

    @Override
    public <T extends IObject> T doAction(SecureAction action, T ... objs) {
        return (T)this.choose().doAction(action, (IObject[])objs);
    }

    @Override
    public void enable(String ... ids) {
        this.choose().enable(ids);
    }

    @Override
    public EventContext getEventContext() {
        return this.choose().getEventContext();
    }

    @Override
    public EventContext getEventContext(boolean refresh) {
        return this.choose().getEventContext(refresh);
    }

    @Override
    public Long getEffectiveUID() {
        return this.choose().getEffectiveUID();
    }

    @Override
    public Roles getSecurityRoles() {
        return this.choose().getSecurityRoles();
    }

    @Override
    public boolean hasPrivilegedToken(IObject obj) {
        return this.choose().hasPrivilegedToken(obj);
    }

    @Override
    public void checkRestriction(String name, IObject obj) {
        this.choose().checkRestriction(name, obj);
    }

    @Override
    public boolean isDisabled(String id) {
        return this.choose().isDisabled(id);
    }

    @Override
    public boolean isReady() {
        return this.choose().isReady();
    }

    @Override
    public boolean isSystemType(Class<? extends IObject> klass) {
        return this.choose().isSystemType(klass);
    }

    @Override
    public void loadEventContext(boolean isReadOnly) {
        this.choose().loadEventContext(isReadOnly);
    }

    @Override
    public void login(Principal principal) {
        this.choose().login(principal);
    }

    @Override
    public int logout() {
        return this.choose().logout();
    }

    @Override
    public Details newTransientDetails(IObject object) throws ApiUsageException, SecurityViolation {
        return this.choose().newTransientDetails(object);
    }

    @Override
    public void runAsAdmin(AdminAction action) {
        this.choose().runAsAdmin(action);
    }

    @Override
    public void runAsAdmin(ExperimenterGroup group, AdminAction action) {
        this.choose().runAsAdmin(group, action);
    }

    @Override
    public boolean isGraphCritical(Details details) {
        return this.choose().isGraphCritical(details);
    }
}

