/*
 * Decompiled with CFR 0.152.
 */
package ome.services.search;

import java.io.IOException;
import java.util.ArrayList;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.model.annotations.CommentAnnotation;
import ome.services.search.SearchAction;
import ome.services.search.SearchValues;
import ome.system.ServiceFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyTermEnum;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.store.DirectoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class SimilarTerms
extends SearchAction {
    private static final Logger log = LoggerFactory.getLogger(SimilarTerms.class);
    private static final long serialVersionUID = 1L;
    private final String[] terms;

    public SimilarTerms(SearchValues values, String ... terms) {
        super(values);
        this.terms = terms;
    }

    @Transactional(readOnly=true)
    public Object doWork(Session s, ServiceFactory sf) {
        if (this.values.onlyTypes == null || this.values.onlyTypes.size() != 1) {
            throw new ApiUsageException("Searches by similar terms are currently limited to a single type.\nPlese use Search.onlyType()");
        }
        Class cls = this.values.onlyTypes.get(0);
        FullTextSession session = Search.getFullTextSession((Session)s);
        SearchFactory factory = session.getSearchFactory();
        Object[] directory = factory.getDirectoryProviders(cls);
        ReaderProvider provider = factory.getReaderProvider();
        Assert.notEmpty((Object[])directory, (String)"Must have a directory provider");
        Assert.isTrue((directory.length == 1 ? 1 : 0) != 0, (String)"Can only handle one directory");
        IndexReader reader = provider.openReader(new DirectoryProvider[]{directory[0]});
        FuzzyTermEnum fuzzy = null;
        CommentAnnotation rv = new ArrayList();
        try {
            CommentAnnotation text;
            fuzzy = new FuzzyTermEnum(reader, new Term("combined_fields", this.terms[0]));
            while (fuzzy.next()) {
                text = new CommentAnnotation();
                text.setNs(this.terms[0]);
                text.setTextValue(fuzzy.term().text());
                rv.add(text);
            }
            text = rv;
            return text;
        }
        catch (IOException e) {
            throw new InternalException("Error reading from index: " + e.getMessage());
        }
        finally {
            if (fuzzy != null) {
                fuzzy.endEnum();
            }
        }
    }
}

