/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import ome.model.enums.AdminPrivilege;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.Session;
import ome.services.sessions.SessionContext;
import ome.services.sessions.stats.SessionStats;
import ome.system.Roles;

public class SessionContextImpl
implements SessionContext {
    private final SessionContext.Count count;
    private final Roles _roles;
    private final Session session;
    private final SessionStats stats;
    private final Set<AdminPrivilege> adminPrivileges;
    private final List<Long> leaderOfGroups;
    private final List<Long> memberOfGroups;
    private final List<String> roles;
    private Long shareId = null;

    public SessionContextImpl(Session session, List<Long> lGroups, List<Long> mGroups, List<String> roles, SessionStats stats, SessionContext previous) {
        this(session, Collections.emptySet(), lGroups, mGroups, roles, stats, new Roles(), previous);
    }

    public SessionContextImpl(Session session, Set<AdminPrivilege> adminPrivileges, List<Long> lGroups, List<Long> mGroups, List<String> roles, SessionStats stats, Roles _roles, SessionContext previous) {
        this._roles = _roles;
        this.stats = stats;
        this.session = session;
        if (previous != null) {
            this.count = previous.count();
            this.shareId = previous.getCurrentShareId();
        } else {
            this.count = new SessionContext.Count(session.getUuid());
        }
        this.adminPrivileges = ImmutableSet.copyOf(adminPrivileges);
        this.leaderOfGroups = Collections.unmodifiableList(new ArrayList<Long>(lGroups));
        this.memberOfGroups = Collections.unmodifiableList(new ArrayList<Long>(mGroups));
        this.roles = Collections.unmodifiableList(new ArrayList<String>(roles));
        this.getCurrentGroupPermissions();
    }

    @Override
    public SessionContext.Count count() {
        return this.count;
    }

    @Override
    public SessionStats stats() {
        return this.stats;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public List<String> getUserRoles() {
        return this.roles;
    }

    @Override
    public void setShareId(Long shareId) {
        this.shareId = shareId;
    }

    public Long getCurrentShareId() {
        return this.shareId;
    }

    public Long getCurrentSessionId() {
        return this.getSession().getId();
    }

    public String getCurrentSessionUuid() {
        return this.getSession().getUuid();
    }

    public Long getCurrentEventId() {
        throw new UnsupportedOperationException();
    }

    public String getCurrentEventType() {
        return this.session.getDefaultEventType();
    }

    public Long getCurrentGroupId() {
        return this.session.getDetails().getGroup().getId();
    }

    public String getCurrentGroupName() {
        return this.session.getDetails().getGroup().getName();
    }

    public Permissions getCurrentGroupPermissions() {
        return this.session.getDetails().getGroup().getDetails().getPermissions();
    }

    public Long getCurrentUserId() {
        return this.session.getDetails().getOwner().getId();
    }

    public String getCurrentUserName() {
        return this.session.getDetails().getOwner().getOmeName();
    }

    public Long getCurrentSudoerId() {
        Experimenter sudoer = this.session.getSudoer();
        return sudoer == null ? null : sudoer.getId();
    }

    public String getCurrentSudoerName() {
        Experimenter sudoer = this.session.getSudoer();
        return sudoer == null ? null : sudoer.getOmeName();
    }

    public List<Long> getLeaderOfGroupsList() {
        return this.leaderOfGroups;
    }

    public List<Long> getMemberOfGroupsList() {
        return this.memberOfGroups;
    }

    public boolean isCurrentUserAdmin() {
        if (this._roles == null) {
            throw new UnsupportedOperationException();
        }
        return this.memberOfGroups.contains(this._roles.getSystemGroupId());
    }

    public Set<AdminPrivilege> getCurrentAdminPrivileges() {
        return this.adminPrivileges;
    }

    public boolean isReadOnly() {
        throw new UnsupportedOperationException();
    }

    public Permissions getCurrentUmask() {
        throw new UnsupportedOperationException();
    }
}

