/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ome.conditions.InternalException;
import ome.model.enums.AdminPrivilege;
import ome.model.internal.Permissions;
import ome.system.EventContext;

public class SimpleEventContext
implements EventContext,
Serializable {
    private static final long serialVersionUID = -391820349350359539L;
    protected Long shareId;
    protected Long csId;
    protected Long cgId;
    protected Long cuId;
    protected Long csuId;
    protected Long ceId;
    protected String csName;
    protected String cgName;
    protected String cuName;
    protected String csuName;
    protected String ceType;
    protected boolean isAdmin;
    protected Set<AdminPrivilege> adminPrivileges;
    protected boolean isReadOnly;
    protected List<Long> memberOfGroups;
    protected List<Long> leaderOfGroups;
    protected Permissions umask;
    private Permissions groupPermissions;

    protected SimpleEventContext() {
    }

    public SimpleEventContext(EventContext ec) {
        if (ec == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        this.copy(ec);
    }

    protected void copy(EventContext ec) {
        this.shareId = ec.getCurrentShareId();
        this.csId = ec.getCurrentSessionId();
        this.cgId = ec.getCurrentGroupId();
        this.cuId = ec.getCurrentUserId();
        this.csuId = ec.getCurrentSudoerId();
        this.csName = ec.getCurrentSessionUuid();
        this.cgName = ec.getCurrentGroupName();
        this.cuName = ec.getCurrentUserName();
        this.csuName = ec.getCurrentSudoerName();
        this.ceType = ec.getCurrentEventType();
        this.memberOfGroups = new ArrayList<Long>(ec.getMemberOfGroupsList());
        this.leaderOfGroups = new ArrayList<Long>(ec.getLeaderOfGroupsList());
        this.setGroupPermissions(ec.getCurrentGroupPermissions());
        try {
            this.isAdmin = ec.isCurrentUserAdmin();
            this.adminPrivileges = ec.getCurrentAdminPrivileges();
            this.isReadOnly = ec.isReadOnly();
            this.ceId = ec.getCurrentEventId();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public Long getCurrentShareId() {
        return this.shareId;
    }

    @Override
    public Long getCurrentSessionId() {
        return this.csId;
    }

    @Override
    public String getCurrentSessionUuid() {
        return this.csName;
    }

    @Override
    public Long getCurrentGroupId() {
        return this.cgId;
    }

    @Override
    public String getCurrentGroupName() {
        return this.cgName;
    }

    @Override
    public Long getCurrentUserId() {
        return this.cuId;
    }

    @Override
    public String getCurrentUserName() {
        return this.cuName;
    }

    @Override
    public Long getCurrentSudoerId() {
        return this.csuId;
    }

    @Override
    public String getCurrentSudoerName() {
        return this.csuName;
    }

    @Override
    public boolean isCurrentUserAdmin() {
        return this.isAdmin;
    }

    @Override
    public Set<AdminPrivilege> getCurrentAdminPrivileges() {
        return this.adminPrivileges;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public List<Long> getMemberOfGroupsList() {
        return this.memberOfGroups;
    }

    @Override
    public List<Long> getLeaderOfGroupsList() {
        return this.leaderOfGroups;
    }

    @Override
    public Long getCurrentEventId() {
        return this.ceId;
    }

    @Override
    public String getCurrentEventType() {
        return this.ceType;
    }

    public Permissions getCurrentUmask() {
        return this.umask;
    }

    @Override
    public Permissions getCurrentGroupPermissions() {
        return this.groupPermissions;
    }

    protected void setGroupPermissions(Permissions p) {
        this.groupPermissions = p;
        if (this.groupPermissions == null) {
            throw new InternalException("null permissions");
        }
    }
}

