/*
 * Decompiled with CFR 0.152.
 */
package ome.io.bioformats;

import java.awt.Dimension;
import java.io.IOException;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import ome.conditions.ResourceError;
import ome.io.bioformats.BfPixelsWrapper;
import ome.io.nio.DimensionsOutOfBoundsException;
import ome.io.nio.PixelBuffer;
import ome.io.nio.RomioPixelBuffer;
import ome.util.PixelData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BfPixelBuffer
implements PixelBuffer,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(BfPixelBuffer.class);
    protected final String filePath;
    protected final IFormatReader bfReader;
    protected final AtomicReference<BfPixelsWrapper> reader = new AtomicReference();
    private int seriesIndex = 0;

    public BfPixelBuffer(String filePath, IFormatReader bfReader) throws IOException, FormatException {
        this.filePath = filePath;
        this.bfReader = bfReader;
    }

    protected BfPixelsWrapper reader() {
        BfPixelsWrapper wrapper = this.reader.get();
        if (wrapper == null) {
            try {
                wrapper = new BfPixelsWrapper(this.filePath, this.bfReader);
            }
            catch (FormatException fe) {
                log.debug("FormatException: " + this.filePath, (Throwable)fe);
                throw new ResourceError("FormatException: " + this.filePath + "\n" + fe.getMessage());
            }
            catch (Exception e) {
                log.error("Failed to instantiate BfPixelsWrapper with " + this.filePath);
                throw new RuntimeException(e);
            }
            boolean wasSet = this.reader.compareAndSet(null, wrapper);
            if (!wasSet) {
                try {
                    wrapper.close();
                }
                catch (IOException ex) {
                    log.error("Failed to close BfPixelsWrapper", (Throwable)ex);
                    throw new RuntimeException(ex);
                }
                wrapper = this.reader.get();
            }
            this.setSeries(this.seriesIndex);
            this.setResolutionLevel(this.getResolutionLevels() - 1);
        }
        return wrapper;
    }

    public boolean isLittleEndian() {
        this.reader();
        return this.bfReader.isLittleEndian();
    }

    public void setSeries(int series) {
        this.reader();
        this.bfReader.setSeries(series);
        this.seriesIndex = series;
    }

    public int getSeries() {
        this.reader();
        return this.bfReader.getSeries();
    }

    @Override
    public byte[] calculateMessageDigest() throws IOException {
        return this.reader().getMessageDigest();
    }

    @Override
    public void checkBounds(Integer x, Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        this.reader().checkBounds(x, y, z, c, t);
    }

    @Override
    public void close() throws IOException {
        BfPixelsWrapper wrapper = this.reader.get();
        if (wrapper != null) {
            try {
                wrapper.close();
            }
            catch (IOException | RuntimeException ex) {
                log.error("Failed to close BfPixelsWrapper", (Throwable)ex);
                throw ex;
            }
            finally {
                this.reader.set(null);
            }
        }
    }

    @Override
    public int getByteWidth() {
        return this.reader().getByteWidth();
    }

    @Override
    public PixelData getCol(Integer x, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        BfPixelsWrapper reader = this.reader();
        byte[] buffer = new byte[reader.getColSize().intValue()];
        reader.getCol(x, z, c, t, buffer);
        PixelData d = new PixelData(reader.getPixelsType(), ByteBuffer.wrap(buffer));
        d.setOrder(this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        return d;
    }

    @Override
    public byte[] getColDirect(Integer x, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        try {
            BfPixelsWrapper reader = this.reader();
            reader.getCol(x, z, c, t, buffer);
            reader.swapIfRequired(buffer);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    @Override
    public Integer getColSize() {
        return this.reader().getColSize();
    }

    @Override
    public long getId() {
        return this.reader().getId();
    }

    @Override
    public String getPath() {
        return this.reader().getPath();
    }

    @Override
    public PixelData getPlane(Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        BfPixelsWrapper reader = this.reader();
        int size = RomioPixelBuffer.safeLongToInteger(reader.getPlaneSize());
        byte[] buffer = new byte[size];
        reader.getPlane(z, c, t, buffer);
        PixelData d = new PixelData(reader.getPixelsType(), ByteBuffer.wrap(buffer));
        d.setOrder(this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        return d;
    }

    @Override
    public byte[] getPlaneDirect(Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        try {
            BfPixelsWrapper reader = this.reader();
            reader.getPlane(z, c, t, buffer);
            reader.swapIfRequired(buffer);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    @Override
    public Long getPlaneOffset(Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        return this.reader().getPlaneOffset(z, c, t);
    }

    @Override
    public byte[] getPlaneRegionDirect(Integer z, Integer c, Integer t, Integer count, Integer offset, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not yet supported, raise ticket to implement if required");
    }

    @Override
    public Long getPlaneSize() {
        return this.reader().getPlaneSize();
    }

    @Override
    public PixelData getRegion(Integer size, Long offset) throws IOException {
        throw new UnsupportedOperationException("Not yet supported, raise ticket to implement if required");
    }

    @Override
    public byte[] getRegionDirect(Integer size, Long offset, byte[] buffer) throws IOException {
        throw new UnsupportedOperationException("Not yet supported, raise ticket to implement if required");
    }

    @Override
    public PixelData getRow(Integer y, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        BfPixelsWrapper reader = this.reader();
        byte[] buffer = new byte[reader.getRowSize().intValue()];
        reader.getRow(y, z, c, t, buffer);
        PixelData d = new PixelData(reader.getPixelsType(), ByteBuffer.wrap(buffer));
        d.setOrder(this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        return d;
    }

    @Override
    public byte[] getRowDirect(Integer y, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        try {
            BfPixelsWrapper reader = this.reader();
            reader.getRow(y, z, c, t, buffer);
            reader.swapIfRequired(buffer);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    @Override
    public Long getRowOffset(Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        return this.reader().getRowOffset(y, z, c, t);
    }

    @Override
    public Integer getRowSize() {
        return this.reader().getRowSize();
    }

    @Override
    public int getSizeC() {
        return this.reader().getSizeC();
    }

    @Override
    public int getSizeT() {
        return this.reader().getSizeT();
    }

    @Override
    public int getSizeX() {
        return this.reader().getSizeX();
    }

    @Override
    public int getSizeY() {
        return this.reader().getSizeY();
    }

    @Override
    public int getSizeZ() {
        return this.reader().getSizeZ();
    }

    @Override
    public PixelData getStack(Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        BfPixelsWrapper reader = this.reader();
        int size = RomioPixelBuffer.safeLongToInteger(reader.getStackSize());
        byte[] buffer = new byte[size];
        reader.getStack(c, t, buffer);
        PixelData d = new PixelData(reader.getPixelsType(), ByteBuffer.wrap(buffer));
        d.setOrder(this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        return d;
    }

    @Override
    public byte[] getStackDirect(Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        try {
            BfPixelsWrapper reader = this.reader();
            reader.getStack(c, t, buffer);
            reader.swapIfRequired(buffer);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    @Override
    public Long getStackOffset(Integer c, Integer t) throws DimensionsOutOfBoundsException {
        return this.reader().getStackOffset(c, t);
    }

    @Override
    public Long getStackSize() {
        return this.reader().getStackSize();
    }

    @Override
    public PixelData getTimepoint(Integer t) throws IOException, DimensionsOutOfBoundsException {
        BfPixelsWrapper reader = this.reader();
        int size = RomioPixelBuffer.safeLongToInteger(reader.getTimepointSize());
        byte[] buffer = new byte[size];
        reader.getTimepoint(t, buffer);
        PixelData d = new PixelData(reader.getPixelsType(), ByteBuffer.wrap(buffer));
        d.setOrder(this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        return d;
    }

    @Override
    public byte[] getTimepointDirect(Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        try {
            BfPixelsWrapper reader = this.reader();
            reader.getTimepoint(t, buffer);
            reader.swapIfRequired(buffer);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    @Override
    public Long getTimepointOffset(Integer t) throws DimensionsOutOfBoundsException {
        return this.reader().getTimepointOffset(t);
    }

    @Override
    public Long getTimepointSize() {
        return this.reader().getTimepointSize();
    }

    @Override
    public Long getTotalSize() {
        return this.reader().getTotalSize();
    }

    @Override
    public boolean isFloat() {
        return this.reader().isFloat();
    }

    @Override
    public boolean isSigned() {
        return this.reader().isSigned();
    }

    @Override
    public void setPlane(ByteBuffer buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setPlane(byte[] buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setRegion(Integer size, Long offset, byte[] buffer) throws IOException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setRegion(Integer size, Long offset, ByteBuffer buffer) throws IOException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setRow(ByteBuffer buffer, Integer y, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setStack(ByteBuffer buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setStack(byte[] buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setTimepoint(ByteBuffer buffer, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setTimepoint(byte[] buffer, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public Long getHypercubeSize(List<Integer> offset, List<Integer> size, List<Integer> step) throws DimensionsOutOfBoundsException {
        BfPixelsWrapper reader = this.reader();
        return reader.getHypercubeSize(offset, size, step);
    }

    @Override
    public PixelData getHypercube(List<Integer> offset, List<Integer> size, List<Integer> step) throws IOException, DimensionsOutOfBoundsException {
        BfPixelsWrapper reader = this.reader();
        int hypercubeSize = RomioPixelBuffer.safeLongToInteger(this.getHypercubeSize(offset, size, step));
        byte[] buffer = new byte[hypercubeSize];
        reader.getHypercube(offset, size, step, buffer);
        PixelData d = new PixelData(reader.getPixelsType(), ByteBuffer.wrap(buffer));
        d.setOrder(this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        return d;
    }

    @Override
    public byte[] getHypercubeDirect(List<Integer> offset, List<Integer> size, List<Integer> step, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        try {
            BfPixelsWrapper reader = this.reader();
            reader.getHypercube(offset, size, step, buffer);
            reader.swapIfRequired(buffer);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    @Override
    public PixelData getPlaneRegion(Integer x, Integer y, Integer width, Integer height, Integer z, Integer c, Integer t, Integer stride) throws IOException, DimensionsOutOfBoundsException {
        List<Integer> offset = Arrays.asList(x, y, z, c, t);
        List<Integer> size = Arrays.asList(width, height, 1, 1, 1);
        List<Integer> step = Arrays.asList(stride + 1, stride + 1, 1, 1, 1);
        return this.getHypercube(offset, size, step);
    }

    @Override
    public PixelData getTile(Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h) throws IOException {
        BfPixelsWrapper reader = this.reader();
        byte[] buffer = new byte[w * h * FormatTools.getBytesPerPixel((String)reader.getPixelsType())];
        try {
            this.reader().getTile(z, c, t, x, y, w, h, buffer);
            PixelData d = new PixelData(reader.getPixelsType(), ByteBuffer.wrap(buffer));
            d.setOrder(this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            return d;
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getTileDirect(Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h, byte[] buffer) throws IOException {
        try {
            this.reader().getTile(z, c, t, x, y, w, h, buffer);
            this.reader().swapIfRequired(buffer);
            return buffer;
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setTile(byte[] buffer, Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h) throws IOException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public int getResolutionLevel() {
        this.reader();
        return Math.abs(this.bfReader.getResolution() - (this.getResolutionLevels() - 1));
    }

    @Override
    public int getResolutionLevels() {
        this.reader();
        return this.bfReader.getResolutionCount();
    }

    @Override
    public Dimension getTileSize() {
        this.reader();
        return new Dimension(this.bfReader.getOptimalTileWidth(), this.bfReader.getOptimalTileHeight());
    }

    @Override
    public List<List<Integer>> getResolutionDescriptions() {
        ArrayList<List<Integer>> rv = new ArrayList<List<Integer>>();
        int no = this.bfReader.getResolutionCount();
        List cms = this.bfReader.getCoreMetadataList();
        for (int i = 0; i < no; ++i) {
            int coreIndex = this.bfReader.seriesToCoreIndex(this.bfReader.getSeries()) + i;
            CoreMetadata cm = (CoreMetadata)cms.get(coreIndex);
            List<Integer> sizes = Arrays.asList(cm.sizeX, cm.sizeY);
            rv.add(sizes);
        }
        return rv;
    }

    @Override
    public void setResolutionLevel(int resolutionLevel) {
        this.reader();
        this.bfReader.setResolution(Math.abs(resolutionLevel - (this.getResolutionLevels() - 1)));
    }
}

