/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.io.InputStreamReader;
import java.io.Reader;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import ome.formats.importer.util.HtmlMessengerException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class HtmlMessenger {
    static final String PROXY_HOST = "http.proxyHost";
    static final String PROXY_PORT = "http.proxyPort";
    static final int CONN_TIMEOUT = 10000;
    private HttpPost request;
    private boolean secure;

    private SSLConnectionSocketFactory createSSLConnection() throws HtmlMessengerException {
        SSLContext sslcontext = SSLContexts.createSystemDefault();
        X509TrustManager trustEverything = new X509TrustManager(){
            private final X509Certificate[] acceptedIssuers = new X509Certificate[0];

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return this.acceptedIssuers;
            }
        };
        TrustManager[] managers = new TrustManager[]{trustEverything};
        try {
            sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, managers, null);
        }
        catch (Exception e) {
            throw new HtmlMessengerException("Cannot create security context", e);
        }
        return new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    private CloseableHttpClient getCommunicationLink(boolean secure) throws HtmlMessengerException {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setCookieSpec("best-match").setExpectContinueEnabled(true).setStaleConnectionCheckEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic"));
        builder.setConnectTimeout(10000);
        String proxyHost = System.getProperty(PROXY_HOST);
        String proxyPort = System.getProperty(PROXY_PORT);
        if (StringUtils.isNotBlank((String)proxyHost) && StringUtils.isNotBlank((String)proxyPort)) {
            builder.setProxy(new HttpHost(proxyHost, Integer.parseInt(proxyPort)));
        }
        HttpClientBuilder httpBuilder = HttpClients.custom();
        httpBuilder.setDefaultRequestConfig(builder.build());
        if (secure) {
            httpBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.createSSLConnection());
        }
        return httpBuilder.build();
    }

    public HtmlMessenger(String url, Map<String, String> postList) throws HtmlMessengerException {
        try {
            if (StringUtils.isBlank((String)url)) {
                throw new HtmlMessengerException("No URL specified.");
            }
            this.request = new HttpPost(url);
            this.request.addHeader("Accept", "text/plain");
            this.request.addHeader("Content-type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> p = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : postList.entrySet()) {
                p.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            this.request.setEntity((HttpEntity)new UrlEncodedFormEntity(p));
            this.secure = url.toLowerCase().startsWith("https");
        }
        catch (Exception e) {
            throw new HtmlMessengerException("Error creating post parameters", e);
        }
    }

    public CloseableHttpClient getCommunicationLink(String url) throws HtmlMessengerException {
        if (StringUtils.isBlank((String)url)) {
            throw new HtmlMessengerException("No URL specified.");
        }
        return this.getCommunicationLink(url.toLowerCase().startsWith("https"));
    }

    public String executePost() throws HtmlMessengerException {
        String serverReply = "";
        Reader reader = null;
        CloseableHttpClient client2 = null;
        try {
            client2 = this.getCommunicationLink(this.secure);
            CloseableHttpResponse response = client2.execute((HttpUriRequest)this.request);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                int n;
                reader = new InputStreamReader(entity.getContent());
                char[] buf = new char[32678];
                StringBuilder str = new StringBuilder();
                while ((n = reader.read(buf)) != -1) {
                    str.append(buf, 0, n);
                }
                serverReply = str.toString();
            }
        }
        catch (Exception e) {
            throw new HtmlMessengerException("Cannot Connect", e);
        }
        finally {
            if (client2 != null) {
                try {
                    client2.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return serverReply;
    }
}

