/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import Ice.UserException;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import ome.api.IQuery;
import ome.api.IUpdate;
import ome.conditions.ApiUsageException;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.roi.Mask;
import ome.model.roi.Roi;
import ome.parameters.Filter;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.roi.GeomTool;
import ome.services.throttling.Adapter;
import ome.services.util.Executor;
import ome.system.ServiceFactory;
import ome.tools.hibernate.QueryBuilder;
import ome.util.SqlAction;
import omero.ServerError;
import omero.api.AMD_IRoi_findByImage;
import omero.api.AMD_IRoi_findByPlane;
import omero.api.AMD_IRoi_findByRoi;
import omero.api.AMD_IRoi_getMeasuredRois;
import omero.api.AMD_IRoi_getMeasuredRoisMap;
import omero.api.AMD_IRoi_getPoints;
import omero.api.AMD_IRoi_getRoiMeasurements;
import omero.api.AMD_IRoi_getRoiStats;
import omero.api.AMD_IRoi_getShapeStats;
import omero.api.AMD_IRoi_getShapeStatsList;
import omero.api.AMD_IRoi_getShapeStatsRestricted;
import omero.api.AMD_IRoi_getTable;
import omero.api.AMD_IRoi_uploadMask;
import omero.api.RoiOptions;
import omero.api.RoiResult;
import omero.api._IRoiOperations;
import omero.model.OriginalFileI;
import omero.model.Shape;
import omero.util.IceMapper;
import org.apache.commons.collections.map.MultiValueMap;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

public class RoiI
extends AbstractAmdServant
implements _IRoiOperations,
ServiceFactoryAware,
BlitzOnly {
    protected ServiceFactoryI factory;
    protected final GeomTool geomTool;
    protected final SqlAction sql;

    public RoiI(BlitzExecutor be, GeomTool geomTool, SqlAction sql) {
        super(null, be);
        this.geomTool = geomTool;
        this.sql = sql;
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) {
        this.factory = sf;
    }

    @Override
    public void findByImage_async(AMD_IRoi_findByImage __cb, final long imageId, final RoiOptions opts, Current __current) throws ServerError {
        RoiResultMapper mapper = new RoiResultMapper(opts);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "findByImage", new Object[]{imageId, opts}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                Filter f = RoiI.filter(opts);
                QueryBuilder qb = new QueryBuilder();
                qb.select("distinct r").from("Roi", "r");
                qb.join("r.image", "i", false, false);
                qb.join("r.shapes", "shapes", false, true);
                qb.join("r.folderLinks", "folderLinks", true, true);
                qb.join("folderLinks.parent", "folder", true, true);
                qb.where();
                qb.and("i.id = :id");
                qb.filter("r", f);
                qb.filterNow();
                qb.order("r.id", true);
                qb.param("id", (Object)imageId);
                return qb.queryWithoutFilter(session).list();
            }
        }));
    }

    @Override
    public void findByRoi_async(AMD_IRoi_findByRoi __cb, final long roiId, final RoiOptions opts, Current __current) throws ServerError {
        RoiResultMapper mapper = new RoiResultMapper(opts);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "findByRoi", new Object[]{roiId}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                RoiQueryBuilder qb = new RoiQueryBuilder(Arrays.asList(roiId), opts);
                return qb.query(session).list();
            }
        }));
    }

    @Override
    public void findByPlane_async(AMD_IRoi_findByPlane __cb, final long imageId, final int z, final int t, final RoiOptions opts, Current __current) throws ServerError {
        RoiResultMapper mapper = new RoiResultMapper(opts);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "findByPlane", new Object[]{imageId, z, t}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                Filter f = RoiI.filter(opts);
                QueryBuilder qb = new QueryBuilder();
                qb.select("distinct r").from("Roi", "r");
                qb.join("r.shapes", "s", false, true);
                qb.join("r.folderLinks", "folderLinks", true, true);
                qb.join("folderLinks.parent", "folder", true, true);
                qb.join("r.image", "i", false, false);
                qb.where();
                qb.and("i.id = :id");
                qb.and(" ( s.theZ is null or s.theZ = :z ) ");
                qb.and(" ( s.theT is null or s.theT = :t ) ");
                qb.filter("r", f);
                qb.filterNow();
                qb.order("r.id", true);
                qb.param("id", (Object)imageId);
                qb.param("z", (Object)z);
                qb.param("t", (Object)t);
                return qb.queryWithoutFilter(session).list();
            }
        }));
    }

    @Override
    public void getPoints_async(AMD_IRoi_getPoints __cb, final long shapeId, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "getPoints", new Object[]{shapeId}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return RoiI.this.geomTool.getPoints(shapeId, session);
            }
        }));
    }

    @Override
    public void getShapeStats_async(AMD_IRoi_getShapeStats __cb, final long shapeId, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "getShapeStats", new Object[]{shapeId}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return RoiI.this.geomTool.getStats(Arrays.asList(new Long[]{Long.valueOf((long)shapeId)})).perShape[0];
            }
        }));
    }

    @Override
    public void getShapeStatsList_async(AMD_IRoi_getShapeStatsList __cb, final List<Long> shapeIdList, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "getShapeStatsList", new Object[]{shapeIdList}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return Arrays.asList(RoiI.this.geomTool.getStats((List<Long>)shapeIdList).perShape);
            }
        }));
    }

    @Override
    public void getRoiStats_async(AMD_IRoi_getRoiStats __cb, final long roiId, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "getRoiStats", new Object[]{roiId}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                List shapesInRoi = RoiI.this.sql.getShapeIds(roiId);
                return RoiI.this.geomTool.getStats(shapesInRoi);
            }
        }));
    }

    @Override
    public void getShapeStatsRestricted_async(AMD_IRoi_getShapeStatsRestricted __cb, final List<Long> shapeIdList, final int zForUnattached, final int tForUnattached, final int[] channels, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "getShapeStatsRestricted", new Object[]{shapeIdList, zForUnattached, tForUnattached, channels}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return RoiI.this.geomTool.getStatsRestricted(shapeIdList, zForUnattached, tForUnattached, channels);
            }
        }));
    }

    @Override
    public void getRoiMeasurements_async(AMD_IRoi_getRoiMeasurements __cb, final long imageId, final RoiOptions opts, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.FILTERABLE_COLLECTION);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "getRoiMeasurements", new Object[]{imageId}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                QueryBuilder qb = new QueryBuilder();
                qb.select("distinct fa");
                qb.from("Image", "i");
                qb.append(", Roi roi ");
                qb.join("roi.annotationLinks", "rlinks", false, false);
                qb.join("rlinks.child", "rfa", false, false);
                qb.join("i.wellSamples", "ws", false, false);
                qb.join("ws.well", "well", false, false);
                qb.join("well.plate", "plate", false, false);
                qb.join("plate.annotationLinks", "links", false, false);
                qb.join("links.child", "fa", false, false);
                qb.where();
                qb.and("fa.ns = 'openmicroscopy.org/omero/measurement'");
                qb.and("rfa.id = fa.id");
                qb.and("i.id = :id");
                qb.and("i.id = roi.image");
                qb.param("id", (Object)imageId);
                qb.filter("fa", RoiI.filter(opts));
                return qb.query(session).list();
            }
        }));
    }

    protected List<Roi> loadMeasuredRois(Session session, long imageId, long annotationId) {
        Query q = session.createQuery("select distinct r from Roi r join r.image i join fetch r.shapes join i.wellSamples ws join ws.well well join well.plate plate join plate.annotationLinks links join links.child a where a.id = :aid and i.id = :iid order by r.id");
        q.setParameter("iid", (Object)imageId);
        q.setParameter("aid", (Object)annotationId);
        return q.list();
    }

    @Override
    public void getMeasuredRoisMap_async(AMD_IRoi_getMeasuredRoisMap __cb, final long imageId, final List<Long> annotationIds, RoiOptions opts, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(new RoiResultMapReturnMapper(opts));
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "getMeasuredRoisMap", new Object[]{imageId, annotationIds}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                if (annotationIds == null) {
                    return null;
                }
                HashMap<Long, List<Roi>> rv = new HashMap<Long, List<Roi>>();
                for (Long annotationId : annotationIds) {
                    rv.put(annotationId, RoiI.this.loadMeasuredRois(session, imageId, annotationId));
                }
                return rv;
            }
        }));
    }

    @Override
    public void getMeasuredRois_async(AMD_IRoi_getMeasuredRois __cb, final long imageId, final long annotationId, RoiOptions opts, Current __current) throws ServerError {
        RoiResultMapper mapper = new RoiResultMapper(opts);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "getMeasuredRois", new Object[]{imageId, annotationId}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return RoiI.this.loadMeasuredRois(session, imageId, annotationId);
            }
        }));
    }

    @Override
    public void getTable_async(AMD_IRoi_getTable __cb, final long annotationId, final Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "getTable", new Object[]{annotationId}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                QueryBuilder qb = new QueryBuilder();
                qb.select("f");
                qb.from("FileAnnotation", "fa");
                qb.join("fa.file", "f", false, false);
                qb.where();
                qb.and("fa.id = :id");
                qb.param("id", (Object)annotationId);
                OriginalFile file = (OriginalFile)qb.query(session).uniqueResult();
                if (file == null) {
                    throw new ApiUsageException("No such file annotation: " + annotationId);
                }
                return file.getId();
            }
        }){

            @Override
            protected Object postProcess(Object rv) throws ServerError {
                return RoiI.this.factory.sharedResources(__current).openTable(new OriginalFileI((Long)rv, false));
            }
        });
    }

    private <T extends IObject> T safeReverse(Object o, IceMapper mapper) {
        try {
            return (T)((IObject)mapper.reverse(o));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to safely reverse: " + o);
        }
    }

    @Override
    public void uploadMask_async(final AMD_IRoi_uploadMask __cb, final long imageId, final int z, final int t, final byte[] bytes, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, new Executor.SimpleWork(this, "uploadMask", new Object[]{bytes}){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                IUpdate update = sf.getUpdateService();
                ByteArrayInputStream s = new ByteArrayInputStream(bytes);
                IQuery query = sf.getQueryService();
                IObject o = query.findByQuery("from Image as i left outer join fetch i.pixels as p where i.id = " + imageId, null);
                try {
                    MaskClass mask;
                    Image image = (Image)o;
                    BufferedImage inputImage = ImageIO.read(s);
                    HashMap<Integer, MaskClass> map = new HashMap<Integer, MaskClass>();
                    for (int x = 0; x < inputImage.getWidth(); ++x) {
                        for (int y = 0; y < inputImage.getHeight(); ++y) {
                            int value = inputImage.getRGB(x, y);
                            if (value == Color.black.getRGB()) continue;
                            if (!map.containsKey(value)) {
                                mask = new MaskClass(value);
                                map.put(value, mask);
                            } else {
                                mask = (MaskClass)map.get(value);
                            }
                            mask.add(new Point(x, y));
                        }
                    }
                    Iterator maskIterator = map.keySet().iterator();
                    while (maskIterator.hasNext()) {
                        int colour = (Integer)maskIterator.next();
                        mask = (MaskClass)map.get(colour);
                        Roi roi = new Roi();
                        roi.setImage(image);
                        Mask toSaveMask = mask.asMaskI(z, t);
                        roi.addShape((ome.model.roi.Shape)toSaveMask);
                        Roi roi2 = (Roi)update.saveAndReturnObject((IObject)roi);
                    }
                    return null;
                }
                catch (Exception e) {
                    __cb.ice_exception(e);
                    return null;
                }
            }
        }));
    }

    private static Filter filter(RoiOptions opts) {
        Filter f = new Filter();
        if (opts != null) {
            if (opts.userId != null) {
                f.owner(opts.userId.getValue());
            }
            if (opts.groupId != null) {
                f.group(opts.groupId.getValue());
            }
            Integer offset = null;
            Integer limit = null;
            if (opts.offset != null) {
                offset = opts.offset.getValue();
            }
            if (opts.limit != null) {
                limit = opts.limit.getValue();
            }
            if (offset != null || limit != null) {
                f.page(offset, limit);
            }
        }
        return f;
    }

    private class NamespaceKeywords {
        public String[] namespaces;
        public String[][] keywords;

        private NamespaceKeywords() {
        }
    }

    public static class RoiResultMapReturnMapper
    implements IceMapper.ReturnMapping {
        private final RoiOptions opts;

        public RoiResultMapReturnMapper(RoiOptions opts) {
            this.opts = opts;
        }

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            HashMap<Long, RoiResult> rv = new HashMap<Long, RoiResult>();
            Map iv = (Map)value;
            RoiResultMapper m = new RoiResultMapper(this.opts);
            for (Map.Entry entry : iv.entrySet()) {
                rv.put((Long)entry.getKey(), (RoiResult)((Object)m.mapReturnValue(entry.getValue())));
            }
            return rv;
        }
    }

    public static class RoiResultReturnMapper
    implements IceMapper.ReturnMapping {
        private final RoiOptions opts;

        public RoiResultReturnMapper(RoiOptions opts) {
            this.opts = opts;
        }

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            List rois;
            RoiResult result = new RoiResult();
            result.opts = this.opts;
            if (value == null) {
                result.rois = Collections.emptyList();
                result.byZ = Collections.emptyMap();
                result.byT = Collections.emptyMap();
                return result;
            }
            result.rois = rois = (List)IceMapper.FILTERABLE_COLLECTION.mapReturnValue(mapper, value);
            MultiValueMap byZ = new MultiValueMap();
            MultiValueMap byT = new MultiValueMap();
            for (omero.model.Roi roi : rois) {
                omero.model.RoiI roii = (omero.model.RoiI)roi;
                Iterator it = roii.iterateShapes();
                while (it.hasNext()) {
                    Shape shape = (Shape)it.next();
                    if (shape == null) continue;
                    if (shape.getTheT() != null) {
                        byT.put((Object)shape.getTheT().getValue(), (Object)shape);
                    } else {
                        byT.put((Object)-1, (Object)shape);
                    }
                    if (shape.getTheZ() != null) {
                        byZ.put((Object)shape.getTheZ().getValue(), (Object)shape);
                        continue;
                    }
                    byZ.put((Object)-1, (Object)shape);
                }
                result.byZ = byZ;
                result.byT = byT;
            }
            return result;
        }
    }

    public static class RoiResultMapper
    extends IceMapper {
        public RoiResultMapper(RoiOptions opts) {
            super(new RoiResultReturnMapper(opts));
        }
    }

    private static class RoiQueryBuilder
    extends QueryBuilder {
        final RoiOptions opts;

        RoiQueryBuilder(List<Long> roiIds, RoiOptions opts) {
            this.opts = opts;
            this.paramList("ids", roiIds);
            this.select("distinct r");
            this.from("Roi", "r");
            this.join("r.shapes", "s", false, true);
            this.where();
        }

        @Override
        public Query query(Session session) {
            this.and("r.id in (:ids)");
            Filter f = RoiI.filter(this.opts);
            this.filter("r", f);
            this.filterNow();
            this.append("order by r.id");
            return super.queryWithoutFilter(session);
        }
    }

    class MaskClass {
        Set<Point> points = new HashSet<Point>();
        int colour;
        Point min;
        Point max;
        int width;
        int height;

        MaskClass(int value) {
            this.colour = value;
        }

        public Color getColour() {
            return new Color(this.colour);
        }

        public byte[] asBytes() throws IOException {
            byte[] data = new byte[(int)Math.ceil((double)this.width * (double)this.height / 8.0)];
            int offset = 0;
            for (int y = this.min.y; y < this.max.y + 1; ++y) {
                for (int x = this.min.x; x < this.max.x + 1; ++x) {
                    if (this.points.contains(new Point(x, y))) {
                        this.setBit(data, offset, 1);
                    } else {
                        this.setBit(data, offset, 0);
                    }
                    ++offset;
                }
            }
            return data;
        }

        public void add(Point p) {
            if (this.points.size() == 0) {
                this.min = new Point(p);
                this.max = new Point(p);
            } else {
                this.min.x = Math.min(p.x, this.min.x);
                this.min.y = Math.min(p.y, this.min.y);
                this.max.x = Math.max(p.x, this.max.x);
                this.max.y = Math.max(p.y, this.max.y);
            }
            this.width = this.max.x - this.min.x + 1;
            this.height = this.max.y - this.min.y + 1;
            this.points.add(p);
        }

        public Mask asMaskI(int z, int t) throws IOException {
            Mask mask = new Mask();
            mask.setX(Double.valueOf(this.min.x));
            mask.setY(Double.valueOf(this.min.y));
            mask.setWidth(Double.valueOf(this.width));
            mask.setHeight(Double.valueOf(this.height));
            mask.setLocked(Boolean.valueOf(true));
            mask.setTheT(Integer.valueOf(t));
            mask.setTheZ(Integer.valueOf(z));
            byte[] theseBytes = this.asBytes();
            mask.setBytes(theseBytes);
            return mask;
        }

        private void setBit(byte[] data, int bit, int val) {
            int bytePosition = bit / 8;
            int bitPosition = 7 - bit % 8;
            data[bytePosition] = (byte)((byte)(data[bytePosition] & ~((byte)(1 << bitPosition))) | (byte)(val << bitPosition));
        }

        private byte getBit(byte[] data, int bit) {
            int bytePosition = bit / 8;
            int bitPosition = 7 - bit % 8;
            return (byte)(data[bytePosition] & 1 << bitPosition) != 0 ? (byte)1 : 0;
        }
    }
}

