/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ome.model.IObject;
import ome.services.graphs.GraphPathBean;
import omero.cmd.graphs.ChildOption;
import org.apache.commons.collections.CollectionUtils;

public class ChildOptionI
extends ChildOption {
    private final GraphPathBean graphPathBean;
    private final ImmutableSet<String> defaultExcludeNs;
    private Function<Class<? extends IObject>, Boolean> isIncludeType = null;
    private Predicate<String> isTargetNamespace = null;

    public ChildOptionI(GraphPathBean graphPathBean, ImmutableSet<String> defaultExcludeNs) {
        this.graphPathBean = graphPathBean;
        this.defaultExcludeNs = defaultExcludeNs;
    }

    public ChildOptionI(ChildOptionI original) {
        this.graphPathBean = original.graphPathBean;
        this.defaultExcludeNs = original.defaultExcludeNs;
        this.includeType = original.includeType == null ? null : new ArrayList(original.includeType);
        this.excludeType = original.excludeType == null ? null : new ArrayList(original.excludeType);
        this.includeNs = original.includeNs == null ? null : new ArrayList(original.includeNs);
        this.excludeNs = original.excludeNs == null ? null : new ArrayList(original.excludeNs);
        this.isIncludeType = original.isIncludeType;
        this.isTargetNamespace = original.isTargetNamespace;
    }

    public void init() {
        Function<String, Class<? extends IObject>> getClassFromName = new Function<String, Class<? extends IObject>>(){

            @Override
            public Class<? extends IObject> apply(String className) {
                int lastDot = className.lastIndexOf(46);
                if (lastDot > 0) {
                    className = className.substring(lastDot + 1);
                }
                return ChildOptionI.this.graphPathBean.getClassForSimpleName(className);
            }
        };
        final ImmutableSet typeInclusions = CollectionUtils.isEmpty((Collection)this.includeType) ? ImmutableSet.of() : ImmutableSet.copyOf((Collection)this.includeType.stream().map(getClassFromName).collect(Collectors.toSet()));
        final ImmutableSet typeExclusions = CollectionUtils.isEmpty((Collection)this.excludeType) ? ImmutableSet.of() : ImmutableSet.copyOf((Collection)this.excludeType.stream().map(getClassFromName).collect(Collectors.toSet()));
        if (typeInclusions.isEmpty() && typeExclusions.isEmpty()) {
            throw new IllegalArgumentException("child option must include or exclude some type");
        }
        this.isIncludeType = new Function<Class<? extends IObject>, Boolean>(){

            @Override
            public Boolean apply(Class<? extends IObject> objectClass) {
                for (Class typeInclusion : typeInclusions) {
                    if (!typeInclusion.isAssignableFrom(objectClass)) continue;
                    return Boolean.TRUE;
                }
                for (Class typeExclusion : typeExclusions) {
                    if (!typeExclusion.isAssignableFrom(objectClass)) continue;
                    return Boolean.FALSE;
                }
                return null;
            }
        };
        if (CollectionUtils.isEmpty((Collection)this.includeNs) && CollectionUtils.isEmpty((Collection)this.excludeNs)) {
            this.excludeNs = new ArrayList<String>((Collection<String>)this.defaultExcludeNs);
        }
        if (CollectionUtils.isEmpty((Collection)this.includeNs)) {
            if (CollectionUtils.isEmpty((Collection)this.excludeNs)) {
                this.isTargetNamespace = x -> true;
            } else {
                final ImmutableSet nsExclusions = ImmutableSet.copyOf((Collection)this.excludeNs);
                this.isTargetNamespace = new Predicate<String>(){

                    @Override
                    public boolean test(String namespace) {
                        return !nsExclusions.contains((Object)namespace);
                    }
                };
            }
        } else if (CollectionUtils.isEmpty((Collection)this.excludeNs)) {
            final ImmutableSet nsInclusions = ImmutableSet.copyOf((Collection)this.includeNs);
            this.isTargetNamespace = new Predicate<String>(){

                @Override
                public boolean test(String namespace) {
                    return nsInclusions.contains((Object)namespace);
                }
            };
        } else {
            throw new IllegalArgumentException("child option may not both include and exclude namespace");
        }
    }

    public Boolean isIncludeType(Class<? extends IObject> objectClass) {
        return this.isIncludeType.apply(objectClass);
    }

    public boolean isTargetNamespace(String namespace) {
        return this.isTargetNamespace.test(namespace);
    }

    public static List<ChildOptionI> castChildOptions(Collection<ChildOption> childOptions) {
        if (childOptions == null) {
            return null;
        }
        ArrayList<ChildOptionI> childOptionsI = new ArrayList<ChildOptionI>(childOptions.size());
        for (ChildOption childOption : childOptions) {
            childOptionsI.add((ChildOptionI)childOption);
        }
        return childOptionsI;
    }
}

