/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.Timestamp;

public class OpenlabRawReader
extends FormatReader {
    public static final String OPENLAB_RAW_MAGIC_STRING = "OLRW";
    private static final int HEADER_SIZE = 288;
    protected int[] offsets;
    private int bytesPerPixel;

    public OpenlabRawReader() {
        super("Openlab RAW", "raw");
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = OPENLAB_RAW_MAGIC_STRING.length();
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)blockLen, (boolean)false)) {
            return false;
        }
        return stream.readString(blockLen).startsWith(OPENLAB_RAW_MAGIC_STRING);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek(this.offsets[no / this.getSizeC()] + 288);
        this.readPlane(this.in, x, y, w, h, buf);
        if (FormatTools.getBytesPerPixel((int)this.getPixelType()) == 1) {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(255 - buf[i]);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.bytesPerPixel = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Verifying Openlab RAW format");
        if (!this.in.readString(4).equals(OPENLAB_RAW_MAGIC_STRING)) {
            throw new FormatException("Openlab RAW magic string not found.");
        }
        LOGGER.info("Populating metadata");
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        int version = this.in.readInt();
        m.imageCount = this.in.readInt();
        this.offsets = new int[this.getImageCount()];
        this.offsets[0] = 12;
        this.in.skipBytes(8);
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        this.in.skipBytes(1);
        m.sizeC = this.in.read();
        this.bytesPerPixel = this.in.read();
        this.in.skipBytes(1);
        long stampMs = this.in.readLong();
        String stamp = null;
        if (stampMs > 0L) {
            stampMs /= 1000000L;
            stampMs = (long)((double)stampMs - 2.1143592E9);
            stamp = DateTools.convertDate(stampMs, 0);
        }
        this.in.skipBytes(4);
        int len = this.in.read() & 0xFF;
        String imageName = this.in.readString(len - 1).trim();
        m.sizeC = this.getSizeC() <= 1 ? 1 : 3;
        int plane = this.getSizeX() * this.getSizeY() * this.bytesPerPixel;
        for (int i = 1; i < this.getImageCount(); ++i) {
            this.offsets[i] = this.offsets[i - 1] + 288 + plane;
        }
        m.sizeZ = this.getImageCount();
        m.sizeT = 1;
        m.rgb = this.getSizeC() > 1;
        m.dimensionOrder = this.isRGB() ? "XYCZT" : "XYZTC";
        m.interleaved = false;
        m.littleEndian = false;
        m.metadataComplete = true;
        m.indexed = false;
        m.falseColor = false;
        switch (this.bytesPerPixel) {
            case 1: 
            case 3: {
                m.pixelType = 1;
                break;
            }
            case 2: {
                m.pixelType = 3;
                break;
            }
            default: {
                m.pixelType = 6;
            }
        }
        this.addGlobalMeta("Width", this.getSizeX());
        this.addGlobalMeta("Height", this.getSizeY());
        this.addGlobalMeta("Bytes per pixel", this.bytesPerPixel);
        this.addGlobalMeta("Image name", imageName);
        this.addGlobalMeta("Timestamp", stamp);
        this.addGlobalMeta("Version", version);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        if (stamp != null) {
            store.setImageAcquisitionDate(new Timestamp(stamp), 0);
        }
        store.setImageName(imageName, 0);
    }
}

