#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Copyright (C) 2011-2014 University of Dundee & Open Microscopy Environment.
# All rights reserved.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import warnings
from django import forms
from django.utils.encoding import smart_str

from django.forms.utils import ErrorDict, ValidationError
from django.forms.fields import FileField, CharField

DEPRECATION_MESSAGE = (
    "This form is deprecated as of OMERO.web 5.21.0. Use Django's" "forms.Form instead."
)


class NonASCIIForm(forms.Form):
    def __init__(self, *args, **kwargs):
        warnings.warn(DEPRECATION_MESSAGE, DeprecationWarning)
        super(NonASCIIForm, self).__init__(*args, **kwargs)

    def full_clean(self):
        """
        Cleans all of self.data and populates self._errors and
        self.cleaned_data.
        """
        self._errors = ErrorDict()
        if not self.is_bound:  # Stop further processing.
            return
        self.cleaned_data = {}
        # If the form is permitted to be empty, and none of the form data has
        # changed from the initial data, short circuit any validation.
        if self.empty_permitted and not self.has_changed():
            return
        for name, field in self.fields.items():
            # value_from_datadict() gets the data from the data dictionaries.
            # Each widget type knows how to retrieve its own data, because
            # some widgets split data over several HTML fields.
            value = field.widget.value_from_datadict(
                self.data, self.files, self.add_prefix(name)
            )
            try:
                if isinstance(field, FileField):
                    initial = self.initial.get(name, field.initial)
                    value = field.clean(value, initial)
                elif isinstance(field, CharField):
                    if value is not None and isinstance(value, str) and len(value) > 0:
                        value = str(
                            smart_str(value)
                        )  # TODO: This is probably a noop now
                    else:
                        value = field.clean(value)
                else:
                    value = field.clean(value)
                self.cleaned_data[name] = value
                if hasattr(self, "clean_%s" % name):
                    value = getattr(self, "clean_%s" % name)()
                    self.cleaned_data[name] = value
            except ValidationError as e:
                self._errors[name] = self.error_class(e.messages)
                if name in self.cleaned_data:
                    del self.cleaned_data[name]
        try:
            self.cleaned_data = self.clean()
        except ValidationError as e:
            self._errors[forms.Form.NON_FIELD_ERRORS] = self.error_class(e.messages)
        if self._errors:
            delattr(self, "cleaned_data")
