/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.store;

import dev.zarr.zarrjava.store.Store;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3Store
implements Store,
Store.ListableStore {
    @Nonnull
    private final S3Client s3client;
    @Nonnull
    private final String bucketName;
    @Nullable
    private final String prefix;

    public S3Store(@Nonnull S3Client s3client, @Nonnull String bucketName, @Nullable String prefix) {
        this.s3client = s3client;
        this.bucketName = bucketName;
        this.prefix = prefix;
    }

    String resolveKeys(String[] keys) {
        if (this.prefix == null) {
            return String.join((CharSequence)"/", keys);
        }
        if (keys == null || keys.length == 0) {
            return this.prefix;
        }
        return this.prefix + "/" + String.join((CharSequence)"/", keys);
    }

    @Nullable
    ByteBuffer get(GetObjectRequest getObjectRequest) {
        ByteBuffer byteBuffer;
        block8: {
            ResponseInputStream inputStream = this.s3client.getObject(getObjectRequest);
            try {
                byteBuffer = Utils.asByteBuffer((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            inputStream.close();
        }
        return byteBuffer;
    }

    @Override
    public boolean exists(String[] keys) {
        HeadObjectRequest req = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucketName).key(this.resolveKeys(keys)).build();
        try {
            return this.s3client.headObject(req).sdkHttpResponse().statusCode() == 200;
        }
        catch (NoSuchKeyException e) {
            return false;
        }
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys) {
        return this.get((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(this.resolveKeys(keys)).build());
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys, long start) {
        GetObjectRequest req = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(this.resolveKeys(keys)).range(String.valueOf(start)).build();
        return this.get(req);
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys, long start, long end) {
        GetObjectRequest req = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(this.resolveKeys(keys)).range(start + "-" + end).build();
        return this.get(req);
    }

    @Override
    public void set(String[] keys, ByteBuffer bytes) {
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(Utils.toArray(bytes));){
            this.s3client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(this.resolveKeys(keys)).build(), RequestBody.fromContentProvider(() -> byteStream, (String)"application/octet-stream"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(String[] keys) {
        this.s3client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(this.resolveKeys(keys)).build());
    }

    @Override
    public Stream<String> list(String[] keys) {
        String fullKey = this.resolveKeys(keys);
        ListObjectsRequest req = (ListObjectsRequest)ListObjectsRequest.builder().bucket(this.bucketName).prefix(fullKey).build();
        ListObjectsResponse res = this.s3client.listObjects(req);
        return res.contents().stream().map(p -> p.key().substring(fullKey.length() + 1));
    }

    @Override
    @Nonnull
    public StoreHandle resolve(String ... keys) {
        return new StoreHandle(this, keys);
    }

    public String toString() {
        return "s3://" + this.bucketName + "/" + this.prefix;
    }
}

