/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.Attributes;
import dev.zarr.zarrjava.store.FilesystemStore;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.Utils;
import dev.zarr.zarrjava.v2.Array;
import dev.zarr.zarrjava.v2.ArrayMetadata;
import dev.zarr.zarrjava.v2.ArrayMetadataBuilder;
import dev.zarr.zarrjava.v2.GroupMetadata;
import dev.zarr.zarrjava.v2.Node;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Group
extends dev.zarr.zarrjava.core.Group
implements Node {
    public GroupMetadata metadata;

    protected Group(@Nonnull StoreHandle storeHandle, @Nonnull GroupMetadata groupMetadata) throws IOException {
        super(storeHandle);
        this.metadata = groupMetadata;
    }

    public static Group open(@Nonnull StoreHandle storeHandle) throws IOException {
        ObjectMapper mapper = Node.makeObjectMapper();
        GroupMetadata metadata = (GroupMetadata)mapper.readValue(Utils.toArray(storeHandle.resolve(".zgroup").readNonNull()), GroupMetadata.class);
        if (storeHandle.resolve(".zattrs").exists()) {
            metadata.attributes = (Attributes)mapper.readValue(Utils.toArray(storeHandle.resolve(".zattrs").readNonNull()), Attributes.class);
        }
        return new Group(storeHandle, metadata);
    }

    public static Group open(Path path) throws IOException {
        return Group.open(new StoreHandle(new FilesystemStore(path), new String[0]));
    }

    public static Group open(String path) throws IOException {
        return Group.open(Paths.get(path, new String[0]));
    }

    public static Group create(@Nonnull StoreHandle storeHandle, @Nonnull GroupMetadata groupMetadata) throws IOException {
        ObjectWriter objectWriter = Node.makeObjectWriter();
        ByteBuffer metadataBytes = ByteBuffer.wrap(objectWriter.writeValueAsBytes((Object)groupMetadata));
        storeHandle.resolve(".zgroup").set(metadataBytes);
        if (groupMetadata.attributes != null) {
            StoreHandle attrsHandle = storeHandle.resolve(".zattrs");
            ByteBuffer attrsBytes = ByteBuffer.wrap(objectWriter.writeValueAsBytes((Object)groupMetadata.attributes));
            attrsHandle.set(attrsBytes);
        }
        return new Group(storeHandle, groupMetadata);
    }

    public static Group create(@Nonnull StoreHandle storeHandle) throws IOException, ZarrException {
        return Group.create(storeHandle, new GroupMetadata());
    }

    public static Group create(@Nonnull StoreHandle storeHandle, Attributes attributes) throws IOException, ZarrException {
        return Group.create(storeHandle, new GroupMetadata(attributes));
    }

    public static Group create(Path path) throws IOException, ZarrException {
        return Group.create(new StoreHandle(new FilesystemStore(path), new String[0]));
    }

    public static Group create(Path path, Attributes attributes) throws IOException, ZarrException {
        return Group.create(new StoreHandle(new FilesystemStore(path), new String[0]), attributes);
    }

    public static Group create(String path) throws IOException, ZarrException {
        return Group.create(Paths.get(path, new String[0]));
    }

    public static Group create(String path, Attributes attributes) throws IOException, ZarrException {
        return Group.create(Paths.get(path, new String[0]), attributes);
    }

    @Override
    @Nullable
    public Node get(String key) throws ZarrException {
        StoreHandle keyHandle = this.storeHandle.resolve(key);
        try {
            return Node.open(keyHandle);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Group createGroup(String key) throws IOException, ZarrException {
        return Group.create(this.storeHandle.resolve(key));
    }

    public Array createArray(String key, ArrayMetadata arrayMetadata) throws IOException, ZarrException {
        return Array.create(this.storeHandle.resolve(key), arrayMetadata);
    }

    public Array createArray(String key, Function<ArrayMetadataBuilder, ArrayMetadataBuilder> arrayMetadataBuilderMapper) throws IOException, ZarrException {
        return Array.create(this.storeHandle.resolve(key), arrayMetadataBuilderMapper, false);
    }

    public String toString() {
        return String.format("<v2.Group {%s}>", this.storeHandle);
    }

    @Override
    public GroupMetadata metadata() {
        return this.metadata;
    }
}

