/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v3.codec;

import com.scalableminds.bloscjava.Blosc;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.codec.ArrayArrayCodec;
import dev.zarr.zarrjava.core.codec.ArrayBytesCodec;
import dev.zarr.zarrjava.core.codec.BytesBytesCodec;
import dev.zarr.zarrjava.core.codec.core.BytesCodec;
import dev.zarr.zarrjava.v3.DataType;
import dev.zarr.zarrjava.v3.codec.Codec;
import dev.zarr.zarrjava.v3.codec.core.BloscCodec;
import dev.zarr.zarrjava.v3.codec.core.BytesCodec;
import dev.zarr.zarrjava.v3.codec.core.Crc32cCodec;
import dev.zarr.zarrjava.v3.codec.core.GzipCodec;
import dev.zarr.zarrjava.v3.codec.core.ShardingIndexedCodec;
import dev.zarr.zarrjava.v3.codec.core.TransposeCodec;
import dev.zarr.zarrjava.v3.codec.core.ZstdCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class CodecBuilder
extends dev.zarr.zarrjava.core.codec.CodecBuilder {
    protected List<Codec> codecs = new ArrayList<Codec>();

    public CodecBuilder(DataType dataType) {
        super(dataType);
    }

    public CodecBuilder withBlosc(Blosc.Compressor cname, Blosc.Shuffle shuffle, int clevel, int typeSize, int blockSize) {
        try {
            this.codecs.add(new BloscCodec(new BloscCodec.Configuration(cname, shuffle, clevel, typeSize, blockSize)));
        }
        catch (ZarrException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CodecBuilder withBlosc(String cname, String shuffle, int clevel, int blockSize) {
        if (shuffle.equals("shuffle")) {
            shuffle = "byteshuffle";
        }
        return this.withBlosc(Blosc.Compressor.fromString((String)cname), Blosc.Shuffle.fromString((String)shuffle), clevel, this.dataType.getByteCount(), blockSize);
    }

    public CodecBuilder withBlosc(String cname, String shuffle, int clevel) {
        return this.withBlosc(cname, shuffle, clevel, 0);
    }

    public CodecBuilder withBlosc(String cname, int clevel) {
        return this.withBlosc(cname, "noshuffle", clevel);
    }

    public CodecBuilder withBlosc(String cname) {
        return this.withBlosc(cname, 5);
    }

    public CodecBuilder withBlosc() {
        return this.withBlosc("zstd");
    }

    public CodecBuilder withTranspose(int[] order) {
        this.codecs.add(new TransposeCodec(new TransposeCodec.Configuration(order)));
        return this;
    }

    public CodecBuilder withBytes(BytesCodec.Endian endian) {
        if (this.dataType.getByteCount() <= 1) {
            this.codecs.add(new BytesCodec());
        } else {
            this.codecs.add(new BytesCodec(endian));
        }
        return this;
    }

    public CodecBuilder withBytes(String endian) {
        return this.withBytes(BytesCodec.Endian.valueOf(endian));
    }

    public CodecBuilder withBytes() {
        return this.withBytes(BytesCodec.Endian.nativeOrder());
    }

    public CodecBuilder withGzip(int clevel) {
        try {
            this.codecs.add(new GzipCodec(new GzipCodec.Configuration(clevel)));
        }
        catch (ZarrException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CodecBuilder withGzip() {
        return this.withGzip(5);
    }

    public CodecBuilder withZstd(int clevel, boolean checksum) {
        try {
            this.codecs.add(new ZstdCodec(new ZstdCodec.Configuration(clevel, checksum)));
        }
        catch (ZarrException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CodecBuilder withZstd() {
        return this.withZstd(5, true);
    }

    public CodecBuilder withZstd(int clevel) {
        return this.withZstd(clevel, true);
    }

    public CodecBuilder withSharding(int[] chunkShape) {
        try {
            this.codecs.add(new ShardingIndexedCodec(new ShardingIndexedCodec.Configuration(chunkShape, new Codec[]{new BytesCodec(new BytesCodec.Configuration(BytesCodec.Endian.LITTLE))}, new Codec[]{new BytesCodec(new BytesCodec.Configuration(BytesCodec.Endian.LITTLE)), new Crc32cCodec()}, "end")));
        }
        catch (ZarrException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CodecBuilder withSharding(int[] chunkShape, Function<CodecBuilder, CodecBuilder> codecBuilder) {
        return this.withSharding(chunkShape, codecBuilder, "end");
    }

    public CodecBuilder withSharding(int[] chunkShape, Function<CodecBuilder, CodecBuilder> codecBuilder, String indexLocation) {
        CodecBuilder nestedBuilder = new CodecBuilder((DataType)this.dataType);
        try {
            this.codecs.add(new ShardingIndexedCodec(new ShardingIndexedCodec.Configuration(chunkShape, codecBuilder.apply(nestedBuilder).build(), new Codec[]{new BytesCodec(BytesCodec.Endian.LITTLE), new Crc32cCodec()}, indexLocation)));
        }
        catch (ZarrException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CodecBuilder withCrc32c() {
        this.codecs.add(new Crc32cCodec());
        return this;
    }

    private void autoInsertBytesCodec() {
        if (this.codecs.stream().noneMatch(c -> c instanceof ArrayBytesCodec)) {
            Codec[] arrayArrayCodecs = (Codec[])this.codecs.stream().filter(c -> c instanceof ArrayArrayCodec).toArray(Codec[]::new);
            Codec[] bytesBytesCodecs = (Codec[])this.codecs.stream().filter(c -> c instanceof BytesBytesCodec).toArray(Codec[]::new);
            this.codecs = new ArrayList<Codec>();
            Collections.addAll(this.codecs, arrayArrayCodecs);
            this.codecs.add(new BytesCodec(new BytesCodec.Configuration(BytesCodec.Endian.LITTLE)));
            Collections.addAll(this.codecs, bytesBytesCodecs);
        }
    }

    public Codec[] build() {
        this.autoInsertBytesCodec();
        return this.codecs.toArray(new Codec[0]);
    }
}

