/*
 * Decompiled with CFR 0.152.
 */
package com.glencoesoftware.omero.zarr.compat;

import com.glencoesoftware.omero.zarr.compat.ZArray;
import com.glencoesoftware.omero.zarr.compat.ZArrayv3;
import com.glencoesoftware.omero.zarr.compat.ZarrPath;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.v3.Array;
import dev.zarr.zarrjava.v3.Group;
import dev.zarr.zarrjava.v3.Node;
import java.io.IOException;
import java.util.Map;

class ZarrPathv3
implements ZarrPath {
    private StoreHandle path;
    private Group group;
    private String key = null;

    public ZarrPathv3(StoreHandle path) {
        try {
            this.path = path;
            this.group = Group.open((StoreHandle)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ZarrPathv3(ZarrPathv3 parent, String resolvePath) {
        this.path = parent.path.resolve(new String[]{resolvePath});
        try {
            this.group = Group.open((StoreHandle)this.path);
        }
        catch (IOException e) {
            this.group = parent.group;
            this.key = resolvePath;
        }
    }

    @Override
    public ZarrPath resolve(String resolvePath) {
        return new ZarrPathv3(this, resolvePath);
    }

    @Override
    public Map<String, Object> getMetadata() throws IOException {
        return this.group.metadata.attributes;
    }

    @Override
    public ZArray getArray() throws IOException {
        Array array;
        try {
            Node node = this.group.get(this.key);
            array = (Array)node;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return new ZArrayv3(array);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ZarrPathv3 that = (ZarrPathv3)obj;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.key == null ? "(Group) " + this.path.toString() : "(Array) " + this.path.toString() + ":" + this.key;
    }
}

