/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.core;

import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.AbstractNode;
import dev.zarr.zarrjava.core.ArrayMetadata;
import dev.zarr.zarrjava.core.codec.CodecPipeline;
import dev.zarr.zarrjava.store.FilesystemStore;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.IndexingUtils;
import dev.zarr.zarrjava.utils.MultiArrayUtils;
import dev.zarr.zarrjava.utils.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;

public abstract class Array
extends AbstractNode {
    protected CodecPipeline codecPipeline;

    public abstract ArrayMetadata metadata();

    protected Array(StoreHandle storeHandle) throws ZarrException {
        super(storeHandle);
    }

    public static Array open(StoreHandle storeHandle) throws IOException, ZarrException {
        boolean isV3 = storeHandle.resolve("zarr.json").exists();
        boolean isV2 = storeHandle.resolve(".zarray").exists();
        if (isV3 && isV2) {
            throw new ZarrException("Both Zarr v2 and v3 arrays found at the specified location.");
        }
        if (isV3) {
            return dev.zarr.zarrjava.v3.Array.open(storeHandle);
        }
        if (isV2) {
            return dev.zarr.zarrjava.v2.Array.open(storeHandle);
        }
        throw new ZarrException("No Zarr array found at the specified location.");
    }

    public static Array open(Path path) throws IOException, ZarrException {
        return Array.open(new StoreHandle(new FilesystemStore(path), new String[0]));
    }

    public static Array open(String path) throws IOException, ZarrException {
        return Array.open(Paths.get(path, new String[0]));
    }

    public void write(long[] offset, ucar.ma2.Array array, boolean parallel) {
        ArrayMetadata metadata = this.metadata();
        if (offset.length != metadata.ndim()) {
            throw new IllegalArgumentException("'offset' needs to have rank '" + metadata.ndim() + "'.");
        }
        if (array.getRank() != metadata.ndim()) {
            throw new IllegalArgumentException("'array' needs to have rank '" + metadata.ndim() + "'.");
        }
        int[] shape = array.getShape();
        int[] chunkShape = metadata.chunkShape();
        Stream chunkStream = Arrays.stream(IndexingUtils.computeChunkCoords(metadata.shape, chunkShape, offset, shape));
        if (parallel) {
            chunkStream = (Stream)chunkStream.parallel();
        }
        chunkStream.forEach(chunkCoords -> {
            try {
                ucar.ma2.Array chunkArray;
                IndexingUtils.ChunkProjection chunkProjection = IndexingUtils.computeProjection(chunkCoords, metadata.shape, chunkShape, offset, shape);
                if (IndexingUtils.isFullChunk(chunkProjection.chunkOffset, chunkProjection.shape, chunkShape)) {
                    chunkArray = array.sectionNoReduce(chunkProjection.outOffset, chunkProjection.shape, null);
                } else {
                    chunkArray = this.readChunk((long[])chunkCoords);
                    MultiArrayUtils.copyRegion(array, chunkProjection.outOffset, chunkArray, chunkProjection.chunkOffset, chunkProjection.shape);
                }
                this.writeChunk((long[])chunkCoords, chunkArray);
            }
            catch (ZarrException | InvalidRangeException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void writeChunk(long[] chunkCoords, ucar.ma2.Array chunkArray) throws ZarrException {
        ArrayMetadata metadata = this.metadata();
        String[] chunkKeys = metadata.chunkKeyEncoding().encodeChunkKey(chunkCoords);
        StoreHandle chunkHandle = this.storeHandle.resolve(chunkKeys);
        Object parsedFillValue = metadata.parsedFillValue();
        if (parsedFillValue != null && MultiArrayUtils.allValuesEqual(chunkArray, parsedFillValue)) {
            chunkHandle.delete();
        } else {
            ByteBuffer chunkBytes = this.codecPipeline.encode(chunkArray);
            chunkHandle.set(chunkBytes);
        }
    }

    @Nonnull
    public ucar.ma2.Array readChunk(long[] chunkCoords) throws ZarrException {
        ArrayMetadata metadata = this.metadata();
        if (!this.chunkIsInArray(chunkCoords)) {
            throw new ZarrException("Attempting to read data outside of the array's domain.");
        }
        String[] chunkKeys = metadata.chunkKeyEncoding().encodeChunkKey(chunkCoords);
        StoreHandle chunkHandle = this.storeHandle.resolve(chunkKeys);
        ByteBuffer chunkBytes = chunkHandle.read();
        if (chunkBytes == null) {
            return metadata.allocateFillValueChunk();
        }
        return this.codecPipeline.decode(chunkBytes);
    }

    public void write(ucar.ma2.Array array) {
        this.write(new long[this.metadata().ndim()], array);
    }

    public void write(long[] offset, ucar.ma2.Array array) {
        this.write(offset, array, false);
    }

    public void write(ucar.ma2.Array array, boolean parallel) {
        this.write(new long[this.metadata().ndim()], array, parallel);
    }

    @Nonnull
    public ucar.ma2.Array read() throws ZarrException {
        return this.read(new long[this.metadata().ndim()], Utils.toIntArray(this.metadata().shape));
    }

    @Nonnull
    public ucar.ma2.Array read(long[] offset, int[] shape) throws ZarrException {
        return this.read(offset, shape, false);
    }

    @Nonnull
    public ucar.ma2.Array read(boolean parallel) throws ZarrException {
        return this.read(new long[this.metadata().ndim()], Utils.toIntArray(this.metadata().shape), parallel);
    }

    boolean chunkIsInArray(long[] chunkCoords) {
        int[] chunkShape = this.metadata().chunkShape();
        for (int dimIdx = 0; dimIdx < this.metadata().ndim(); ++dimIdx) {
            if (chunkCoords[dimIdx] >= 0L && chunkCoords[dimIdx] * (long)chunkShape[dimIdx] < this.metadata().shape[dimIdx]) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ucar.ma2.Array read(long[] offset, int[] shape, boolean parallel) throws ZarrException {
        ArrayMetadata metadata = this.metadata();
        if (offset.length != metadata.ndim()) {
            throw new IllegalArgumentException("'offset' needs to have rank '" + metadata.ndim() + "'.");
        }
        if (shape.length != metadata.ndim()) {
            throw new IllegalArgumentException("'shape' needs to have rank '" + metadata.ndim() + "'.");
        }
        for (int dimIdx = 0; dimIdx < metadata.ndim(); ++dimIdx) {
            if (offset[dimIdx] >= 0L && offset[dimIdx] + (long)shape[dimIdx] <= metadata.shape[dimIdx]) continue;
            throw new ZarrException("Requested data is outside of the array's domain.");
        }
        int[] chunkShape = metadata.chunkShape();
        if (IndexingUtils.isSingleFullChunk(offset, shape, chunkShape)) {
            return this.readChunk(IndexingUtils.computeSingleChunkCoords(offset, chunkShape));
        }
        ucar.ma2.Array outputArray = ucar.ma2.Array.factory((DataType)metadata.dataType().getMA2DataType(), (int[])shape);
        Stream chunkStream = Arrays.stream(IndexingUtils.computeChunkCoords(metadata.shape, chunkShape, offset, shape));
        if (parallel) {
            chunkStream = (Stream)chunkStream.parallel();
        }
        chunkStream.forEach(chunkCoords -> {
            try {
                String[] chunkKeys;
                StoreHandle chunkHandle;
                IndexingUtils.ChunkProjection chunkProjection = IndexingUtils.computeProjection(chunkCoords, metadata.shape, chunkShape, offset, shape);
                if (this.chunkIsInArray((long[])chunkCoords)) {
                    MultiArrayUtils.copyRegion(metadata.allocateFillValueChunk(), chunkProjection.chunkOffset, outputArray, chunkProjection.outOffset, chunkProjection.shape);
                }
                if (!(chunkHandle = this.storeHandle.resolve(chunkKeys = metadata.chunkKeyEncoding().encodeChunkKey((long[])chunkCoords))).exists()) {
                    return;
                }
                if (this.codecPipeline.supportsPartialDecode()) {
                    ucar.ma2.Array chunkArray = this.codecPipeline.decodePartial(chunkHandle, Utils.toLongArray(chunkProjection.chunkOffset), chunkProjection.shape);
                    MultiArrayUtils.copyRegion(chunkArray, new int[metadata.ndim()], outputArray, chunkProjection.outOffset, chunkProjection.shape);
                } else {
                    MultiArrayUtils.copyRegion(this.readChunk((long[])chunkCoords), chunkProjection.chunkOffset, outputArray, chunkProjection.outOffset, chunkProjection.shape);
                }
            }
            catch (ZarrException e) {
                throw new RuntimeException(e);
            }
        });
        return outputArray;
    }

    public ArrayAccessor access() {
        return new ArrayAccessor(this);
    }

    public static final class ArrayAccessor {
        @Nullable
        long[] offset;
        @Nullable
        int[] shape;
        @Nonnull
        Array array;

        public ArrayAccessor(@Nonnull Array array) {
            this.array = array;
        }

        @Nonnull
        public ArrayAccessor withOffset(long ... offset) {
            this.offset = offset;
            return this;
        }

        @Nonnull
        public ArrayAccessor withShape(int ... shape) {
            this.shape = shape;
            return this;
        }

        @Nonnull
        public ArrayAccessor withShape(long ... shape) {
            this.shape = Utils.toIntArray(shape);
            return this;
        }

        @Nonnull
        public ucar.ma2.Array read() throws ZarrException {
            if (this.offset == null) {
                throw new ZarrException("`offset` needs to be set.");
            }
            if (this.shape == null) {
                throw new ZarrException("`shape` needs to be set.");
            }
            return this.array.read(this.offset, this.shape);
        }

        public void write(@Nonnull ucar.ma2.Array content) throws ZarrException {
            if (this.offset == null) {
                throw new ZarrException("`offset` needs to be set.");
            }
            this.array.write(this.offset, content);
        }
    }
}

