/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class TagsFilter
extends DataBrowserLoader {
    private List<Long> nodeIds;
    private Map<Long, DataObject> nodes;
    private Class nodeType;
    private List<String> tags;
    private CallHandle handle;

    public TagsFilter(DataBrowser viewer, SecurityContext ctx, List<String> tags, Collection<DataObject> nodes) {
        super(viewer, ctx);
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("No nodes to filter.");
        }
        this.tags = tags;
        this.nodes = new HashMap<Long, DataObject>();
        this.nodeIds = new ArrayList<Long>();
        for (DataObject data : nodes) {
            this.nodeIds.add(data.getId());
            this.nodeType = data.getClass();
            this.nodes.put(data.getId(), data);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void load() {
        long userID = -1L;
        this.handle = this.mhView.filterByAnnotation(this.ctx, this.nodeType, this.nodeIds, TagAnnotationData.class, this.tags, userID, this);
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 5) {
            return;
        }
        Collection l = (Collection)result;
        ArrayList<DataObject> filteredNodes = new ArrayList<DataObject>();
        if (l == null) {
            this.viewer.setFilteredNodes(filteredNodes, null);
            return;
        }
        Iterator i = l.iterator();
        while (i.hasNext()) {
            long id = (Long)i.next();
            filteredNodes.add(this.nodes.get(id));
        }
        this.viewer.setFilteredNodes(filteredNodes, null);
    }
}

