/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ViewOtherAction
extends DataBrowserAction {
    private static final String NAME = "Other...";
    private static final String DESCRIPTION = "Open the document with the selected application.";
    private static final String DESCRIPTION_GENERAL = "Select the application to open the document.";
    private ApplicationData data;

    @Override
    protected void onDisplayChange(ImageDisplay node) {
        Browser browser = this.model.getBrowser();
        if (node == null || browser == null) {
            this.setEnabled(false);
            return;
        }
        if (browser.getSelectedDisplays().size() > 1) {
            this.setEnabled(false);
            return;
        }
        Object ho = node.getHierarchyObject();
        this.setEnabled(ho instanceof ImageData || ho instanceof FileAnnotationData);
    }

    public ViewOtherAction(DataBrowser model, ApplicationData data) {
        super(model);
        this.data = data;
        if (data == null) {
            this.putValue("Name", NAME);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_GENERAL));
        } else {
            this.putValue("Name", data.getApplicationName());
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            this.putValue("SmallIcon", data.getApplicationIcon());
        }
        this.onDisplayChange(model.getBrowser().getLastSelectedDisplay());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.model.openWith(this.data);
    }
}

