/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import omero.gateway.model.DataObject;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;

public class LayoutUtils {
    public static final int DEFAULT_PER_ROW = 10;
    private static final int MIN = 1;

    private static void scaleImage(ImageNode newNode, ImageNode oldNode) {
        Thumbnail th = newNode.getThumbnail();
        th.scale(oldNode.getThumbnail().getScalingFactor());
    }

    static void noChildLayout(ImageDisplay node) {
        node.getInternalDesktop().setPreferredSize(node.getTitleBar().getMinimumSize());
        node.setVisible(true);
    }

    static Dimension maxChildDim(ImageDisplay node) {
        Dimension maxDim = new Dimension(0, 0);
        Component[] comps = node.getInternalDesktop().getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (!(c instanceof ImageDisplay)) continue;
            maxDim = LayoutUtils.max(maxDim, c.getPreferredSize());
        }
        return maxDim;
    }

    static Dimension maxChildDim(Collection images) {
        Dimension maxDim = new Dimension(0, 0);
        for (ImageDisplay child : images) {
            maxDim = LayoutUtils.max(maxDim, child.getPreferredSize());
        }
        return maxDim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doSquareGridLayout(ImageDisplay root, List imageNodes) {
        Dimension d;
        Iterator children = imageNodes.iterator();
        Dimension maxDim = LayoutUtils.maxChildDim(imageNodes);
        int n = imageNodes.size();
        n = (int)Math.floor(Math.sqrt(n)) + 1;
        try {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (!children.hasNext()) {
                        return;
                    }
                    ImageDisplay child = (ImageDisplay)children.next();
                    d = child.getPreferredSize();
                    child.setBounds(j * maxDim.width, i * maxDim.height, d.width, d.height);
                }
            }
        }
        finally {
            Rectangle bounds = root.getContentsBounds();
            d = bounds.getSize();
            root.getInternalDesktop().setSize(d);
            root.getInternalDesktop().setPreferredSize(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doSquareGridLayout(ImageDisplay node, ViewerSorter sorter, int itemsPerRow) {
        Dimension d;
        Dimension maxDim = LayoutUtils.maxChildDim(node);
        int n = node.getChildrenDisplay().size();
        if (n == 0) {
            node.getInternalDesktop().setPreferredSize(node.getTitleBar().getMinimumSize());
            node.setVisible(true);
            return;
        }
        Component[] comps = node.getInternalDesktop().getComponents();
        List l = new ArrayList<Component>();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof ImageDisplay)) continue;
            l.add(comps[i]);
        }
        Dimension dd = node.getSize();
        if (dd.width == 0 || dd.height == 0 && node.getParentDisplay() != null) {
            dd = node.getParentDisplay().getSize();
        }
        l = sorter.sort(l);
        if (dd.width >= 1 && dd.height >= 1) {
            if (maxDim.width != 0) {
                n = dd.width / maxDim.width;
            }
            if (n == 0) {
                n = 10;
            }
            if (itemsPerRow >= 1) {
                n = itemsPerRow;
            }
        } else if (itemsPerRow >= 1) {
            n = itemsPerRow;
        } else {
            n = l.size();
            if (n > 10) {
                n = (int)Math.floor(Math.sqrt(n)) + 1;
            }
        }
        Iterator children = l.iterator();
        try {
            int i = 0;
            while (children.hasNext()) {
                for (int j = 0; j < n; ++j) {
                    if (!children.hasNext()) {
                        return;
                    }
                    ImageDisplay child = (ImageDisplay)children.next();
                    d = child.getPreferredSize();
                    child.setBounds(j * maxDim.width, i * maxDim.height, d.width, d.height);
                }
                ++i;
            }
        }
        finally {
            Rectangle bounds = node.getContentsBounds();
            d = bounds.getSize();
            node.getInternalDesktop().setSize(d);
            node.getInternalDesktop().setPreferredSize(d);
        }
    }

    static void redoLayout(ImageSet node, ImageSet oldNode, Collection newNodes, Collection oldNodes) {
        int n = newNodes.size();
        if (n == 0) {
            node.getInternalDesktop().setPreferredSize(node.getTitleBar().getMinimumSize());
            node.setVisible(true);
            return;
        }
        for (ImageDisplay child : newNodes) {
            Object oho;
            ImageDisplay oldChild;
            long id;
            Iterator j;
            Object ho = child.getHierarchyObject();
            Class<?> klass = ho.getClass();
            Object pho = child.getParentDisplay().getHierarchyObject();
            Class<?> pKlass = pho.getClass();
            if (!(ho instanceof DataObject)) continue;
            if (pho instanceof DataObject) {
                j = oldNodes.iterator();
                id = ((DataObject)ho).getId();
                long pid = ((DataObject)pho).getId();
                while (j.hasNext()) {
                    oldChild = (ImageDisplay)j.next();
                    oho = oldChild.getHierarchyObject();
                    if (oldChild.getParentDisplay() == null) continue;
                    Object poho = oldChild.getParentDisplay().getHierarchyObject();
                    if (!(oho instanceof DataObject) || ((DataObject)oho).getId() != id || !oho.getClass().equals(klass) || ((DataObject)poho).getId() != pid || !poho.getClass().equals(pKlass)) continue;
                    if (child instanceof ImageNode) {
                        LayoutUtils.scaleImage((ImageNode)child, (ImageNode)oldChild);
                    }
                    child.setBounds(oldChild.getBounds());
                }
                continue;
            }
            j = oldNodes.iterator();
            id = ((DataObject)ho).getId();
            while (j.hasNext()) {
                oldChild = (ImageDisplay)j.next();
                oho = oldChild.getHierarchyObject();
                if (oldChild.getParentDisplay() == null || !(oho instanceof DataObject) || ((DataObject)oho).getId() != id || !oho.getClass().equals(klass)) continue;
                if (child instanceof ImageNode) {
                    LayoutUtils.scaleImage((ImageNode)child, (ImageNode)oldChild);
                }
                child.setBounds(oldChild.getBounds());
            }
        }
        if (oldNode == null) {
            Rectangle bounds = node.getContentsBounds();
            Dimension d = bounds.getSize();
            node.getInternalDesktop().setSize(d);
            node.getInternalDesktop().setPreferredSize(d);
        } else {
            Dimension d = oldNode.getRestoreSize();
            if (oldNode.isCollapsed()) {
                Rectangle r = oldNode.getBounds();
                Rectangle bounds = new Rectangle(r.x, r.y, d.width, d.height);
                node.setBounds(bounds);
                node.setPreferredSize(d);
                node.getInternalDesktop().setSize(d);
                node.getInternalDesktop().setPreferredSize(d);
                node.setCollapsed(true);
            } else {
                node.setBounds(oldNode.getBounds());
                node.getInternalDesktop().setSize(d);
                node.getInternalDesktop().setPreferredSize(d);
            }
        }
    }

    public static Dimension max(Dimension a, Dimension b) {
        int w = a.width;
        int h = a.height;
        if (b.width > w) {
            w = b.width;
        }
        if (b.height > h) {
            h = b.height;
        }
        return new Dimension(w, h);
    }
}

