/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter;

import java.util.Collection;
import omero.gateway.SecurityContext;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.fsimporter.DataImporterLoader;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class DataLoader
extends DataImporterLoader {
    private Class rootType;
    private CallHandle handle;
    private boolean refreshImport;
    private boolean changeGroup;
    private boolean cancelled = false;

    public DataLoader(Importer viewer, SecurityContext ctx, Class<?> rootType, boolean refreshImport, boolean changeGroup) {
        super(viewer, ctx);
        if (!ProjectData.class.equals(rootType) && !ScreenData.class.equals(rootType)) {
            throw new IllegalArgumentException("Type not supported.");
        }
        this.rootType = rootType;
        this.refreshImport = refreshImport;
        this.changeGroup = changeGroup;
        this.userID = this.getCurrentUserID();
        if (ctx.getExperimenterData() != null) {
            this.userID = ctx.getExperimenterData().getId();
        }
    }

    @Override
    public void load() {
        this.handle = this.dmView.loadContainerHierarchy(this.ctx, this.rootType, null, false, -1L, this);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 3 || this.cancelled) {
            return;
        }
        int type = 0;
        if (ScreenData.class.equals((Object)this.rootType)) {
            type = 1;
        }
        this.viewer.setContainers((Collection)result, this.refreshImport, this.changeGroup, type, this.userID);
    }
}

