/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.util.Arrays;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ome.model.enums.UnitsFrequency;
import ome.model.enums.UnitsPower;
import ome.model.enums.UnitsTime;
import ome.model.units.Time;
import ome.model.units.UnitEnum;
import ome.units.unit.Unit;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import omero.model.ElectricPotential;
import omero.model.ElectricPotentialI;
import omero.model.Frequency;
import omero.model.FrequencyI;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.Power;
import omero.model.PowerI;
import omero.model.Pressure;
import omero.model.PressureI;
import omero.model.Temperature;
import omero.model.TemperatureI;
import omero.model.TimeI;
import omero.model.enums.UnitsElectricPotential;
import omero.model.enums.UnitsLength;
import omero.model.enums.UnitsPressure;
import omero.model.enums.UnitsTemperature;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.TagNames;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class OMEValueConverter {
    private static String pattern_double = "^[\\+\\-]{0,1}[0-9]+[\\.\\,]{1}[0-9]+$";
    private static String pattern_posDouble = "\\s|[1-9]+.*[0-9]*";
    private static String pattern_percentFraction = "[0]{1}.*[0-9]*|1|1.0|0";

    public static String[] getNames(Class<? extends Enum<?>> e) {
        return Arrays.toString(e.getEnumConstants()).replaceAll("^.|.$", "").split(", ");
    }

    public static String[] getUnitSymbols(Class<? extends Enum<?>> e) {
        UnitEnum[] enums = (UnitEnum[])e.getEnumConstants();
        String[] symbols = new String[enums.length];
        for (int i = 0; i < enums.length; ++i) {
            symbols[i] = enums[i].getSymbol();
        }
        return symbols;
    }

    public static PercentFraction parseToPercentFraction(String c) throws Exception {
        if (c == null || c.equals("")) {
            return null;
        }
        return new PercentFraction(Float.valueOf(c));
    }

    public static Boolean parseToBoolean(String val) {
        if (val == null || val.equals("")) {
            return null;
        }
        return Boolean.valueOf(val);
    }

    public static PositiveInteger parseToPositiveInt(String c) throws Exception {
        if (c == null || c.equals("")) {
            return null;
        }
        PositiveInteger result = null;
        Integer t = Integer.parseInt(c);
        result = new PositiveInteger(t);
        return result;
    }

    public static ome.units.quantity.Length parseToLength(String c, Unit<ome.units.quantity.Length> unit, boolean positiveVal) throws Exception {
        if (c == null || c.equals("")) {
            return null;
        }
        Double value = Double.valueOf(c);
        ome.units.quantity.Length result = null;
        if (positiveVal) {
            PositiveFloat pF = new PositiveFloat(value);
            result = new ome.units.quantity.Length((Number)value, unit);
        } else {
            result = new ome.units.quantity.Length((Number)value, unit);
        }
        return result;
    }

    public static Double parseToDouble(String c) throws NumberFormatException {
        if (c == null || c.equals("")) {
            return null;
        }
        return Double.parseDouble(c);
    }

    protected Double validateInput(TagData tag, String error) {
        return this.validateInput(tag, error, null);
    }

    protected Double validateInput(TagData tag, String error, String pattern) {
        String text = tag.getTagValue();
        if (text.equals("")) {
            return null;
        }
        String errorString = "";
        tag.setTagInfoError("");
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            String text2 = text.replaceAll(",", ".");
            try {
                return Double.parseDouble(text2);
            }
            catch (NumberFormatException e2) {
                errorString = error;
                tag.setTagInfoError(errorString);
                return null;
            }
        }
    }

    public DocumentListener createDocumentListenerDouble(TagData tag, String error) {
        return new DocumentListenerForDouble(tag, error, false);
    }

    public DocumentListener createDocumentListenerPosFloat(TagData tag, String error) {
        return new DocumentListenerForDouble(tag, error, true);
    }

    public DocumentListener createDocumentListenerPercentFraction(TagData tag, String error) {
        return new DocumentListenerForPercentFraction(tag, error);
    }

    public static ome.model.units.Unit[] convert(String[] value, String unitSymbol, String targetUnit) throws Exception {
        ElectricPotentialI tNew;
        ElectricPotentialI tOld;
        int i;
        if (value == null || value.length == 0 || unitSymbol == null) {
            return null;
        }
        ome.model.units.Unit[] result = new ome.model.units.Unit[value.length];
        int counter = 0;
        Class unitClass = TagNames.getUnitClassFromSymbol(unitSymbol);
        if (unitClass.equals(ome.model.units.ElectricPotential.class)) {
            for (i = 0; i < value.length; ++i) {
                if (value[i] == null || value[i].isEmpty()) continue;
                tOld = new ElectricPotentialI(Double.parseDouble(value[i]), ome.model.enums.UnitsElectricPotential.bySymbol((String)unitSymbol));
                tNew = new ElectricPotentialI((ElectricPotential)tOld, UnitsElectricPotential.valueOf((String)ome.model.enums.UnitsElectricPotential.bySymbol((String)targetUnit).toString()));
                result[i] = new ome.model.units.ElectricPotential(tNew.getValue(), ome.model.enums.UnitsElectricPotential.bySymbol((String)tNew.getSymbol()));
                ++counter;
            }
        }
        if (unitClass.equals(ome.model.units.Power.class)) {
            for (i = 0; i < value.length; ++i) {
                if (value[i] == null || value[i].isEmpty()) continue;
                tOld = new PowerI(Double.parseDouble(value[i]), UnitsPower.bySymbol((String)unitSymbol));
                tNew = new PowerI((Power)tOld, omero.model.enums.UnitsPower.valueOf((String)UnitsPower.bySymbol((String)targetUnit).toString()));
                result[i] = new ome.model.units.Power(tNew.getValue(), UnitsPower.bySymbol((String)tNew.getSymbol()));
                ++counter;
            }
        }
        if (unitClass.equals(ome.model.units.Frequency.class)) {
            for (i = 0; i < value.length; ++i) {
                if (value[i] == null || value[i].isEmpty()) continue;
                tOld = new FrequencyI(Double.parseDouble(value[i]), UnitsFrequency.bySymbol((String)unitSymbol));
                tNew = new FrequencyI((Frequency)tOld, omero.model.enums.UnitsFrequency.valueOf((String)UnitsFrequency.bySymbol((String)targetUnit).toString()));
                result[i] = new ome.model.units.Frequency(tNew.getValue(), UnitsFrequency.bySymbol((String)tNew.getSymbol()));
                ++counter;
            }
        }
        if (unitClass.equals(ome.model.units.Pressure.class)) {
            for (i = 0; i < value.length; ++i) {
                if (value[i] == null || value[i].isEmpty()) continue;
                tOld = new PressureI(Double.parseDouble(value[i]), ome.model.enums.UnitsPressure.bySymbol((String)unitSymbol));
                tNew = new PressureI((Pressure)tOld, UnitsPressure.valueOf((String)ome.model.enums.UnitsPressure.bySymbol((String)targetUnit).toString()));
                result[i] = new ome.model.units.Pressure(tNew.getValue(), ome.model.enums.UnitsPressure.bySymbol((String)tNew.getSymbol()));
                ++counter;
            }
        }
        if (unitClass.equals(ome.model.units.Length.class)) {
            for (i = 0; i < value.length; ++i) {
                if (value[i] == null || value[i].isEmpty()) continue;
                tOld = new LengthI(Double.parseDouble(value[i]), ome.model.enums.UnitsLength.bySymbol((String)unitSymbol));
                tNew = new LengthI((Length)tOld, UnitsLength.valueOf((String)ome.model.enums.UnitsLength.bySymbol((String)targetUnit).toString()));
                result[i] = new ome.model.units.Length(tNew.getValue(), ome.model.enums.UnitsLength.bySymbol((String)tNew.getSymbol()));
                ++counter;
            }
        }
        if (unitClass.equals(ome.model.units.Temperature.class)) {
            for (i = 0; i < value.length; ++i) {
                if (value[i] == null || value[i].isEmpty()) continue;
                tOld = new TemperatureI(Double.parseDouble(value[i]), ome.model.enums.UnitsTemperature.bySymbol((String)unitSymbol));
                tNew = new TemperatureI((Temperature)tOld, UnitsTemperature.valueOf((String)ome.model.enums.UnitsTemperature.bySymbol((String)targetUnit).toString()));
                result[i] = new ome.model.units.Temperature(tNew.getValue(), ome.model.enums.UnitsTemperature.bySymbol((String)tNew.getSymbol()));
                ++counter;
            }
        }
        if (unitClass.equals(Time.class)) {
            for (i = 0; i < value.length; ++i) {
                if (value[i] == null || value[i].isEmpty()) continue;
                tOld = new TimeI(Double.parseDouble(value[i]), UnitsTime.bySymbol((String)unitSymbol));
                tNew = new TimeI((omero.model.Time)tOld, omero.model.enums.UnitsTime.valueOf((String)UnitsTime.bySymbol((String)targetUnit).toString()));
                result[i] = new Time(tNew.getValue(), UnitsTime.bySymbol((String)tNew.getSymbol()));
                ++counter;
            }
        }
        if (counter > 0) {
            return result;
        }
        return null;
    }

    class DocumentListenerForPercentFraction
    implements DocumentListener {
        private TagData tag;
        private String error;

        public DocumentListenerForPercentFraction(TagData tag, String error) {
            this.tag = tag;
            this.error = error;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validate();
        }

        private void validate() {
            this.tag.setTagInfoError("");
            Double res = OMEValueConverter.this.validateInput(this.tag, this.error);
            if (res != null && (res < 0.0 || res > 1.0)) {
                this.tag.setTagInfoError(this.error);
            }
        }
    }

    class DocumentListenerForDouble
    implements DocumentListener {
        private TagData tag;
        private String error;
        private boolean posVal;

        public DocumentListenerForDouble(TagData tag, String error, boolean positiveVal) {
            this.tag = tag;
            this.error = error;
            this.posVal = positiveVal;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validate();
        }

        private void validate() {
            this.tag.setTagInfoError("");
            Double res = OMEValueConverter.this.validateInput(this.tag, this.error);
            if (this.posVal && res != null && res < 0.0) {
                this.tag.setTagInfoError(this.error);
            }
        }
    }
}

