/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleConfiguration;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleList;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagDataProp;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout.ModuleContentParser;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout.TagDataParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWriter {
    final String MDE_CONFIGURATION = "MDEConfiguration";
    final String MDE_PREDEFINITIONS = "MDEPredefinitions";
    private final String MDE_OBJECTS = "MDEObjects";
    final String ELEM_SETUP_PRE = "SetupPre";
    final String ELEM_SETUP_CONF = "SetupConf";
    final String ELEM_DEFINITION = "Definitions";
    final String ELEM_CONFIGURATION = "Configurations";
    final String ELEM_OBJECT_PRE = "ObjectPre";
    final String ELEM_OBJECT_DEF = "ObjectDef";
    final String ELEM_OBJECT_CONF = "ObjectConf";
    final String ELEM_PARENTS = "Parents";
    final String ELEM_TAGDATA = "TagData";
    final String ELEM_TAGDATAPROP = "TagDataProp";
    final String ATTR_NAME = "Name";
    final String ATTR_VISIBLE = "Visible";
    final String ATTR_REQUIRED = "Required";
    final String ATTR_UNIT = "Unit";
    final String ATTR_TYPE = "Type";
    final String ATTR_INSERT = "Insert";
    final String ATTR_INSERTPOINT = "InsertPoint";
    private final String ATTR_VALUES = "Values";
    private LinkedHashMap<String, ModuleList> hardwareConfiguration;
    HashMap<String, ModuleContent> objectDefinition;
    LinkedHashMap<String, HashMap<String, ModuleConfiguration>> objectConfiguration;

    private Element configurationToXML(LinkedHashMap<String, HashMap<String, ModuleConfiguration>> oConf, Document doc) {
        Element configElem = doc.createElement("Configurations");
        if (oConf == null) {
            return configElem;
        }
        for (Map.Entry<String, HashMap<String, ModuleConfiguration>> entry : oConf.entrySet()) {
            HashMap<String, ModuleConfiguration> micConf = entry.getValue();
            if (micConf == null) continue;
            Element micElem = doc.createElement("SetupConf");
            micElem.setAttribute("Name", entry.getKey());
            for (Map.Entry<String, ModuleConfiguration> object : micConf.entrySet()) {
                Element objElem = this.objectConfToXML(object.getKey(), object.getValue(), doc);
                if (objElem == null) continue;
                micElem.appendChild(objElem);
            }
            if (micElem == null) continue;
            configElem.appendChild(micElem);
        }
        return configElem;
    }

    private Node definitionToXML(HashMap<String, ModuleContent> oDef, Document doc) {
        Element defElem = doc.createElement("Definitions");
        if (oDef == null) {
            return defElem;
        }
        for (Map.Entry<String, ModuleContent> object : oDef.entrySet()) {
            Element objElem = this.objectDefToXML(object.getKey(), object.getValue(), doc, true);
            if (objElem == null) continue;
            defElem.appendChild(objElem);
        }
        return defElem;
    }

    private Element mde_objectsToXml(LinkedHashMap<String, HashMap<String, ModuleConfiguration>> oConf, HashMap<String, ModuleContent> oDef, Document doc) {
        Element mdeObjects = doc.createElement("MDEObjects");
        mdeObjects.appendChild(this.definitionToXML(oDef, doc));
        mdeObjects.appendChild(this.configurationToXML(oConf, doc));
        return mdeObjects;
    }

    private Element objectDefToXML(String type, ModuleContent content, Document doc, boolean saveVal) {
        if (content == null) {
            return null;
        }
        Element result = doc.createElement("ObjectDef");
        result.setAttribute("Type", type);
        List<TagData> list = content.getTagList();
        if (list == null) {
            return result;
        }
        TagDataParser td_parser = new TagDataParser();
        for (int i = 0; i < list.size(); ++i) {
            Element child = td_parser.createXMLElem(list.get(i), doc, "TagData", saveVal);
            if (child == null) continue;
            result.appendChild(child);
        }
        Element parents = doc.createElement("Parents");
        String parentVal = content.getParents() != null ? String.join((CharSequence)",", content.getParents()) : "";
        parents.setAttribute("Values", parentVal);
        result.appendChild(parents);
        return result;
    }

    private Element objectConfToXML(String type, ModuleConfiguration conf, Document doc) {
        if (conf == null) {
            return null;
        }
        Element result = doc.createElement("ObjectConf");
        result.setAttribute("Type", type);
        List<TagDataProp> list = conf.getTagPropList();
        if (list == null) {
            return result;
        }
        for (int i = 0; i < list.size(); ++i) {
            Element child = this.createTagDataPropElement(list.get(i), doc);
            if (child == null) continue;
            result.appendChild(child);
        }
        return result;
    }

    private HashMap<String, ModuleContent> elementsToObjectDefList(HashMap<String, ModuleContent> universal, NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        HashMap<String, ModuleContent> list = new HashMap<String, ModuleContent>();
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] XML: parse ObjectDef's ");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!n.getNodeName().equals("ObjectDef") || n.getNodeType() != 1) continue;
            Element eElement = (Element)n;
            String type = eElement.getAttribute("Type");
            ModuleContent defContent = universal != null ? universal.get(type) : null;
            list.put(type, this.elementToModuleContent(defContent, eElement, type));
        }
        return list;
    }

    private HashMap<String, ModuleConfiguration> elementsToObjectConfList(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        HashMap<String, ModuleConfiguration> list = new HashMap<String, ModuleConfiguration>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!n.getNodeName().equals("ObjectConf") || n.getNodeType() != 1) continue;
            Element eElement = (Element)n;
            String type = eElement.getAttribute("Type");
            String insertInTree = eElement.getAttribute("Insert");
            String insertPoint = eElement.getAttribute("InsertPoint");
            ModuleConfiguration mconf = this.elementsToTagDataPropList(eElement.getElementsByTagName("TagDataProp"));
            mconf.setInsertInTree(Boolean.valueOf(insertInTree));
            mconf.setInsertPoint(insertPoint);
            list.put(type, mconf);
        }
        return list;
    }

    private ModuleContent elementToModuleContent(ModuleContent universal, Element eElement, String type) {
        String parents = "";
        if (eElement.getElementsByTagName("Parents") != null && eElement.getElementsByTagName("Parents").getLength() > 0) {
            parents = ((Element)eElement.getElementsByTagName("Parents").item(0)).getAttribute("Values");
        }
        return new ModuleContentParser().parseFromConfig(eElement, type, false, parents.split(","));
    }

    public void saveToXML(LinkedHashMap<String, ModuleList> hconf, HashMap<String, ModuleContent> oDef, LinkedHashMap<String, HashMap<String, ModuleConfiguration>> oConf, String configPath) {
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element root = document.createElement("MDEConfiguration");
            document.appendChild(root);
            Element hardwareConf = document.createElement("MDEPredefinitions");
            root.appendChild(hardwareConf);
            for (Map.Entry<String, ModuleList> entry : hconf.entrySet()) {
                Element child = this.setupPreToXML(entry.getKey(), entry.getValue(), document);
                if (child == null) continue;
                hardwareConf.appendChild(child);
            }
            Element objElem = this.mde_objectsToXml(oConf, oDef, document);
            root.appendChild(objElem);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(new File(configPath));
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerConfigurationException e1) {
            String s = "[MDE] Cannot parse mde configuration file";
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e1);
            ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
        }
        catch (TransformerException e) {
            String s = "[MDE] Cannot parse mde configuration file";
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
        }
        catch (ParserConfigurationException e) {
            String s = "[MDE] Cannot parse mde configuration file";
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
        }
        ImporterAgent.getRegistry().getLogger().info((Object)this, "[MDE] Create XML File at " + configPath);
    }

    private Element setupPreToXML(String micName, ModuleList list, Document doc) {
        if (list == null) {
            return null;
        }
        Element result = doc.createElement("SetupPre");
        result.setAttribute("Name", micName);
        ModuleContentParser mc_parser = new ModuleContentParser();
        for (Map.Entry entry : list.entrySet()) {
            if (entry.getValue() == null) continue;
            for (ModuleContent c : (List)entry.getValue()) {
                Element child = null;
                if (c != null) {
                    child = mc_parser.createXMLElem(c, c.getAttributeValue("ID"), doc, "ObjectPre", true);
                }
                if (child == null) continue;
                result.appendChild(child);
            }
        }
        return result;
    }

    private Element createTagDataPropElement(TagDataProp t, Document doc) {
        if (t == null) {
            return null;
        }
        Element result = doc.createElement("TagDataProp");
        result.setAttribute("Name", t.getName());
        result.setAttribute("Visible", String.valueOf(t.isVisible()));
        result.setAttribute("Unit", t.getUnitSymbol());
        return result;
    }

    public void parseConfiguration(String configPath) {
        try {
            File hardwareFile = new File(configPath);
            if (hardwareFile.exists()) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(hardwareFile);
                doc.getDocumentElement().normalize();
                NodeList hardwareConf = doc.getElementsByTagName("MDEPredefinitions");
                if (hardwareConf != null && hardwareConf.getLength() > 0) {
                    this.hardwareConfiguration = this.elementsToHardwareConf(((Element)hardwareConf.item(0)).getElementsByTagName("SetupPre"));
                } else {
                    ImporterAgent.getRegistry().getLogger().info((Object)this, "[MDE] no setup predefinitions defined in mde configuration file");
                }
                NodeList mdeObjects = doc.getElementsByTagName("MDEObjects");
                if (mdeObjects != null && mdeObjects.getLength() > 0) {
                    NodeList objDef = ((Element)mdeObjects.item(0)).getElementsByTagName("Definitions");
                    if (objDef != null && objDef.getLength() > 0) {
                        this.objectDefinition = this.elementsToObjectDefList(null, ((Element)objDef.item(0)).getElementsByTagName("ObjectDef"));
                    } else {
                        ImporterAgent.getRegistry().getLogger().info((Object)this, "[MDE] no object definitions defined in mde configuration file");
                    }
                    NodeList objConf = ((Element)mdeObjects.item(0)).getElementsByTagName("Configurations");
                    if (objConf != null && objConf.getLength() > 0) {
                        this.objectConfiguration = this.elementsToObjectConf(((Element)objConf.item(0)).getElementsByTagName("SetupConf"));
                    } else {
                        ImporterAgent.getRegistry().getLogger().info((Object)this, "[MDE] no setup configurations defined in mde configuration file");
                    }
                } else {
                    ImporterAgent.getRegistry().getLogger().info((Object)this, "[MDE] No configuration file available for MDE under " + configPath);
                }
            }
        }
        catch (Exception e) {
            String s = "[MDE] Cannot parse mde configuration file";
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
        }
    }

    private ModuleConfiguration elementsToTagDataPropList(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        ModuleConfiguration list = new ModuleConfiguration();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!n.getNodeName().equals("TagDataProp") || n.getNodeType() != 1) continue;
            Element eElement = (Element)n;
            String tagName = eElement.getAttribute("Name");
            String tagUnit = eElement.getAttribute("Unit");
            String tagVis = eElement.getAttribute("Visible");
            String tagReq = eElement.getAttribute("Required");
            TagDataProp t = new TagDataProp(tagName, tagUnit, Boolean.parseBoolean(tagVis), Boolean.parseBoolean(tagReq));
            list.put(tagName, t);
        }
        return list;
    }

    private ModuleList elementsToModuleList(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        ModuleList list = new ModuleList();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!n.getNodeName().equals("ObjectPre") || n.getNodeType() != 1) continue;
            Element eElement = (Element)n;
            String type = eElement.getAttribute("Type");
            ModuleContent c = new ModuleContentParser().parseFromConfig(eElement, type, true, null);
            ArrayList<ModuleContent> cList = (ArrayList<ModuleContent>)list.get(type);
            if (cList == null) {
                cList = new ArrayList<ModuleContent>();
            }
            cList.add(c);
            list.put(type, cList);
        }
        return list;
    }

    private LinkedHashMap<String, ModuleList> elementsToHardwareConf(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        LinkedHashMap<String, ModuleList> list = new LinkedHashMap<String, ModuleList>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!n.getNodeName().equals("SetupPre") || n.getNodeType() != 1) continue;
            Element eElement = (Element)n;
            String name = eElement.getAttribute("Name");
            list.put(name, this.elementsToModuleList(eElement.getElementsByTagName("ObjectPre")));
        }
        return list;
    }

    private LinkedHashMap<String, HashMap<String, ModuleConfiguration>> elementsToObjectConf(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        LinkedHashMap<String, HashMap<String, ModuleConfiguration>> list = new LinkedHashMap<String, HashMap<String, ModuleConfiguration>>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!n.getNodeName().equals("SetupConf") || n.getNodeType() != 1) continue;
            Element eElement = (Element)n;
            String micname = eElement.getAttribute("Name");
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] XML: parse SetupConf for " + micname);
            list.put(micname, this.elementsToObjectConfList(eElement.getElementsByTagName("ObjectConf")));
        }
        return list;
    }

    public LinkedHashMap<String, ModuleList> getHardwareConfiguration() {
        return this.hardwareConfiguration;
    }

    public LinkedHashMap<String, HashMap<String, ModuleConfiguration>> getObjectConfiguration() {
        return this.objectConfiguration;
    }

    public HashMap<String, ModuleContent> getObjectDefinition() {
        return this.objectDefinition;
    }
}

