/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.configuration;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MetaDataDialog;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleConfiguration;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleList;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.view.ModuleContentTableModel;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.MDEConfiguration;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.ObjLayoutConf_Panel;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.ObjectList_Panel;

public class HardwareConfigurator
extends JFrame
implements ActionListener {
    public static final String CMD_APPLY = "apply";
    public static final String CMD_CANCEL = "cancel";
    public static final String CMD_SAVE = "save";
    public static final String CMD_NEW_MIC = "create new microsocope";
    public static final String CMD_DEL_MIC = "delete selected microsocope";
    private static final String CMD_EDIT_LAYOUT = "edit layout";
    private ListSelectionListener objSelectListener = null;
    final int WIDTH = 1000;
    final int HEIGHT = 600;
    private ModuleController controller;
    private DefaultListModel<String> listModelMic;
    private JList micList;
    private DefaultListModel<String> listModelObj;
    private JTextField txtMicName;
    private JPanel predefinitionsObject_Panel;
    private JPanel layoutObject_Panel;
    private MDEConfiguration conf;
    private String currentMic;
    private String[] availableMics;
    private JComboBox<String> objects;
    private MetaDataDialog dialog;
    private JPanel listPaneObj;
    private boolean deleteMic;

    public HardwareConfigurator(MetaDataDialog dialog) {
        super("Hardware Configurator");
        this.setDefaultCloseOperation(2);
        this.dialog = dialog;
        this.controller = ModuleController.getInstance();
        this.deleteMic = false;
        this.conf = new MDEConfiguration(this.controller.getMDEConfiguration());
        this.currentMic = this.controller.getCurrentMicName();
        this.availableMics = this.conf.getMicNames();
        this.buildGUI();
        this.revalidate();
        this.repaint();
        this.setResizable(true);
        this.pack();
        this.setVisible(true);
    }

    private void buildGUI() {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "--BUILD GUI : HardwareConfiguration");
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.loadMicroscopeList();
        this.objSelectListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JList source = (JList)e.getSource();
                    String newObj = (String)source.getSelectedValue();
                    if (!HardwareConfigurator.this.deleteMic) {
                        HardwareConfigurator.this.saveCurrentValues();
                    }
                    if (HardwareConfigurator.this.predefinitionsObject_Panel != null) {
                        HardwareConfigurator.this.predefinitionsObject_Panel.removeAll();
                    }
                    if (HardwareConfigurator.this.layoutObject_Panel != null) {
                        HardwareConfigurator.this.layoutObject_Panel.removeAll();
                    }
                    HardwareConfigurator.this.getPredefinitions(HardwareConfigurator.this.currentMic, newObj);
                    HardwareConfigurator.this.getLayout(HardwareConfigurator.this.currentMic, newObj);
                    HardwareConfigurator.this.revalidate();
                    HardwareConfigurator.this.repaint();
                }
            }
        };
        JPanel listPaneMic = this.createMicPanel();
        this.listPaneObj = new JPanel();
        this.createObjPanel();
        JPanel listPane = new JPanel(new GridLayout(0, 2));
        listPane.add(listPaneMic);
        listPane.add(this.listPaneObj);
        JPanel btnPanel = new JPanel();
        JButton btnApply = new JButton("Apply");
        btnApply.setActionCommand(CMD_APPLY);
        btnApply.addActionListener(this);
        btnPanel.add(btnApply);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setActionCommand(CMD_CANCEL);
        btnCancel.addActionListener(this);
        btnPanel.add(btnCancel);
        JButton btnSave = new JButton("Save To File");
        btnSave.setActionCommand(CMD_SAVE);
        btnSave.addActionListener(this);
        btnPanel.add(btnSave);
        this.predefinitionsObject_Panel = new JPanel(new BorderLayout());
        JScrollPane scrollView = new JScrollPane(this.predefinitionsObject_Panel);
        this.layoutObject_Panel = new JPanel(new BorderLayout());
        JScrollPane scrollViewLayout = new JScrollPane(this.layoutObject_Panel);
        JPanel valueViewPanel = new JPanel(new BorderLayout());
        valueViewPanel.add((Component)scrollView, "North");
        valueViewPanel.add((Component)scrollViewLayout, "Center");
        JPanel main = new JPanel(new BorderLayout());
        main.setPreferredSize(new Dimension(1000, 600));
        main.add((Component)listPane, "North");
        main.add((Component)valueViewPanel, "Center");
        main.add((Component)btnPanel, "South");
        this.getContentPane().add((Component)main, "Center");
    }

    private void createObjPanel() {
        this.loadObjectList(this.currentMic);
        this.listPaneObj.removeAll();
        this.listPaneObj.add(new ObjectList_Panel(this.currentMic, this.listModelObj, this.objSelectListener, this.conf));
        this.listPaneObj.revalidate();
        this.listPaneObj.repaint();
    }

    private JPanel createMicPanel() {
        this.micList = new JList<String>(this.listModelMic);
        this.micList.setSelectionMode(0);
        if (this.currentMic != "Universal") {
            this.micList.setSelectedIndex(this.controller.getMicIndex(this.currentMic));
        }
        this.micList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && HardwareConfigurator.this.micList.getSelectedIndex() != -1) {
                    String newSelection = (String)HardwareConfigurator.this.micList.getSelectedValue();
                    if (!HardwareConfigurator.this.deleteMic) {
                        HardwareConfigurator.this.saveCurrentValues();
                    }
                    HardwareConfigurator.this.currentMic = newSelection;
                    if (HardwareConfigurator.this.predefinitionsObject_Panel != null) {
                        HardwareConfigurator.this.predefinitionsObject_Panel.removeAll();
                    }
                    HardwareConfigurator.this.createObjPanel();
                    HardwareConfigurator.this.revalidate();
                    HardwareConfigurator.this.repaint();
                }
            }
        });
        this.micList.setVisibleRowCount(10);
        JScrollPane listScrollPane = new JScrollPane(this.micList);
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.black), "Microscope"));
        pane.add((Component)listScrollPane, "Center");
        JButton btnNewMic = new JButton("New");
        btnNewMic.setActionCommand(CMD_NEW_MIC);
        btnNewMic.addActionListener(this);
        JButton btnDelMic = new JButton("Delete");
        btnDelMic.setActionCommand(CMD_DEL_MIC);
        btnDelMic.addActionListener(this);
        JPanel btnPanelMic = new JPanel(new FlowLayout(2));
        btnPanelMic.add(btnNewMic);
        btnPanelMic.add(btnDelMic);
        this.txtMicName = new JTextField();
        JPanel newMicPane = new JPanel(new BorderLayout());
        newMicPane.add((Component)this.txtMicName, "Center");
        newMicPane.add((Component)btnPanelMic, "East");
        pane.add((Component)newMicPane, "South");
        pane.revalidate();
        pane.repaint();
        return pane;
    }

    private void getPredefinitions(String micName, String instrument) {
        if (this.predefinitionsObject_Panel == null || instrument == null) {
            return;
        }
        System.out.println("-- getPredefinition for: " + micName + "::" + instrument);
        ModuleList hardware = this.conf.getPredefinitions(micName);
        if (hardware == null) {
            this.predefinitionsObject_Panel.add((Component)new InstrumentTable(null, instrument), "Center");
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "--no predefinitions for selected mic " + micName + " and object " + instrument);
            return;
        }
        List cInstrument = (List)hardware.get(instrument);
        if (cInstrument == null) {
            this.predefinitionsObject_Panel.add((Component)new InstrumentTable(null, instrument), "Center");
        } else {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "\tload instrument " + instrument + "[" + cInstrument.size() + "] for " + micName);
            this.predefinitionsObject_Panel.add((Component)new InstrumentTable(cInstrument, instrument), "Center");
        }
        this.predefinitionsObject_Panel.revalidate();
        this.predefinitionsObject_Panel.repaint();
    }

    private void getLayout(String micName, String objName) {
        if (this.layoutObject_Panel == null || objName == null) {
            return;
        }
        System.out.println("-- getLayout for: " + micName + "::" + objName);
        ModuleContent content = this.conf.getContent(micName, objName);
        this.layoutObject_Panel.add(new ObjLayoutConf_Panel(content, this));
        this.layoutObject_Panel.revalidate();
        this.layoutObject_Panel.repaint();
    }

    private JTable createTable(List<ModuleContent> availableObjects, String type) {
        JTable table = new JTable();
        table.setSelectionMode(0);
        ModuleContentTableModel dataModel = new ModuleContentTableModel(this.controller.getContentOfType(type).getAttributeNames());
        if (availableObjects != null) {
            for (int i = 0; i < availableObjects.size(); ++i) {
                dataModel.addRow(availableObjects.get(i));
            }
        } else {
            dataModel.addRow(this.controller.getContentOfType(type));
        }
        dataModel.setEditable(true);
        table.setModel(dataModel);
        table.setPreferredScrollableViewportSize(new Dimension(table.getWidth(), 60));
        table.setFillsViewportHeight(true);
        try {
            table.getColumn("ID").setMinWidth(0);
            table.getColumn("ID").setMaxWidth(0);
            table.getColumn("ID").setWidth(0);
        }
        catch (Exception i) {
            // empty catch block
        }
        TableCellListener tcl = new TableCellListener(table, new EditAction(table, type));
        return table;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd;
        switch (cmd = e.getActionCommand()) {
            case "cancel": {
                this.setVisible(false);
                this.dispose();
                break;
            }
            case "apply": {
                this.saveCurrentValues();
                this.controller.setMDEConfiguration(this.conf);
                this.dialog.reloadView();
                this.setVisible(false);
                this.dispose();
                this.firePropertyChange("refreshMicContent", false, true);
                break;
            }
            case "save": {
                this.saveCurrentValues();
                this.conf.writeToFile(this.dialog.getMDEConfigPath());
                break;
            }
            case "create new microsocope": {
                this.saveCurrentValues();
                this.createNewMicroscope(this.txtMicName.getText());
                this.txtMicName.setText("");
                break;
            }
            case "delete selected microsocope": {
                System.out.println("Start delete mic...");
                this.deleteMic = true;
                this.deleteMicroscope();
                this.deleteMic = false;
                System.out.println("...End delete mic");
            }
        }
    }

    private void deleteMicroscope() {
        String micName = (String)this.micList.getSelectedValue();
        if (micName.equals("Universal")) {
            return;
        }
        int micIndex = this.micList.getSelectedIndex();
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "-- DELETE [" + micName + "]: on index " + micIndex + "/" + this.micList.getModel().getSize());
        if (micName == null || micName.equals("")) {
            return;
        }
        ((DefaultListModel)this.micList.getModel()).remove(micIndex);
        this.conf.removeAllPredefsForMicroscope(micName);
        this.micList.setSelectedIndex(0);
    }

    private void createNewMicroscope(String micName) {
        if (micName == null || micName.equals("")) {
            return;
        }
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "--create new category: " + micName);
        this.conf.initPredefinitionsForMicroscope(micName, new ModuleList());
        this.loadMicroscopeList();
        this.micList.setSelectedIndex(this.listModelMic.getSize());
        this.revalidate();
        this.repaint();
    }

    private void loadMicroscopeList() {
        if (this.listModelMic == null) {
            this.listModelMic = new DefaultListModel();
        }
        this.listModelMic.clear();
        this.availableMics = this.conf.getMicNames();
        if (this.availableMics != null) {
            for (String s : this.availableMics) {
                this.listModelMic.addElement(s);
            }
        }
        if (this.micList != null) {
            this.micList.revalidate();
            this.micList.repaint();
        }
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "-- MDEConfigurator: Load available mic list: ");
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "\t" + Arrays.toString(this.availableMics));
    }

    private void loadObjectList(String mic) {
        if (this.listModelObj == null) {
            this.listModelObj = new DefaultListModel();
        }
        this.listModelObj.clear();
        HashMap<String, ModuleConfiguration> currentObjConf = this.conf.getConfiguratedObjects(mic);
        if (currentObjConf != null) {
            System.out.println("-- Load objects for " + mic);
            for (Map.Entry<String, ModuleConfiguration> entry : currentObjConf.entrySet()) {
                if (entry.getValue() == null || this.conf.isContainer(entry.getKey()).booleanValue()) continue;
                this.listModelObj.addElement(entry.getKey());
            }
        }
    }

    private void saveCurrentValues() {
        if (this.predefinitionsObject_Panel != null && this.predefinitionsObject_Panel.getComponentCount() > 0) {
            for (Component c : this.predefinitionsObject_Panel.getComponents()) {
                if (!(c instanceof InstrumentTable)) continue;
                System.out.println("-- Save predefinitions for : " + this.currentMic + " : " + ((InstrumentTable)c).getInstrumentName());
                List<ModuleContent> list = ((InstrumentTable)c).getContent();
                this.conf.setPredefinitionsForMicroscope(this.currentMic, ((InstrumentTable)c).getInstrumentName(), ((InstrumentTable)c).getContent());
            }
        }
        if (this.layoutObject_Panel != null && this.layoutObject_Panel.getComponentCount() > 0) {
            for (Component c : this.layoutObject_Panel.getComponents()) {
                if (!(c instanceof ObjLayoutConf_Panel)) continue;
                this.conf.setConfiguration(this.currentMic, ((ObjLayoutConf_Panel)c).getType(), ((ObjLayoutConf_Panel)c).getConfiguration());
            }
        }
    }

    private class InstrumentTable
    extends JPanel {
        private JTable t;
        private String name;

        public InstrumentTable(List<ModuleContent> val, String name) {
            super(new BorderLayout());
            this.t = HardwareConfigurator.this.createTable(val, name);
            this.name = name;
            JPanel thisTable = new JPanel(new BorderLayout());
            thisTable.add((Component)this.t.getTableHeader(), "First");
            thisTable.add((Component)this.t, "Center");
            JScrollPane scrollPane = new JScrollPane(thisTable);
            JButton addBtn = new JButton("Add");
            addBtn.addActionListener(new AddAction(this.t, name));
            JButton delBtn = new JButton("Delete");
            delBtn.addActionListener(new DelAction(this.t, name));
            JPanel keyPanel = new JPanel(new FlowLayout(2));
            keyPanel.add(addBtn);
            keyPanel.add(delBtn);
            this.add((Component)keyPanel, "South");
            this.add((Component)scrollPane, "Center");
            this.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.black), name));
            this.revalidate();
            this.repaint();
        }

        public String getInstrumentName() {
            return this.name;
        }

        public List<ModuleContent> getContent() {
            ArrayList<ModuleContent> result = new ArrayList<ModuleContent>();
            for (int i = 0; i < this.t.getModel().getRowCount(); ++i) {
                ModuleContent rowContent = ((ModuleContentTableModel)this.t.getModel()).getRowData(i, HardwareConfigurator.this.controller.getContentOfType(this.name));
                if (rowContent == null) continue;
                result.add(rowContent);
            }
            return result;
        }
    }

    private class EditAction
    extends AbstractAction {
        private final JTable actionTable;
        private final String type;

        public EditAction(JTable table, String type) {
            this.actionTable = table;
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellListener tcl = (TableCellListener)e.getSource();
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "EDIT Table: Old   : " + tcl.getOldValue() + ", New   : " + tcl.getNewValue());
        }
    }

    private class DelAction
    extends AbstractAction {
        private final JTable actionTable;
        private final String type;

        public DelAction(JTable table, String type) {
            this.actionTable = table;
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.actionTable.getSelectedRow() != -1) {
                ((ModuleContentTableModel)this.actionTable.getModel()).removeRow(this.actionTable.getSelectedRow());
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        private final JTable actionTable;
        private final String type;

        public AddAction(JTable table, String type) {
            this.actionTable = table;
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((ModuleContentTableModel)this.actionTable.getModel()).addRow(HardwareConfigurator.this.controller.getContentOfType(this.type));
        }
    }

    public class TableCellListener
    implements PropertyChangeListener,
    Runnable {
        private JTable table;
        private Action action;
        private int row;
        private int column;
        private Object oldValue;
        private Object newValue;

        public TableCellListener(JTable table, Action action) {
            this.table = table;
            this.action = action;
            this.table.addPropertyChangeListener(this);
        }

        private TableCellListener(JTable table, int row, int column, Object oldValue, Object newValue) {
            this.table = table;
            this.row = row;
            this.column = column;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public int getColumn() {
            return this.column;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public int getRow() {
            return this.row;
        }

        public JTable getTable() {
            return this.table;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("tableCellEditor".equals(e.getPropertyName())) {
                if (this.table.isEditing()) {
                    this.processEditingStarted();
                } else {
                    this.processEditingStopped();
                }
            }
        }

        private void processEditingStarted() {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            this.row = this.table.convertRowIndexToModel(this.table.getEditingRow());
            this.column = this.table.convertColumnIndexToModel(this.table.getEditingColumn());
            this.oldValue = this.table.getModel().getValueAt(this.row, this.column);
            this.newValue = null;
        }

        private void processEditingStopped() {
            this.newValue = this.table.getModel().getValueAt(this.row, this.column);
            if (!this.newValue.equals(this.oldValue)) {
                TableCellListener tcl = new TableCellListener(this.getTable(), this.getRow(), this.getColumn(), this.getOldValue(), this.getNewValue());
                ActionEvent event = new ActionEvent(tcl, 1001, "");
                this.action.actionPerformed(event);
            }
        }
    }
}

