/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement;

import java.util.Collection;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.ROIData;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.events.measurement.ROIEvent;
import org.openmicroscopy.shoola.agents.measurement.MeasurementViewerLoader;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ROISaver
extends MeasurementViewerLoader {
    private long imageID;
    private long userID;
    private List<ROIData> roiList;
    private CallHandle handle;
    private boolean close;

    public ROISaver(MeasurementViewer viewer, SecurityContext ctx, long imageID, long userID, List<ROIData> roiList, boolean close) {
        super(viewer, ctx);
        if (imageID < 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        this.imageID = imageID;
        this.userID = userID;
        this.roiList = roiList;
        this.close = close;
    }

    @Override
    public void load() {
        this.handle = this.idView.saveROI(this.ctx, this.imageID, this.userID, this.roiList, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleException(Throwable exc) {
        int state = this.viewer.getState();
        exc.printStackTrace();
        String s = "An error occurred while saving the ROI ";
        LogMessage msg = new LogMessage();
        msg.print("State: " + state);
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyInfo("Saving ROI", s);
        if (this.close) {
            this.viewer.discard();
        } else {
            this.viewer.cancel();
        }
    }

    @Override
    public void handleResult(Object result) {
        this.registry.getEventBus().post(new ROIEvent(this.viewer.getImageID()));
        if (this.viewer.getState() == 6) {
            return;
        }
        this.viewer.setUpdateROIComponent((Collection)result);
    }
}

