/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityModel;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityTable;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class IntensityValuesDialog
extends JDialog {
    private static final int ROWWIDTHMIN = 24;
    private static final String ROWSPACER = "  ";
    private IntensityTable table;
    private JScrollPane intensityTableScrollPane;
    private JList intensityTableRowHeader;

    private void buildUI(JComboBox channels) {
        TitlePanel infoPanel = new TitlePanel("Intensity Values", "This table shows the Intensity values for the selected channel of the selected ROI.", IconManager.getInstance().getIcon(10));
        JPanel row = UIUtilities.buildComponentPanel(new JLabel("Selet the channel:"));
        row.add(channels);
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 1));
        top.add((Component)((Object)infoPanel));
        top.add(row);
        this.getContentPane().add((Component)top, "North");
        this.intensityTableRowHeader = new JList(new HeaderListModel(this.table.getRowCount()));
        this.intensityTableRowHeader.setFixedCellHeight(this.table.getRowHeight());
        this.intensityTableRowHeader.setFixedCellWidth(this.table.getColumnWidth());
        this.intensityTableRowHeader.setCellRenderer(new RowHeaderRenderer(this.table));
        this.intensityTableScrollPane = new JScrollPane(this.table);
        this.intensityTableScrollPane.setRowHeaderView(this.intensityTableRowHeader);
        this.intensityTableScrollPane.setCorner("UPPER_LEFT_CORNER", new JPanel());
        this.getContentPane().add((Component)this.intensityTableScrollPane, "Center");
        JViewport viewPort = this.intensityTableScrollPane.getViewport();
        viewPort.setViewPosition(new Point(1, 1));
    }

    IntensityValuesDialog(JFrame owner, IntensityModel model, JComboBox channels) {
        super(owner);
        this.table = new IntensityTable(model);
        this.buildUI(channels);
    }

    void setModel(IntensityModel model) {
        this.table.setModel(model);
        Vector<Integer> listData = new Vector<Integer>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            listData.add(i);
        }
        this.intensityTableRowHeader.setListData(listData);
        Font font = this.table.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        int w = metrics.stringWidth(ROWSPACER + model.getRowCount() + ROWSPACER);
        int rowWidth = Math.max(w, 24);
        this.intensityTableRowHeader.setFixedCellWidth(rowWidth);
        this.intensityTableScrollPane.setRowHeaderView(this.intensityTableRowHeader);
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(JTable table) {
            if (table != null) {
                JTableHeader header = table.getTableHeader();
                this.setOpaque(true);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setHorizontalAlignment(0);
                this.setHorizontalTextPosition(0);
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    class HeaderListModel
    extends AbstractListModel {
        private String[] headers;

        HeaderListModel(int n) {
            this.headers = new String[n];
            for (int i = 0; i < n; ++i) {
                this.headers[i] = "" + (n - i);
            }
        }

        @Override
        public int getSize() {
            return this.headers.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.headers[index];
        }
    }
}

