/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.MetadataLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;

public class RenderingSettingsLoader
extends MetadataLoader {
    public static final int TASK_VIEWEDBY = 0;
    public static final int TASK_COPY_PASTE = 1;
    private long pixelsID;
    private CallHandle handle;
    private int task = -1;

    public RenderingSettingsLoader(MetadataViewer viewer, SecurityContext ctx, long pixelsID, int loaderID, int task) {
        super(viewer, ctx, loaderID);
        this.task = task;
        this.pixelsID = pixelsID;
    }

    @Override
    public void load() {
        this.handle = this.ivView.getRenderingSettings(this.ctx, this.pixelsID, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        Map map = (Map)result;
        if (this.task == 0) {
            if (this.viewer.getState() == 4) {
                return;
            }
            HashMap<DataObject, RndProxyDef> m = new HashMap<DataObject, RndProxyDef>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                Collection def = (Collection)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)def)) continue;
                m.put((DataObject)entry.getKey(), (RndProxyDef)def.iterator().next());
            }
            this.viewer.setViewedBy(m);
        } else if (this.task == 1) {
            if (this.viewer.getRenderer() == null) {
                return;
            }
            ExperimenterData user = (ExperimenterData)MetadataViewerAgent.getRegistry().lookup("/current_user/details");
            for (Map.Entry entry : map.entrySet()) {
                ExperimenterData exp;
                if (!(entry.getKey() instanceof ExperimenterData) || (exp = (ExperimenterData)entry.getKey()).getId() != user.getId()) continue;
                Collection def = (Collection)entry.getValue();
                this.viewer.applyRenderingSettings((RndProxyDef)def.iterator().next());
                break;
            }
        }
    }
}

