/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import omero.gateway.model.ImageData;
import omero.gateway.model.WellSampleData;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class AnalysisDialog
extends JPopupMenu {
    private static final String FLIM_TEXT = "FLIM";
    private static final String FLIM_TOOLTIP = "";
    private static final String FRAP_TEXT = "FRAP";
    private static final String FRAP_TOOLTIP = "FRAP Analysis";
    private EditorControl controller;
    private EditorModel model;
    private JMenuItem FRAPItem;
    private JMenuItem FLIMItem;

    private JMenuItem createMenuItem(Icon icon, String tooltip, String text, int id) {
        JMenuItem b = new JMenuItem(icon);
        b.setText(text);
        b.setToolTipText(tooltip);
        b.addActionListener(this.controller);
        b.setActionCommand(FLIM_TOOLTIP + id);
        b.setEnabled(false);
        UIUtilities.unifiedButtonLookAndFeel(b);
        return b;
    }

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.FRAPItem = this.createMenuItem(icons.getIcon(83), FRAP_TOOLTIP, FRAP_TEXT, 15);
        this.FLIMItem = this.createMenuItem(icons.getIcon(70), FLIM_TOOLTIP, FLIM_TEXT, 9);
    }

    private void buildGUI() {
        this.add(this.FRAPItem);
    }

    AnalysisDialog(EditorControl controller, EditorModel model) {
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.setRootObject();
        this.buildGUI();
    }

    void setRootObject() {
        Object refObject = this.model.getRefObject();
        ImageData img = null;
        this.FRAPItem.setEnabled(false);
        this.FLIMItem.setEnabled(false);
        if (refObject instanceof ImageData) {
            img = (ImageData)refObject;
        } else if (refObject instanceof WellSampleData) {
            img = ((WellSampleData)refObject).getImage();
        }
        if (img != null) {
            try {
                img.getDefaultPixels();
                this.FRAPItem.setEnabled(true);
                this.FLIMItem.setEnabled(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

