/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.DatasetData;
import omero.gateway.model.DoubleAnnotationData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FileData;
import omero.gateway.model.ImageData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.TextualAnnotationData;
import omero.gateway.model.WellSampleData;
import omero.gateway.model.XMLAnnotationData;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationTaskPane;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.AttachmentsTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.CommentsTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditableTextComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.OtherTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.PropertiesUI;
import org.openmicroscopy.shoola.agents.metadata.editor.TagsTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.ToolBar;
import org.openmicroscopy.shoola.agents.metadata.util.DataToSave;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.editorpreview.PreviewPanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class GeneralPaneUI
extends JPanel {
    private static final String ID_TEXT = "ID: ";
    private static final String OWNER_TEXT = "Owner: ";
    private static final String EDIT_NAME_TEXT = "Edit the name";
    private static final String DETAILS = " Details";
    private EditorControl controller;
    private EditorModel model;
    private EditorUI view;
    private PropertiesUI propertiesUI;
    private JXTaskPane browserTaskPane;
    private JXTaskPane propertiesTaskPane;
    private AnnotationTaskPane tagsTaskPane;
    private AnnotationTaskPane roiTaskPane;
    private AnnotationTaskPane mapTaskPane;
    private AnnotationTaskPane attachmentTaskPane;
    private AnnotationTaskPane otherTaskPane;
    private AnnotationTaskPane ratingTaskPane;
    private AnnotationTaskPane commentTaskPane;
    private List<AnnotationUI> components;
    private List<PreviewPanel> previews;
    private boolean init;
    private ToolBar toolbar;
    private JButton filterButton;
    private AnnotationTaskPaneUI.Filter annotationsFilter;
    private EditableTextComponent namePane;
    boolean nameModified = false;
    private JTextField idLabel;
    private JLabel ownerLabel;

    private void loadParents(boolean b) {
        if (b) {
            this.controller.loadParents();
        } else {
            this.model.cancelParentsLoading();
        }
    }

    private void initComponents() {
        this.browserTaskPane = EditorUtil.createTaskPane("Located in");
        this.browserTaskPane.addPropertyChangeListener((PropertyChangeListener)this.controller);
        this.namePane = new EditableTextComponent(this.model.canEdit(), false, EDIT_NAME_TEXT);
        this.namePane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("EDIT_PROPERTY")) {
                    GeneralPaneUI.this.updateName((String)evt.getNewValue());
                    GeneralPaneUI.this.nameModified = true;
                    GeneralPaneUI.this.view.saveData(true);
                    GeneralPaneUI.this.nameModified = false;
                }
            }
        });
        this.idLabel = new JTextField();
        this.idLabel.setBackground(UIUtilities.BACKGROUND);
        this.idLabel.setFont(this.idLabel.getFont().deriveFont(1));
        this.idLabel.setEditable(false);
        this.idLabel.setBorder(BorderFactory.createEmptyBorder());
        this.ownerLabel = new JLabel();
        this.ownerLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.ownerLabel.setFont(this.ownerLabel.getFont().deriveFont(1));
        IconManager icons = IconManager.getInstance();
        this.annotationsFilter = AnnotationTaskPaneUI.Filter.SHOW_ALL;
        this.filterButton = new JButton(this.annotationsFilter.name);
        this.filterButton.setToolTipText("Filter annotations by user");
        UIUtilities.unifiedButtonLookAndFeel(this.filterButton);
        Font font = this.filterButton.getFont();
        this.filterButton.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
        this.filterButton.setIcon(icons.getIcon(96));
        this.filterButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.filterButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                Object source = me.getSource();
                if (source instanceof Component) {
                    GeneralPaneUI.this.displayFilterMenu((Component)source, me.getPoint());
                }
            }
        });
        this.propertiesUI = new PropertiesUI(this.model, this.controller);
        this.components = new ArrayList<AnnotationUI>();
        this.components.add(this.propertiesUI);
        Iterator<AnnotationUI> i = this.components.iterator();
        while (i.hasNext()) {
            i.next().addPropertyChangeListener("save", this.controller);
        }
        this.previews = new ArrayList<PreviewPanel>();
        this.propertiesTaskPane = EditorUtil.createTaskPane("");
        this.propertiesTaskPane.add((Component)this.propertiesUI);
        this.propertiesTaskPane.setCollapsed(false);
        this.tagsTaskPane = new AnnotationTaskPane(AnnotationTaskPane.AnnotationType.TAGS, this.view, this.model, this.controller);
        this.roiTaskPane = new AnnotationTaskPane(AnnotationTaskPane.AnnotationType.ROIS, this.view, this.model, this.controller);
        this.mapTaskPane = new AnnotationTaskPane(AnnotationTaskPane.AnnotationType.MAP, this.view, this.model, this.controller);
        this.attachmentTaskPane = new AnnotationTaskPane(AnnotationTaskPane.AnnotationType.ATTACHMENTS, this.view, this.model, this.controller);
        this.otherTaskPane = new AnnotationTaskPane(AnnotationTaskPane.AnnotationType.OTHER, this.view, this.model, this.controller);
        this.ratingTaskPane = new AnnotationTaskPane(AnnotationTaskPane.AnnotationType.RATING, this.view, this.model, this.controller);
        this.commentTaskPane = new AnnotationTaskPane(AnnotationTaskPane.AnnotationType.COMMENTS, this.view, this.model, this.controller);
    }

    private void displayFilterMenu(Component src, Point p) {
        JPopupMenu menu = new JPopupMenu();
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem item = this.createFilterMenuItem(AnnotationTaskPaneUI.Filter.SHOW_ALL);
        group.add(item);
        menu.add(item);
        item = this.createFilterMenuItem(AnnotationTaskPaneUI.Filter.ADDED_BY_ME);
        group.add(item);
        menu.add(item);
        item = this.createFilterMenuItem(AnnotationTaskPaneUI.Filter.ADDED_BY_OTHERS);
        group.add(item);
        menu.add(item);
        menu.show(src, p.x, p.y);
    }

    private JCheckBoxMenuItem createFilterMenuItem(final AnnotationTaskPaneUI.Filter filter) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(filter.name);
        Font f = item.getFont();
        item.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        item.setSelected(filter == this.annotationsFilter);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralPaneUI.this.annotationsFilter = filter;
                GeneralPaneUI.this.filterButton.setText(GeneralPaneUI.this.annotationsFilter.name);
                GeneralPaneUI.this.applyFilter();
            }
        });
        return item;
    }

    private void applyFilter() {
        this.tagsTaskPane.filter(this.annotationsFilter);
        this.roiTaskPane.filter(this.annotationsFilter);
        this.mapTaskPane.filter(this.annotationsFilter);
        this.attachmentTaskPane.filter(this.annotationsFilter);
        this.ratingTaskPane.filter(this.annotationsFilter);
        this.otherTaskPane.filter(this.annotationsFilter);
        this.commentTaskPane.filter(this.annotationsFilter);
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 11;
        this.add((Component)this.toolbar, c);
        ++c.gridy;
        this.namePane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add((Component)this.namePane, c);
        ++c.gridy;
        this.idLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2));
        this.add((Component)this.idLabel, c);
        ++c.gridy;
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add((Component)this.ownerLabel, "West");
        p.add((Component)this.filterButton, "East");
        this.add((Component)p, c);
        ++c.gridy;
        this.add((Component)this.propertiesTaskPane, c);
        ++c.gridy;
        this.add((Component)((Object)this.tagsTaskPane), c);
        ++c.gridy;
        this.add((Component)((Object)this.mapTaskPane), c);
        ++c.gridy;
        this.add((Component)((Object)this.attachmentTaskPane), c);
        ++c.gridy;
        this.add((Component)((Object)this.ratingTaskPane), c);
        ++c.gridy;
        this.add((Component)((Object)this.commentTaskPane), c);
        ++c.gridy;
        this.add((Component)this.browserTaskPane, c);
        ++c.gridy;
        this.otherTaskPane.setVisible(false);
        this.add((Component)((Object)this.otherTaskPane), c);
        ++c.gridy;
        UIUtilities.addFiller(this, c, true);
    }

    GeneralPaneUI(EditorUI view, EditorModel model, EditorControl controller, ToolBar toolBar) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.model = model;
        this.controller = controller;
        this.toolbar = toolBar;
        this.view = view;
        this.initComponents();
        this.init = false;
    }

    void layoutUI() {
        if (!this.init) {
            this.buildGUI();
            this.init = true;
        }
        boolean multi = this.model.isMultiSelection();
        this.namePane.buildUI(this.model.getRefObjectName(), this.model.canEdit());
        Object refObject = this.model.getRefObject();
        Object text = this.model.getObjectTypeAsString(refObject);
        if (this.model.getRefObjectID() > 0L) {
            text = (String)text + " ID: " + this.model.getRefObjectID();
        }
        if (refObject instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)refObject;
            text = (String)text + " (Image ID: " + wsd.getImage().getId() + ")";
        }
        this.idLabel.setText((String)text);
        String ownerName = this.model.getOwnerName();
        this.ownerLabel.setText("");
        this.filterButton.setVisible(true);
        if (multi) {
            if (!(refObject instanceof TagAnnotationData) && !(refObject instanceof FileAnnotationData)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Annotate the selected ");
                buffer.append(this.model.getObjectTypeAsString(refObject));
                buffer.append("s");
                this.ownerLabel.setText(buffer.toString());
            } else {
                this.filterButton.setVisible(false);
            }
        } else if (ownerName != null && ownerName.length() > 0) {
            this.ownerLabel.setText(OWNER_TEXT + ownerName);
        }
        this.propertiesUI.buildUI();
        boolean visible = !(refObject instanceof TagAnnotationData) && !(refObject instanceof FileAnnotationData);
        this.tagsTaskPane.setVisible(visible);
        this.roiTaskPane.setVisible(visible);
        this.mapTaskPane.setVisible(visible && !multi);
        this.attachmentTaskPane.setVisible(visible);
        this.ratingTaskPane.setVisible(visible);
        this.commentTaskPane.setVisible(visible);
        this.otherTaskPane.setVisible(visible && !this.model.getAllOtherAnnotations().isEmpty());
        if (visible) {
            this.tagsTaskPane.refreshUI();
            this.roiTaskPane.refreshUI();
            this.mapTaskPane.refreshUI();
            this.attachmentTaskPane.refreshUI();
            this.ratingTaskPane.refreshUI();
            this.commentTaskPane.refreshUI();
            this.otherTaskPane.refreshUI();
        }
        this.propertiesTaskPane.setTitle(this.propertiesUI.getText() + DETAILS);
        boolean showBrowser = false;
        if (refObject instanceof ImageData && !multi && this.model.getChannelData() == null) {
            this.propertiesUI.onChannelDataLoading();
            this.controller.loadChannelData();
            showBrowser = true;
        }
        if (refObject instanceof WellSampleData && !multi) {
            this.controller.loadChannelData();
            showBrowser = true;
        }
        if ((refObject instanceof DatasetData || refObject instanceof FileAnnotationData || refObject instanceof PlateAcquisitionData) && !multi) {
            showBrowser = true;
        }
        this.browserTaskPane.setVisible(showBrowser);
        if (showBrowser) {
            if (refObject instanceof FileAnnotationData) {
                this.browserTaskPane.setTitle("Attached to");
            } else {
                this.browserTaskPane.setTitle("Located in");
            }
        }
        this.namePane.setVisible(!multi);
        this.idLabel.setVisible(!multi);
        this.propertiesTaskPane.setVisible(!multi);
        this.revalidate();
    }

    public PropertiesUI getPropertiesUI() {
        return this.propertiesUI;
    }

    DataToSave prepareDataToSave() {
        if (!this.model.isMultiSelection()) {
            this.propertiesUI.updateDataObject();
        }
        ArrayList<AnnotationData> toAdd = new ArrayList<AnnotationData>();
        toAdd.addAll(this.tagsTaskPane.getAnnotationsToSave());
        toAdd.addAll(this.attachmentTaskPane.getAnnotationsToSave());
        toAdd.addAll(this.otherTaskPane.getAnnotationsToSave());
        toAdd.addAll(this.ratingTaskPane.getAnnotationsToSave());
        toAdd.addAll(this.mapTaskPane.getAnnotationsToSave());
        toAdd.addAll(this.commentTaskPane.getAnnotationsToSave());
        ArrayList<Object> toRemove = new ArrayList<Object>();
        toRemove.addAll(this.tagsTaskPane.getAnnotationsToRemove());
        toRemove.addAll(this.attachmentTaskPane.getAnnotationsToRemove());
        toRemove.addAll(this.otherTaskPane.getAnnotationsToRemove());
        toRemove.addAll(this.ratingTaskPane.getAnnotationsToRemove());
        toRemove.addAll(this.mapTaskPane.getAnnotationsToRemove());
        toRemove.addAll(this.commentTaskPane.getAnnotationsToRemove());
        return new DataToSave(toAdd, toRemove);
    }

    void updateName(String name) {
        Object object = this.model.getRefObject();
        if (object instanceof ProjectData) {
            ProjectData p = (ProjectData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
        } else if (object instanceof DatasetData) {
            DatasetData p = (DatasetData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
        } else if (object instanceof ImageData) {
            ImageData p = (ImageData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
        } else if (object instanceof TagAnnotationData) {
            TagAnnotationData p = (TagAnnotationData)object;
            if (name.length() > 0) {
                p.setTagValue(name);
            }
        } else if (object instanceof ScreenData) {
            ScreenData p = (ScreenData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
        } else if (object instanceof PlateData) {
            PlateData p = (PlateData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
        } else if (object instanceof WellSampleData) {
            WellSampleData well = (WellSampleData)object;
            ImageData img = well.getImage();
            if (name.length() > 0) {
                img.setName(name);
            }
        } else if (object instanceof FileData) {
            FileData f = (FileData)object;
            if (f.getId() > 0L) {
                return;
            }
        } else if (object instanceof PlateAcquisitionData) {
            PlateAcquisitionData pa = (PlateAcquisitionData)object;
            if (name.length() > 0) {
                pa.setName(name);
            }
        }
    }

    void setParentRootObject() {
        this.propertiesUI.setParentRootObject();
    }

    void setRootObject(Object oldObject) {
        if (!this.init) {
            this.buildGUI();
            this.init = true;
        }
        this.clearData(oldObject);
        this.propertiesUI.clearDisplay();
        this.tagsTaskPane.clearDisplay();
        this.roiTaskPane.clearDisplay();
        this.mapTaskPane.clearDisplay();
        this.attachmentTaskPane.clearDisplay();
        this.otherTaskPane.clearDisplay();
        this.ratingTaskPane.clearDisplay();
        this.commentTaskPane.clearDisplay();
        this.browserTaskPane.removeAll();
        this.browserTaskPane.setCollapsed(true);
        this.revalidate();
        this.repaint();
    }

    void setChannelData() {
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
            this.propertiesUI.setChannelData(this.model.getChannelData());
        }
    }

    boolean hasDataToSave() {
        for (AnnotationUI ui : this.components) {
            if (!ui.hasDataToSave()) continue;
            return true;
        }
        for (PreviewPanel pp : this.previews) {
            if (!pp.hasDataToSave()) continue;
            return true;
        }
        if (this.tagsTaskPane.hasDataToSave()) {
            return true;
        }
        if (this.mapTaskPane.hasDataToSave()) {
            return true;
        }
        if (this.attachmentTaskPane.hasDataToSave()) {
            return true;
        }
        if (this.otherTaskPane.hasDataToSave()) {
            return true;
        }
        if (this.ratingTaskPane.hasDataToSave()) {
            return true;
        }
        if (this.commentTaskPane.hasDataToSave()) {
            return true;
        }
        return this.nameModified;
    }

    void clearData(Object oldObject) {
        for (AnnotationUI ui : this.components) {
            ui.clearData(oldObject);
            ui.clearDisplay();
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.nameModified = false;
        this.idLabel.setText("");
        this.ownerLabel.setText("");
    }

    void handleTaskPaneCollapsed(JXTaskPane source) {
        if (source == null) {
            return;
        }
        if (source.equals(this.browserTaskPane)) {
            if (this.browserTaskPane.isCollapsed()) {
                this.loadParents(false);
            } else {
                this.browserTaskPane.removeAll();
                this.browserTaskPane.add((Component)this.model.getBrowser().getUI());
                this.loadParents(true);
            }
        }
    }

    boolean attachFiles(File[] files) {
        return ((AttachmentsTaskPaneUI)this.attachmentTaskPane.getTaskPaneUI()).attachFiles(files);
    }

    void removeAttachedFile(Object file) {
        ((AttachmentsTaskPaneUI)this.attachmentTaskPane.getTaskPaneUI()).removeAttachedFile(file);
    }

    List<FileAnnotationData> removeAttachedFiles() {
        return ((AttachmentsTaskPaneUI)this.attachmentTaskPane.getTaskPaneUI()).removeAttachedFiles();
    }

    List<TagAnnotationData> removeTags() {
        return ((TagsTaskPaneUI)this.tagsTaskPane.getTaskPaneUI()).removeTags();
    }

    List<AnnotationData> removeOtherAnnotations() {
        return ((OtherTaskPaneUI)this.otherTaskPane.getTaskPaneUI()).removeOtherAnnotation();
    }

    boolean hasAttachmentsToUnlink() {
        return ((AttachmentsTaskPaneUI)this.attachmentTaskPane.getTaskPaneUI()).hasAttachmentsToUnlink();
    }

    boolean hasTagsToUnlink() {
        return ((TagsTaskPaneUI)this.tagsTaskPane.getTaskPaneUI()).hasTagsToUnlink();
    }

    boolean hasOtherAnnotationsToUnlink() {
        return ((OtherTaskPaneUI)this.otherTaskPane.getTaskPaneUI()).hasOtherAnnotationsToUnlink();
    }

    void removeAnnotation(AnnotationData annotation) {
        if (annotation == null) {
            return;
        }
        ArrayList<AnnotationData> toKeep = new ArrayList<AnnotationData>();
        if (annotation instanceof TagAnnotationData) {
            List<TagAnnotationData> tags = this.getCurrentTagsSelection();
            for (AnnotationData annotationData : tags) {
                if (annotationData.getId() == annotation.getId()) continue;
                toKeep.add(annotationData);
            }
            this.handleObjectsSelection(TagAnnotationData.class, toKeep);
        } else if (annotation instanceof TermAnnotationData || annotation instanceof XMLAnnotationData || annotation instanceof BooleanAnnotationData || annotation instanceof LongAnnotationData || annotation instanceof DoubleAnnotationData) {
            List<AnnotationData> tags = this.getCurrentOtherSelection();
            for (AnnotationData annotationData : tags) {
                if (annotationData.getId() == annotation.getId()) continue;
                toKeep.add(annotationData);
            }
            this.handleObjectsSelection(AnnotationData.class, toKeep);
        } else if (annotation instanceof TextualAnnotationData) {
            ((CommentsTaskPaneUI)this.commentTaskPane.getTaskPaneUI()).removeTextualAnnotation((TextualAnnotationData)annotation);
        }
    }

    List<TagAnnotationData> getCurrentTagsSelection() {
        TagsTaskPaneUI p = (TagsTaskPaneUI)this.tagsTaskPane.getTaskPaneUI();
        return p.getCurrentSelection();
    }

    List<AnnotationData> getCurrentOtherSelection() {
        OtherTaskPaneUI p = (OtherTaskPaneUI)this.otherTaskPane.getTaskPaneUI();
        return p.getCurrentSelection();
    }

    void handleObjectsSelection(Class type, Collection objects) {
        if (objects == null) {
            return;
        }
        if (TagAnnotationData.class.equals((Object)type)) {
            ((TagsTaskPaneUI)this.tagsTaskPane.getTaskPaneUI()).handleObjectsSelection(type, objects, true);
        } else if (FileAnnotationData.class.equals((Object)type)) {
            ((AttachmentsTaskPaneUI)this.attachmentTaskPane.getTaskPaneUI()).handleObjectsSelection(type, objects, true);
        } else if (AnnotationData.class.equals((Object)type)) {
            ((OtherTaskPaneUI)this.otherTaskPane.getTaskPaneUI()).handleObjectsSelection(type, objects, true);
        }
    }

    void onRelatedNodesSet() {
        this.nameModified = false;
        this.tagsTaskPane.onRelatedNodesSet();
        this.roiTaskPane.onRelatedNodesSet();
        this.mapTaskPane.onRelatedNodesSet();
        this.attachmentTaskPane.onRelatedNodesSet();
        this.otherTaskPane.onRelatedNodesSet();
        this.ratingTaskPane.onRelatedNodesSet();
        this.commentTaskPane.onRelatedNodesSet();
    }

    public Collection<FileAnnotationData> getSelectedFileAnnotations() {
        AttachmentsTaskPaneUI p = (AttachmentsTaskPaneUI)this.attachmentTaskPane.getTaskPaneUI();
        return p.getSelectedFileAnnotations();
    }
}

