/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

public class AdminCreator
extends DataTreeViewerLoader {
    private AdminObject object;
    private CallHandle handle;

    public AdminCreator(TreeViewer viewer, SecurityContext ctx, AdminObject object) {
        super(viewer, ctx);
        if (object == null) {
            throw new IllegalArgumentException("No object");
        }
        this.object = object;
    }

    @Override
    public void load() {
        switch (this.object.getIndex()) {
            case 0: {
                this.handle = this.adminView.createGroup(this.ctx, this.object, this);
                break;
            }
            case 1: {
                this.handle = this.adminView.createExperimenters(this.ctx, this.object, this);
                break;
            }
            case 4: {
                this.handle = this.adminView.resetExperimentersPassword(this.ctx, this.object, this);
                break;
            }
            case 6: {
                this.handle = this.adminView.activateExperimenters(this.ctx, this.object, this);
                break;
            }
            case 5: {
                HashMap m = new HashMap();
                GroupData group = this.object.getGroup();
                Set<ExperimenterData> experimenters = this.object.getExperimenters().keySet();
                Set<ExperimenterData> existing = group.getExperimenters();
                ArrayList<Long> ids = new ArrayList<Long>();
                if (existing != null) {
                    for (DataObject dataObject : existing) {
                        ids.add(dataObject.getId());
                    }
                }
                HashSet<DataObject> toAdd = new HashSet<DataObject>();
                HashSet<DataObject> toRemove = new HashSet<DataObject>();
                Iterator<ExperimenterData> i = experimenters.iterator();
                ArrayList<Long> selectedIds = new ArrayList<Long>();
                while (i.hasNext()) {
                    DataObject dataObject = i.next();
                    long id = dataObject.getId();
                    selectedIds.add(id);
                    if (ids.contains(id)) continue;
                    toAdd.add(dataObject);
                }
                if (existing != null) {
                    for (DataObject dataObject : existing) {
                        if (selectedIds.contains(dataObject.getId())) continue;
                        toRemove.add(dataObject);
                    }
                }
                m.put(group, toAdd);
                HashMap<GroupData, HashSet<DataObject>> m1 = new HashMap<GroupData, HashSet<DataObject>>();
                m1.put(group, toRemove);
                this.handle = this.dmView.cutAndPaste(this.ctx, m, m1, true, this);
            }
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        switch (this.object.getIndex()) {
            case 0: 
            case 1: 
            case 5: {
                this.viewer.refreshTree();
                break;
            }
            case 4: {
                List l = (List)result;
                if (CollectionUtils.isNotEmpty((Collection)l)) {
                    Iterator i = l.iterator();
                    StringBuffer s = new StringBuffer();
                    while (i.hasNext()) {
                        ExperimenterData exp = (ExperimenterData)i.next();
                        s.append(exp.getUserName() + "\n");
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("The password could not be reset for ");
                    buffer.append("the following experimenters:\n");
                    buffer.append(s.toString());
                    un.notifyInfo("Reset password", buffer.toString());
                    break;
                }
                un.notifyInfo("Reset password", "The password has been reset.");
                break;
            }
            case 6: {
                List l = (List)result;
                if (CollectionUtils.isNotEmpty((Collection)l)) {
                    Iterator i = l.iterator();
                    StringBuffer s = new StringBuffer();
                    while (i.hasNext()) {
                        ExperimenterData exp = (ExperimenterData)i.next();
                        s.append(exp.getUserName());
                        s.append("\n");
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Not possible to reset the status of ");
                    buffer.append("the following experimenters:\n");
                    buffer.append(s.toString());
                    un.notifyInfo("Activate", buffer.toString());
                }
                this.viewer.refreshTree();
            }
        }
    }
}

