/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.event.AgentEventListener;

public class DataObjectUpdater
extends DataTreeViewerLoader {
    public static final int COPY_AND_PASTE = 0;
    public static final int CUT_AND_PASTE = 1;
    public static final int CUT = 2;
    private int index;
    private Map objectsToUpdate;
    private Map objectsToRemove;
    private CallHandle handle;

    private void checkIndex(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Action not supported.");
    }

    public DataObjectUpdater(TreeViewer viewer, SecurityContext ctx, Map objects, int index) {
        super(viewer, ctx);
        if (objects == null) {
            throw new IllegalArgumentException("No DataObject");
        }
        this.checkIndex(index);
        this.objectsToUpdate = objects;
        this.index = index;
    }

    public DataObjectUpdater(TreeViewer viewer, SecurityContext ctx, Map objects, Map toRemove, int index) {
        super(viewer, ctx);
        if (objects == null) {
            throw new IllegalArgumentException("No DataObject");
        }
        this.checkIndex(index);
        this.objectsToUpdate = objects;
        this.objectsToRemove = toRemove;
        this.index = index;
    }

    @Override
    public void load() {
        if (this.index == 0) {
            this.handle = this.dmView.addExistingObjects(this.ctx, this.objectsToUpdate, null, (AgentEventListener)this);
        } else if (this.index == 1 || this.index == 2) {
            boolean admin = false;
            Browser browser = this.viewer.getSelectedBrowser();
            if (browser != null) {
                admin = browser.getBrowserType() == 6;
            }
            this.handle = this.dmView.cutAndPaste(this.ctx, this.objectsToUpdate, this.objectsToRemove, admin, this);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        Object obj;
        Map m;
        if (this.viewer.getState() == 2) {
            return;
        }
        DataObject target = null;
        if (Map.class.isAssignableFrom(result.getClass()) && (m = (Map)result).size() == 1 && DataObject.class.isAssignableFrom((obj = m.keySet().iterator().next()).getClass())) {
            target = (DataObject)obj;
        }
        this.viewer.onNodesMoved(target);
    }
}

