/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.events.importer.LoadImporter;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class BrowserImportAction
extends BrowserAction {
    @Override
    protected void onStateChange() {
        switch (this.model.getState()) {
            case 11: 
            case 12: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(this.model.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        int t = this.model.getBrowserType();
        if (t == 0 || t == 1) {
            if (selectedDisplay == null) {
                this.setEnabled(true);
                return;
            }
            Object ho = selectedDisplay.getUserObject();
            if (ho == null) {
                this.setEnabled(true);
            } else if (ho instanceof ProjectData || ho instanceof DatasetData || ho instanceof ScreenData || ho instanceof ImageData) {
                this.setEnabled(this.model.canEdit(ho));
            } else if (ho instanceof ExperimenterData && t != 6) {
                ExperimenterData exp = TreeViewerAgent.getUserDetails();
                this.setEnabled(exp.getId() == ((ExperimenterData)ho).getId());
            } else {
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(false);
        }
    }

    public BrowserImportAction(Browser model) {
        super(model);
        switch (model.getBrowserType()) {
            case 1: {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText("Launch the Importer. Import data to Screen..."));
                break;
            }
            default: {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText("Launch the Importer. Import data to Project, Datasets..."));
            }
        }
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(90));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o;
        TreeImageDisplay display = this.model.getLastSelectedDisplay();
        if (display != null && (o = display.getUserObject()) instanceof ImageData) {
            TreeImageDisplay p = display.getParentDisplay();
            if (p == null) {
                return;
            }
            display = p;
        }
        LoadImporter event = null;
        int type = 0;
        switch (this.model.getBrowserType()) {
            case 1: {
                type = 1;
            }
        }
        event = new LoadImporter(display, type);
        event.setGroup(this.model.getSecurityContext(display).getGroupID());
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(event);
    }
}

