/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.List;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class BrowserManageAction
extends BrowserAction
implements MouseListener {
    public static final int NEW_TAGS = 0;
    public static final int NEW_CONTAINERS = 1;
    public static final int NEW_ADMIN = 2;
    public static final int COPY = 3;
    public static final int PASTE = 4;
    public static final int CUT = 5;
    private static final String DESCRIPTION_CONTAINERS = "Create new Project, Dataset or Screen.";
    private static final String DESCRIPTION_TAGS = "Create new Tag Set or Tag";
    private static final String DESCRIPTION_ADMIN = "Create new Group or User.";
    private static final String DESCRIPTION_COPY_LINK = "Copy link(s) to the selected element(s) into the clipboard.";
    private static final String DESCRIPTION_COPY = "Copy the selected element(s) into the clipboard.";
    private static final String DESCRIPTION_PASTE_LINK = "Paste link(s) from the clipboard.";
    private static final String DESCRIPTION_PASTE = "Paste element(s) from the clipboard.";
    private static final String DESCRIPTION_CUT_LINK = "Cut the selected link(s).";
    private static final String DESCRIPTION_CUT = "Cut the selected element(s).";
    private Point point;
    private int index;
    private long userID;

    private void checkIndex(int index) {
        IconManager im = IconManager.getInstance();
        switch (index) {
            case 1: {
                this.putValue("SmallIcon", im.getIcon(11));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CONTAINERS));
                break;
            }
            case 0: {
                this.putValue("SmallIcon", im.getIcon(69));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TAGS));
                break;
            }
            case 2: {
                this.putValue("SmallIcon", im.getIcon(11));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_ADMIN));
                break;
            }
            case 3: {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                this.putValue("SmallIcon", im.getIcon(24));
                break;
            }
            case 4: {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                this.putValue("SmallIcon", im.getIcon(25));
                break;
            }
            case 5: {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CUT));
                this.putValue("SmallIcon", im.getIcon(50));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    private void handleExperimenter(TreeImageDisplay display) {
        if (display == null) {
            this.setEnabled(false);
        } else {
            Object ho = display.getUserObject();
            long id = TreeViewerAgent.getUserDetails().getId();
            if (ho instanceof ExperimenterData) {
                ExperimenterData exp = (ExperimenterData)ho;
                this.setEnabled(exp.getId() == id);
            }
        }
    }

    private boolean isPasteValid(Object ho, List<DataObject> list) {
        Iterator<DataObject> i = list.iterator();
        int count = 0;
        while (i.hasNext()) {
            DataObject os = i.next();
            if (!EditorUtil.isTransferable(ho, os, this.userID)) {
                return false;
            }
            ++count;
        }
        return count == list.size();
    }

    private void handleSelection(TreeImageDisplay selectedDisplay) {
        Object ho = selectedDisplay.getUserObject();
        int count = 0;
        TreeImageDisplay parentDisplay = selectedDisplay.getParentDisplay();
        Object parent = null;
        if (parentDisplay != null) {
            parent = parentDisplay.getUserObject();
        }
        if (parentDisplay != null) {
            parent = parentDisplay.getUserObject();
        }
        switch (this.index) {
            case 4: {
                List<DataObject> list = this.model.getDataToCopy();
                if (list == null || list.size() == 0) {
                    this.setEnabled(false);
                    return;
                }
                if (ho instanceof ProjectData || ho instanceof ScreenData || ho instanceof DatasetData || ho instanceof GroupData || ho instanceof TagAnnotationData) {
                    TreeImageDisplay[] selected = this.model.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        ho = selected[i].getUserObject();
                        if (!this.isPasteValid(ho, list)) continue;
                        if (ho instanceof GroupData) {
                            ++count;
                            continue;
                        }
                        if (!this.model.canLink(ho)) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                if (ho instanceof ExperimenterData || ho instanceof GroupData) {
                    if (this.model.getBrowserType() == 6) break;
                    TreeImageDisplay[] selected = this.model.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        ho = selected[i].getUserObject();
                        if (!this.isPasteValid(ho, list)) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 3: 
            case 5: {
                if (ho instanceof DatasetData || ho instanceof ImageData || ho instanceof PlateData) {
                    TreeImageDisplay[] selected = this.model.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        if (!this.model.canLink(selected[i].getUserObject())) continue;
                        ++count;
                    }
                    if (this.index == 5) {
                        if (ho instanceof DatasetData) {
                            if (!(parent instanceof ProjectData)) {
                                this.setEnabled(false);
                                return;
                            }
                        } else if (ho instanceof ImageData) {
                            if (!(parent instanceof DatasetData) && !(parent instanceof TagAnnotationData)) {
                                this.setEnabled(false);
                                return;
                            }
                        } else if (ho instanceof PlateData && !(parent instanceof ScreenData)) {
                            this.setEnabled(false);
                            return;
                        }
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                if (ho instanceof ExperimenterData) {
                    this.setEnabled(this.model.getBrowserType() == 6);
                    break;
                }
                if (ho instanceof TagAnnotationData) {
                    TagAnnotationData tag = (TagAnnotationData)ho;
                    if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                        this.setEnabled(false);
                        break;
                    }
                    TreeImageDisplay[] selected = this.model.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        if (!this.model.canAnnotate(selected[i].getUserObject())) continue;
                        ++count;
                    }
                    if (this.index == 5 && !(parent instanceof TagAnnotationData)) {
                        this.setEnabled(false);
                        return;
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                this.setEnabled(false);
            }
        }
    }

    @Override
    protected void onStateChange() {
        switch (this.model.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(this.model.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        switch (this.index) {
            case 0: 
            case 1: 
            case 2: {
                this.setEnabled(TreeViewerAgent.canCreate());
                return;
            }
        }
        if (this.model.getBrowserType() == 6) {
            this.setEnabled(TreeViewerAgent.isAdministrator());
            return;
        }
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        this.adaptActionNameDescription(this.model.getBrowserType());
        if (selectedDisplay == null) {
            this.handleExperimenter(this.model.getLastSelectedDisplay());
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof ExperimenterData) {
            this.handleExperimenter(selectedDisplay);
            return;
        }
        switch (this.index) {
            case 3: 
            case 4: 
            case 5: {
                this.handleSelection(selectedDisplay);
                break;
            }
            default: {
                if (ho instanceof ExperimenterData) {
                    long id = TreeViewerAgent.getUserDetails().getId();
                    ExperimenterData exp = (ExperimenterData)ho;
                    this.setEnabled(exp.getId() == id);
                    break;
                }
                this.setEnabled(this.model.canLink(ho));
            }
        }
    }

    private void adaptActionNameDescription(int browserType) {
        if (browserType == 6) {
            switch (this.index) {
                case 5: {
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CUT));
                    break;
                }
                case 3: {
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                    break;
                }
                case 4: {
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                }
            }
        } else {
            switch (this.index) {
                case 5: {
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CUT_LINK));
                    break;
                }
                case 3: {
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY_LINK));
                    break;
                }
                case 4: {
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE_LINK));
                }
            }
        }
    }

    public BrowserManageAction(Browser model, int index) {
        super(model);
        this.checkIndex(index);
        this.index = index;
        this.setEnabled(false);
        this.userID = TreeViewerAgent.getUserDetails().getId();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 3: {
                this.model.setNodesToCopy(this.model.getSelectedDisplays(), 400);
                break;
            }
            case 4: {
                this.model.paste(this.model.getSelectedDisplays());
                break;
            }
            case 5: {
                this.model.setNodesToCopy(this.model.getSelectedDisplays(), 401);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (this.point == null) {
            this.point = me.getPoint();
        }
        if (source instanceof Component && this.isEnabled()) {
            switch (this.index) {
                case 0: {
                    this.model.showMenu(4, (Component)source, this.point);
                    break;
                }
                case 1: {
                    if (this.model.getBrowserType() == 0) {
                        this.model.showMenu(3, (Component)source, this.point);
                        break;
                    }
                    this.model.showMenu(8, (Component)source, this.point);
                    break;
                }
                case 2: {
                    this.model.showMenu(6, (Component)source, this.point);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

